/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odatav4.generator;

import com.sap.cloud.sdk.datamodel.odatav4.generator.ODataGeneratorException;
import com.sap.cloud.sdk.datamodel.odatav4.generator.annotation.AnnotationDefinition;
import com.sap.cloud.sdk.datamodel.odatav4.generator.annotation.AnnotationParameter;
import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationUse;
import java.util.Set;

class AnnotationHelper {
    AnnotationHelper() {
    }

    static void addAnnotationToJavaItem(AnnotationDefinition annotation, JAnnotatable javaItem) {
        JAnnotationUse appliedAnnotation = javaItem.annotate(annotation.getAnnotationClass());
        for (AnnotationParameter parameter : annotation.getAnnotationParameters()) {
            Object parameterValue = parameter.getValue();
            if (parameterValue instanceof Class) {
                appliedAnnotation.param(parameter.getName(), (Class)parameterValue);
                continue;
            }
            if (parameterValue instanceof Enum) {
                appliedAnnotation.param(parameter.getName(), (Enum)parameterValue);
                continue;
            }
            if (parameterValue instanceof String) {
                appliedAnnotation.param(parameter.getName(), (String)parameterValue);
                continue;
            }
            if (parameterValue instanceof Character) {
                appliedAnnotation.param(parameter.getName(), ((Character)parameterValue).charValue());
                continue;
            }
            if (parameterValue instanceof Byte) {
                appliedAnnotation.param(parameter.getName(), ((Byte)parameterValue).byteValue());
                continue;
            }
            if (parameterValue instanceof Boolean) {
                appliedAnnotation.param(parameter.getName(), ((Boolean)parameterValue).booleanValue());
                continue;
            }
            if (parameterValue instanceof Double) {
                appliedAnnotation.param(parameter.getName(), ((Double)parameterValue).doubleValue());
                continue;
            }
            if (parameterValue instanceof Float) {
                appliedAnnotation.param(parameter.getName(), ((Float)parameterValue).floatValue());
                continue;
            }
            if (parameterValue instanceof Long) {
                appliedAnnotation.param(parameter.getName(), ((Long)parameterValue).longValue());
                continue;
            }
            if (parameterValue instanceof Integer) {
                appliedAnnotation.param(parameter.getName(), ((Integer)parameterValue).intValue());
                continue;
            }
            if (parameterValue instanceof Short) {
                appliedAnnotation.param(parameter.getName(), ((Short)parameterValue).shortValue());
                continue;
            }
            throw new ODataGeneratorException(String.format("Annotation parameter value for %s has an unsupported type of %s.Please make sure to only use the exposed constructors of the AnnotationParameter class.", parameter.getName(), parameterValue.getClass().getName()));
        }
    }

    static void addAllAnnotationsToJavaItem(Set<AnnotationDefinition> annotations, JAnnotatable javaItem) {
        for (AnnotationDefinition ad : annotations) {
            AnnotationHelper.addAnnotationToJavaItem(ad, javaItem);
        }
    }
}

