/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.sdk.AttachmentRequirement;
import com.silanis.esl.sdk.RequirementStatus;
import com.silanis.esl.sdk.internal.Asserts;

public final class AttachmentRequirementBuilder {
    private String description;
    private final String name;
    private boolean isRequired;

    private AttachmentRequirementBuilder(String name) {
        this.name = name;
    }

    public static AttachmentRequirementBuilder newAttachmentRequirementWithName(String name) {
        return new AttachmentRequirementBuilder(name);
    }

    public AttachmentRequirementBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public AttachmentRequirementBuilder isRequiredAttachment() {
        this.isRequired = true;
        return this;
    }

    public AttachmentRequirement build() {
        Asserts.notNullOrEmpty(this.name, "name");
        AttachmentRequirement attachmentRequirement = new AttachmentRequirement(this.name);
        attachmentRequirement.setDescription(this.description);
        attachmentRequirement.setRequired(this.isRequired);
        attachmentRequirement.setStatus(RequirementStatus.INCOMPLETE);
        return attachmentRequirement;
    }
}

