/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.sdk.CustomField;
import com.silanis.esl.sdk.Translation;
import com.silanis.esl.sdk.builder.TranslationBuilder;
import java.util.ArrayList;
import java.util.List;

public class CustomFieldBuilder {
    private String id;
    private String value;
    private List<Translation> translations;
    private Boolean required = Boolean.TRUE;

    public static CustomFieldBuilder customFieldWithId(String id) {
        return new CustomFieldBuilder().withId(id);
    }

    public CustomFieldBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public CustomFieldBuilder withDefaultValue(String value) {
        this.value = value;
        return this;
    }

    public CustomFieldBuilder withTranslation(TranslationBuilder builder) {
        return this.withTranslation(builder.build());
    }

    public CustomFieldBuilder withTranslation(Translation translation) {
        if (this.translations == null) {
            this.translations = new ArrayList<Translation>();
        }
        this.translations.add(translation);
        return this;
    }

    public CustomFieldBuilder withTranslations(List<Translation> translations) {
        if (this.translations == null) {
            this.translations = new ArrayList<Translation>();
        }
        this.translations.addAll(translations);
        return this;
    }

    public CustomFieldBuilder isRequired(Boolean required) {
        this.required = required;
        return this;
    }

    public CustomField build() {
        CustomField customField = new CustomField();
        customField.setId(this.id);
        customField.setValue(this.value);
        customField.setRequired(this.required);
        customField.setTranslations(this.translations);
        return customField;
    }
}

