/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.google.common.base.Optional;
import com.silanis.esl.sdk.DocumentVisibility;
import com.silanis.esl.sdk.DocumentVisibilityConfiguration;
import com.silanis.esl.sdk.builder.DocumentVisibilityConfigurationBasedOnSignerBuilder;
import com.silanis.esl.sdk.builder.DocumentVisibilityConfigurationBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DocumentVisibilityBasedOnSignerBuilder {
    private List<DocumentVisibilityConfiguration> configurations = new ArrayList<DocumentVisibilityConfiguration>();
    private List<DocumentVisibilityConfigurationBasedOnSignerBuilder> configurationBuilders = new ArrayList<DocumentVisibilityConfigurationBasedOnSignerBuilder>();

    public static DocumentVisibilityBasedOnSignerBuilder newDocumentVisibilityBasedOnSigner() {
        return new DocumentVisibilityBasedOnSignerBuilder();
    }

    public DocumentVisibilityBasedOnSignerBuilder withConfigurations(List<DocumentVisibilityConfigurationBasedOnSignerBuilder> configurationBuilders) {
        this.configurationBuilders = configurationBuilders;
        return this;
    }

    public DocumentVisibilityBasedOnSignerBuilder addConfiguration(DocumentVisibilityConfigurationBasedOnSignerBuilder builder) {
        this.configurationBuilders.add(builder);
        return this;
    }

    public DocumentVisibility build() {
        DocumentVisibility visibility = new DocumentVisibility();
        visibility.setConfigurations(this.convertToDocumentVisibilityConfigurations());
        return visibility;
    }

    private List<DocumentVisibilityConfiguration> convertToDocumentVisibilityConfigurations() {
        if (this.configurationBuilders == null || this.configurationBuilders.isEmpty()) {
            return Collections.emptyList();
        }
        for (DocumentVisibilityConfigurationBasedOnSignerBuilder builder : this.configurationBuilders) {
            for (String documentId : builder.getDocumentIds()) {
                this.mergeConfiguration(DocumentVisibilityConfigurationBuilder.newDocumentVisibilityConfiguration(documentId).withSignerId(builder.getSignerId()).build());
            }
        }
        return this.configurations;
    }

    private void mergeConfiguration(DocumentVisibilityConfiguration configuration) {
        Optional<DocumentVisibilityConfiguration> configurationOptional = this.findSameDocumentIdConfiguration(configuration);
        if (configurationOptional.isPresent()) {
            List<String> signerIds = ((DocumentVisibilityConfiguration)configurationOptional.get()).getSignerIds();
            signerIds.removeAll(configuration.getSignerIds());
            signerIds.addAll(configuration.getSignerIds());
        } else {
            this.configurations.add(configuration);
        }
    }

    private Optional<DocumentVisibilityConfiguration> findSameDocumentIdConfiguration(DocumentVisibilityConfiguration configuration) {
        for (DocumentVisibilityConfiguration documentVisibilityConfiguration : this.configurations) {
            if (!StringUtils.equals((CharSequence)documentVisibilityConfiguration.getDocumentUid(), (CharSequence)configuration.getDocumentUid())) continue;
            return Optional.of((Object)documentVisibilityConfiguration);
        }
        return Optional.absent();
    }
}

