/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.sdk.ProxyConfiguration;
import com.silanis.esl.sdk.builder.BuilderException;

public class ProxyConfigurationBuilder {
    private String httpHost;
    private int httpPort;
    private String httpsHost;
    private int httpsPort;
    private String userName;
    private String password;

    private ProxyConfigurationBuilder() {
    }

    public static ProxyConfigurationBuilder newProxyConfiguration() {
        return new ProxyConfigurationBuilder();
    }

    public ProxyConfigurationBuilder withHttpHost(String httpHost) {
        this.httpHost = httpHost;
        return this;
    }

    public ProxyConfigurationBuilder withHttpPort(int httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    public ProxyConfigurationBuilder withHttpsHost(String httpsHost) {
        this.httpsHost = httpsHost;
        return this;
    }

    public ProxyConfigurationBuilder withHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
        return this;
    }

    public ProxyConfigurationBuilder withCredentials(String userName, String password) {
        this.userName = userName;
        this.password = password;
        return this;
    }

    public ProxyConfiguration build() {
        this.validate();
        ProxyConfiguration result = new ProxyConfiguration();
        if (this.isHttpProxy()) {
            result.setHttpHost(this.httpHost);
            result.setHttpPort(this.httpPort);
            result.setHttpScheme();
        } else if (this.isHttpsProxy()) {
            result.setHttpsHost(this.httpsHost);
            result.setHttpsPort(this.httpsPort);
            result.setHttpsScheme();
        }
        if (this.isCredentialsNotNull()) {
            result.setUserName(this.userName);
            result.setPassword(this.password);
            result.setCredentials(true);
        }
        return result;
    }

    private void validate() {
        if (this.isHttpProxy() && (this.httpsHost != null || this.httpsPort != 0) || this.isHttpsProxy() && (this.httpHost != null || this.httpPort != 0)) {
            throw new BuilderException("Cannot set up both the http and https proxy, Use either http or https.");
        }
        if (this.httpHost != null && this.httpPort == 0 || this.httpHost == null && this.httpPort != 0 || this.httpsHost != null && this.httpsPort == 0 || this.httpsHost == null && this.httpsPort != 0) {
            throw new BuilderException("Neither http nor https proxy is setup.");
        }
    }

    private boolean isCredentialsNotNull() {
        return this.userName != null && this.password != null;
    }

    private boolean isHttpsProxy() {
        return this.httpsHost != null && this.httpsPort != 0;
    }

    private boolean isHttpProxy() {
        return this.httpHost != null && this.httpPort != 0;
    }
}

