/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.Placeholder;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ChangePlaceholderNameExample
extends SDKSample {
    public static final String DOCUMENT_NAME = "First Document";
    public static final String DOCUMENT_ID = "doc1";
    public static final String TEMPLATE_NAME = "ChangePlaceholderNameExample Template: " + new SimpleDateFormat("HH:mm:ss").format(new Date());
    public static final String TEMPLATE_DESCRIPTION = "This is a template created using the eSignLive SDK";
    public static final String TEMPLATE_EMAIL_MESSAGE = "This message should be delivered to all signers";
    public static final String TEMPLATE_SIGNER_FIRST = "John";
    public static final String TEMPLATE_SIGNER_LAST = "Smith";
    public static final String PLACEHOLDER_ID = "placeholderId";
    public Placeholder newPlaceholder;
    public Placeholder updatedPlaceholder;
    public DocumentPackage updatedTemplate;

    public static void main(String ... args) {
        new ChangePlaceholderNameExample().run();
    }

    @Override
    public void execute() {
        this.newPlaceholder = new Placeholder(PLACEHOLDER_ID, "placeholderName");
        this.updatedPlaceholder = new Placeholder(PLACEHOLDER_ID, "updatedPlaceholderName");
        DocumentPackage template = PackageBuilder.newPackageNamed(TEMPLATE_NAME).describedAs(TEMPLATE_DESCRIPTION).withEmailMessage(TEMPLATE_EMAIL_MESSAGE).withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName(TEMPLATE_SIGNER_FIRST).withLastName(TEMPLATE_SIGNER_LAST)).withSigner(SignerBuilder.newSignerPlaceholder(this.newPlaceholder)).withDocument(DocumentBuilder.newDocumentWithName(DOCUMENT_NAME).withId(DOCUMENT_ID).fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0)).withSignature(SignatureBuilder.signatureFor(this.newPlaceholder).onPage(0).atPosition(400.0, 100.0))).build();
        PackageId templateId = this.eslClient.getTemplateService().createTemplate(template);
        this.retrievedPackage = this.eslClient.getPackage(templateId);
        this.eslClient.getTemplateService().updatePlaceholder(templateId, this.updatedPlaceholder);
        this.updatedTemplate = this.eslClient.getPackage(templateId);
    }
}

