/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.ConditionalField;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.FieldCondition;
import com.silanis.esl.sdk.FieldId;
import com.silanis.esl.sdk.FieldStyle;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.SignatureId;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.FieldBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.util.ArrayList;

public class ConditionalFieldExample
extends SDKSample {
    private final String documentId = "DocumentId";
    private final SignatureId signatureId = new SignatureId("signatureId");
    private final FieldId fieldId1 = new FieldId("fieldId1");
    private final FieldId fieldId2 = new FieldId("fieldId2");
    public DocumentPackage retrievedPackageWithoutConditions;
    public DocumentPackage retrievedPackageWithUpdatedConditions;

    public static void main(String ... args) {
        new ConditionalFieldExample().run();
    }

    @Override
    protected void execute() {
        FieldCondition condition = new FieldCondition();
        condition.setId("ConditionId");
        condition.setCondition("document['DocumentId'].field['fieldId2'].value == 'X'");
        condition.setAction("document['DocumentId'].field['fieldId1'].disabled = false");
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(this.getPackageName()).describedAs("Description").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName("Patty").withLastName("Galant")).withDocument(DocumentBuilder.newDocumentWithName("Document").withId("DocumentId").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).withId(this.signatureId).onPage(0).atPosition(400.0, 100.0).withField(FieldBuilder.textField().withId(this.fieldId1).onPage(0).atPosition(0.0, 0.0)).withField(FieldBuilder.checkBox().withId(this.fieldId2).onPage(0).atPosition(0.0, 0.0)))).withCondition(condition).build();
        PackageId packageId = this.eslClient.createPackageOneStep(superDuperPackage);
        this.retrievedPackage = this.eslClient.getPackage(packageId);
        FieldCondition newCondition = new FieldCondition();
        newCondition.setId("ConditionId");
        newCondition.setCondition("document['DocumentId'].field['fieldId2'].value == 'X'");
        newCondition.setAction("document['DocumentId'].field['fieldId1'].disabled = true");
        ArrayList<FieldCondition> conditions = new ArrayList<FieldCondition>();
        conditions.add(newCondition);
        ConditionalField conditionalField = new ConditionalField();
        conditionalField.setId(this.fieldId2);
        conditionalField.setConditions(conditions);
        conditionalField.setStyle(FieldStyle.UNBOUND_CHECK_BOX);
        this.eslClient.getApprovalService().updateConditionalField(packageId, "DocumentId", this.signatureId, conditionalField);
        this.retrievedPackageWithUpdatedConditions = this.eslClient.getPackage(packageId);
        conditions.clear();
        conditionalField.setConditions(conditions);
        this.eslClient.getApprovalService().updateConditionalField(packageId, "DocumentId", this.signatureId, conditionalField);
        this.retrievedPackageWithoutConditions = this.eslClient.getPackage(packageId);
    }
}

