/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.FieldBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import org.joda.time.DateMidnight;

public class DocumentOperationsExample
extends SDKSample {
    public DocumentPackage builtPackage;
    public DocumentPackage retrievedPackage;
    public DocumentPackage retrievedPackageWithNewDocument;
    public Document retrievedUpdatedDocument;
    public DocumentPackage retrievedPackageWithUpdatedDocument;
    public DocumentPackage retrievedPackageWithDeletedDocument;
    public static final String ORIGINAL_DOCUMENT_NAME = "Original Document Name";
    public static final String UPDATED_DOCUMENT_NAME = "Updated Document Name";
    public static final String ORIGINAL_DOCUMENT_DESCRIPTION = "Original Document Description";
    public static final String UPDATED_DOCUMENT_DESCRIPTION = "Updated Document Description";

    public static void main(String ... args) {
        new DocumentOperationsExample().run();
    }

    @Override
    public void execute() {
        this.builtPackage = PackageBuilder.newPackageNamed(this.getPackageName()).describedAs("This is a package demonstrating document upload").expiresAt(DateMidnight.now().plusMonths(1).toDate()).withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName("John").withLastName("Smith").withTitle("Managing Director").withCompany("Acme Inc.")).build();
        this.packageId = this.eslClient.createPackage(this.builtPackage);
        this.retrievedPackage = this.eslClient.getPackage(this.packageId);
        Document document = DocumentBuilder.newDocumentWithName(ORIGINAL_DOCUMENT_NAME).fromStream(this.documentInputStream1, DocumentType.PDF).withId("documentId").withSignature(SignatureBuilder.signatureFor(this.email1).atPosition(100.0, 100.0).onPage(0).withField(FieldBuilder.textField().onPage(0).atPosition(200.0, 200.0))).withDescription(ORIGINAL_DOCUMENT_DESCRIPTION).build();
        this.eslClient.uploadDocument(document.getFileName(), document.getContent(), document, this.packageId);
        this.retrievedPackageWithNewDocument = this.eslClient.getPackage(this.packageId);
        document.setName(UPDATED_DOCUMENT_NAME);
        document.setDescription(UPDATED_DOCUMENT_DESCRIPTION);
        this.eslClient.getPackageService().updateDocumentMetadata(this.retrievedPackage, document);
        this.retrievedUpdatedDocument = this.eslClient.getPackageService().getDocumentMetadata(this.retrievedPackage, document.getId().getId());
        this.retrievedPackageWithUpdatedDocument = this.eslClient.getPackage(this.packageId);
        this.eslClient.getPackageService().deleteDocument(this.packageId, document.getId().toString());
        this.retrievedPackageWithDeletedDocument = this.eslClient.getPackage(this.packageId);
    }
}

