/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.DocumentVisibility;
import com.silanis.esl.sdk.Signer;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.DocumentVisibilityBuilder;
import com.silanis.esl.sdk.builder.DocumentVisibilityConfigurationBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class DocumentVisibilityExample
extends SDKSample {
    private InputStream documentInputStream1;
    private InputStream documentInputStream2;
    private InputStream documentInputStream3;
    public static final String DOC1_ID = "doc1Id";
    public static final String DOC2_ID = "doc2Id";
    public static final String DOC3_ID = "doc3Id";
    public static final String DOC1_NAME = "First Document";
    public static final String DOC2_NAME = "Second Document";
    public static final String DOC3_NAME = "Third Document";
    public static final String SIGNER1_ID = "signer1Id";
    public static final String SIGNER2_ID = "signer2Id";
    public static final String SIGNER3_ID = "signer3Id";
    public DocumentVisibility retrievedVisibility;
    public List<Document> documentsForSigner1;
    public List<Document> documentsForSigner2;
    public List<Document> documentsForSigner3;
    public List<Signer> signersForDocument1;
    public List<Signer> signersForDocument2;
    public List<Signer> signersForDocument3;

    public static void main(String ... args) {
        new DocumentVisibilityExample().run();
    }

    @Override
    public void execute() {
        this.documentInputStream1 = this.getClass().getClassLoader().getResourceAsStream("document.pdf");
        this.documentInputStream2 = this.getClass().getClassLoader().getResourceAsStream("document.pdf");
        this.documentInputStream3 = this.getClass().getClassLoader().getResourceAsStream("document.pdf");
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed("DocumentVisibilityExample " + new SimpleDateFormat("HH:mm:ss").format(new Date())).describedAs("This is a package created using the e-SignLive SDK").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withCustomId(SIGNER1_ID).withFirstName("John1").withLastName("Smith1")).withSigner(SignerBuilder.newSignerWithEmail(this.email2).withCustomId(SIGNER2_ID).withFirstName("John2").withLastName("Smith2")).withSigner(SignerBuilder.newSignerWithEmail(this.email3).withCustomId(SIGNER3_ID).withFirstName("John3").withLastName("Smith3")).withDocument(DocumentBuilder.newDocumentWithName(DOC1_NAME).withId(DOC1_ID).fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0))).withDocument(DocumentBuilder.newDocumentWithName(DOC2_NAME).withId(DOC2_ID).fromStream(this.documentInputStream2, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email2).onPage(0).atPosition(100.0, 100.0))).withDocument(DocumentBuilder.newDocumentWithName(DOC3_NAME).withId(DOC3_ID).fromStream(this.documentInputStream3, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email3).onPage(0).atPosition(100.0, 100.0))).build();
        this.packageId = this.eslClient.createPackage(superDuperPackage);
        DocumentVisibility visibility = DocumentVisibilityBuilder.newDocumentVisibility().addConfiguration(DocumentVisibilityConfigurationBuilder.newDocumentVisibilityConfiguration(DOC1_ID).withSignerIds(Arrays.asList(SIGNER1_ID, SIGNER3_ID))).addConfiguration(DocumentVisibilityConfigurationBuilder.newDocumentVisibilityConfiguration(DOC2_ID).withSignerIds(Arrays.asList(SIGNER2_ID, SIGNER3_ID))).addConfiguration(DocumentVisibilityConfigurationBuilder.newDocumentVisibilityConfiguration(DOC3_ID).withSignerIds(Arrays.asList(SIGNER3_ID, SIGNER2_ID))).build();
        this.eslClient.configureDocumentVisibility(this.packageId, visibility);
        this.retrievedVisibility = this.eslClient.getDocumentVisibility(this.packageId);
        this.eslClient.sendPackage(this.packageId);
        this.retrievedPackage = this.eslClient.getPackage(this.packageId);
        this.documentsForSigner1 = this.eslClient.getDocuments(this.packageId, SIGNER1_ID);
        this.documentsForSigner2 = this.eslClient.getDocuments(this.packageId, SIGNER2_ID);
        this.documentsForSigner3 = this.eslClient.getDocuments(this.packageId, SIGNER3_ID);
        this.signersForDocument1 = this.eslClient.getSigners(this.packageId, DOC1_ID);
        this.signersForDocument2 = this.eslClient.getSigners(this.packageId, DOC2_ID);
        this.signersForDocument3 = this.eslClient.getSigners(this.packageId, DOC3_ID);
    }
}

