/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.Group;
import com.silanis.esl.sdk.GroupId;
import com.silanis.esl.sdk.GroupMember;
import com.silanis.esl.sdk.GroupMemberType;
import com.silanis.esl.sdk.builder.AccountMemberBuilder;
import com.silanis.esl.sdk.builder.AddressBuilder;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.GroupBuilder;
import com.silanis.esl.sdk.builder.GroupMemberBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.util.List;
import java.util.UUID;

public class GroupManagementExample
extends SDKSample {
    public List<String> groupMemberEmailsAfterUpdate;
    public static final String GROUP_NAME_PREFIX = "GROUP_";
    public static final String EMAIL = "bob@aol.com";
    public Group createdGroup1;
    public Group retrievedGroup1;
    public Group createdGroup2;
    public Group retrievedGroup2;
    public Group createdGroup3;
    public Group retrievedGroup3;
    public Group createdGroup3Updated;
    public List<Group> retrievedGroupByName1;
    public List<Group> retrievedByNamePrefix;

    public static void main(String ... args) {
        new GroupManagementExample().run();
    }

    private void displayAccountGroupsAndMembers() {
        List<Group> allGroups = this.eslClient.getGroupService().getMyGroups();
        for (Group group : allGroups) {
            System.out.println(group.getName() + " with email " + group.getEmail() + " and id " + group.getId());
            List<GroupMember> allMembers = this.eslClient.getGroupService().getGroupMembers(group.getId());
            for (GroupMember member : allMembers) {
                System.out.println(member.getGroupMemberType().toString() + " " + member.getFirstName() + " " + member.getLastName() + " with email " + member.getEmail());
            }
        }
    }

    private void inviteAccountMember(String email) {
        try {
            this.eslClient.getAccountService().inviteUser(AccountMemberBuilder.newAccountMember(email).withPhoneNumber("1234567890").withLanguage("en").withTitle("title").withCompany("company").withFirstName("firstName").withLastName("lastName").withAddress(AddressBuilder.newAddress().withAddress1("address1").withAddress2("address2").withZipCode("zipcode").withState("state").withCountry("country").withCity("city")).build());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void execute() {
        this.email1 = this.getRandomEmail();
        this.email2 = this.getRandomEmail();
        this.email3 = this.getRandomEmail();
        this.email4 = this.getRandomEmail();
        this.inviteAccountMember(this.email1);
        this.inviteAccountMember(this.email2);
        this.inviteAccountMember(this.email3);
        this.inviteAccountMember(this.email4);
        String groupName = UUID.randomUUID().toString();
        Group group1 = GroupBuilder.newGroup(GROUP_NAME_PREFIX + groupName).withId(new GroupId(UUID.randomUUID().toString())).withMember(GroupMemberBuilder.newGroupMember(this.email1).as(GroupMemberType.MANAGER)).withEmail(EMAIL).withIndividualMemberEmailing().build();
        this.createdGroup1 = this.eslClient.getGroupService().createGroup(group1);
        this.retrievedGroup1 = this.eslClient.getGroupService().getGroup(this.createdGroup1.getId());
        this.retrievedGroupByName1 = this.eslClient.getGroupService().getMyGroups(groupName);
        GroupMember groupMemberAdded = this.eslClient.getGroupService().addMember(this.createdGroup1.getId(), GroupMemberBuilder.newGroupMember(this.email3).as(GroupMemberType.MANAGER).build());
        Group groupMemberInvited = this.eslClient.getGroupService().inviteMember(this.createdGroup1.getId(), GroupMemberBuilder.newGroupMember(this.email4).as(GroupMemberType.MANAGER).build());
        groupName = UUID.randomUUID().toString();
        Group group2 = GroupBuilder.newGroup(GROUP_NAME_PREFIX + groupName).withMember(GroupMemberBuilder.newGroupMember(this.email2).as(GroupMemberType.MANAGER)).withEmail(EMAIL).withIndividualMemberEmailing().build();
        this.createdGroup2 = this.eslClient.getGroupService().createGroup(group2);
        this.retrievedGroup2 = this.eslClient.getGroupService().getGroup(this.createdGroup2.getId());
        groupName = UUID.randomUUID().toString();
        Group group3 = GroupBuilder.newGroup(GROUP_NAME_PREFIX + groupName).withMember(GroupMemberBuilder.newGroupMember(this.email3).as(GroupMemberType.MANAGER)).withEmail(EMAIL).withIndividualMemberEmailing().build();
        this.createdGroup3 = this.eslClient.getGroupService().createGroup(group3);
        this.retrievedGroup3 = this.eslClient.getGroupService().getGroup(this.createdGroup3.getId());
        this.retrievedByNamePrefix = this.eslClient.getGroupService().getMyGroups(GROUP_NAME_PREFIX);
        Group groupUpdated = GroupBuilder.newGroup(UUID.randomUUID().toString()).withMember(GroupMemberBuilder.newGroupMember(this.email2).as(GroupMemberType.MANAGER)).withMember(GroupMemberBuilder.newGroupMember(this.email3).as(GroupMemberType.REGULAR)).withMember(GroupMemberBuilder.newGroupMember(this.email4).as(GroupMemberType.REGULAR)).withEmail(EMAIL).withIndividualMemberEmailing().build();
        this.createdGroup3Updated = this.eslClient.getGroupService().updateGroup(groupUpdated, this.createdGroup3.getId());
        this.groupMemberEmailsAfterUpdate = this.eslClient.getGroupService().getGroupMemberEmails(this.createdGroup3.getId());
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(this.getPackageName()).withSigner(SignerBuilder.newSignerFromGroup(this.createdGroup1.getId()).canChangeSigner().deliverSignedDocumentsByEmail()).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.captureFor(this.createdGroup1.getId()).onPage(0).atPosition(100.0, 100.0))).build();
        this.packageId = this.eslClient.createPackage(superDuperPackage);
        this.eslClient.sendPackage(this.packageId);
        this.eslClient.getPackageService().notifySigner(this.packageId, this.createdGroup1.getId());
        DocumentPackage result = this.eslClient.getPackage(this.packageId);
        this.eslClient.getGroupService().deleteGroup(this.createdGroup1.getId());
        this.eslClient.getGroupService().deleteGroup(this.createdGroup2.getId());
        this.eslClient.getGroupService().deleteGroup(this.createdGroup3.getId());
    }
}

