/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.ReminderSchedule;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.ReminderScheduleBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;

public class ReminderExample
extends SDKSample {
    public ReminderSchedule reminderScheduleToCreate;
    public ReminderSchedule reminderScheduleToUpdate;
    public ReminderSchedule createdReminderSchedule;
    public ReminderSchedule updatedReminderSchedule;
    public ReminderSchedule removedReminderSchedule;

    public static void main(String ... args) {
        new ReminderExample().run();
    }

    @Override
    public void execute() {
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(this.getPackageName()).withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName("Patty").withLastName("Galant")).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0))).build();
        this.packageId = this.eslClient.createPackage(superDuperPackage);
        this.reminderScheduleToCreate = ReminderScheduleBuilder.forPackageWithId(this.packageId).withDaysUntilFirstReminder(2).withDaysBetweenReminders(1).withNumberOfRepetitions(5).build();
        this.eslClient.getReminderService().createReminderScheduleForPackage(this.reminderScheduleToCreate);
        this.eslClient.sendPackage(this.packageId);
        this.createdReminderSchedule = this.eslClient.getReminderService().getReminderScheduleForPackage(this.packageId);
        this.reminderScheduleToUpdate = ReminderScheduleBuilder.forPackageWithId(this.packageId).withDaysUntilFirstReminder(3).withDaysBetweenReminders(2).withNumberOfRepetitions(10).build();
        this.eslClient.getReminderService().updateReminderScheduleForPackage(this.reminderScheduleToUpdate);
        this.updatedReminderSchedule = this.eslClient.getReminderService().getReminderScheduleForPackage(this.packageId);
        this.eslClient.getReminderService().clearReminderScheduleForPackage(this.packageId);
        this.removedReminderSchedule = this.eslClient.getReminderService().getReminderScheduleForPackage(this.packageId);
    }
}

