/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.EslClient;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.ProxyConfiguration;
import com.silanis.esl.sdk.apitoken.ApiTokenConfig;
import com.silanis.esl.sdk.examples.Props;
import com.silanis.esl.sdk.internal.Converter;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public abstract class SDKSample {
    protected EslClient eslClient;
    protected PackageId packageId;
    protected String packageName;
    protected DocumentPackage retrievedPackage;
    protected InputStream documentInputStream1;
    protected InputStream documentInputStream2;
    protected Properties props = Props.get();
    public String email1;
    public String email2;
    public String email3;
    public String email4;
    public String email5;
    public String email6;
    public String senderEmail;
    public String sms1;
    public String sms2;
    public String sms3;
    public String sms4;
    public String sms5;
    public String sms6;
    public String senderSms;
    public String webpageUrl;
    public String senderUID;
    public String proxyHost;
    public String proxyWithCredentialsHost;
    public String proxyUserName;
    public String proxyPassword;
    public int proxyPort;
    public int proxyWithCredentialsPort;

    public SDKSample() {
        this.setupEslClientFromProps(Collections.<String, String>emptyMap(), null);
        this.setProperties();
    }

    public SDKSample(String apiKey, String apiUrl) {
        this.eslClient = new EslClient(apiKey, apiUrl);
        this.setProperties();
    }

    public EslClient setupEslClientFromProps(Map<String, String> additionalHeaders, ProxyConfiguration proxyConfiguration) {
        if (this.props.getProperty("api.clientId") == null) {
            this.eslClient = new EslClient(this.props.getProperty("api.key"), this.props.getProperty("api.url"), true, proxyConfiguration).setWebpageURL(this.props.getProperty("webpage.url"));
        } else {
            ApiTokenConfig apiTokenConfig = ApiTokenConfig.newBuilder().clientAppId(this.props.getProperty("api.clientId")).clientAppSecret(this.props.getProperty("api.secret")).tokenType(ApiTokenConfig.TokenType.OWNER).baseUrl(this.props.getProperty("webpage.url")).build();
            this.eslClient = new EslClient(apiTokenConfig, this.props.getProperty("api.url"), true, proxyConfiguration, true, additionalHeaders);
        }
        return this.eslClient;
    }

    protected abstract void execute();

    public void run() {
        this.execute();
    }

    private void setProperties() {
        this.email1 = this.props.getProperty("1.email");
        this.email2 = this.props.getProperty("2.email");
        this.email3 = this.props.getProperty("3.email");
        this.email4 = this.props.getProperty("4.email");
        this.email5 = this.props.getProperty("5.email");
        this.email6 = this.props.getProperty("6.email");
        this.senderEmail = this.props.getProperty("sender.email");
        this.sms1 = this.props.getProperty("1.sms");
        this.sms2 = this.props.getProperty("2.sms");
        this.sms3 = this.props.getProperty("3.sms");
        this.sms4 = this.props.getProperty("4.sms");
        this.sms5 = this.props.getProperty("5.sms");
        this.sms6 = this.props.getProperty("6.sms");
        this.senderSms = this.props.getProperty("sender.sms");
        this.webpageUrl = this.props.getProperty("webpage.url");
        this.proxyHost = this.props.getProperty("proxy.host");
        this.proxyPort = Integer.parseInt(this.props.getProperty("proxy.port"));
        this.proxyWithCredentialsHost = this.props.getProperty("proxyWithCredentials.host");
        this.proxyWithCredentialsPort = Integer.parseInt(this.props.getProperty("proxyWithCredentials.port"));
        this.proxyUserName = this.props.getProperty("proxy.userName");
        this.proxyPassword = this.props.getProperty("proxy.password");
        this.senderUID = Converter.apiKeyToUID(this.props.getProperty("api.key"));
        this.documentInputStream1 = this.getClass().getClassLoader().getResourceAsStream("document.pdf");
        this.documentInputStream2 = this.getClass().getClassLoader().getResourceAsStream("document.pdf");
    }

    protected EslClient getEslClient() {
        return this.eslClient;
    }

    protected PackageId getPackageId() {
        return this.packageId;
    }

    protected DocumentPackage getRetrievedPackage() {
        if (null == this.retrievedPackage) {
            this.retrievedPackage = this.eslClient.getPackage(this.packageId);
        }
        return this.retrievedPackage;
    }

    protected String getPackageName() {
        if (null == this.packageName) {
            this.packageName = this.getClass().getSimpleName() + " : " + new SimpleDateFormat("HH:mm:ss").format(new Date());
        }
        return this.packageName;
    }

    protected String getRandomEmail() {
        return UUID.randomUUID().toString().replace("-", "") + "@e-signlive.com";
    }
}

