/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.AuthenticationClient;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.util.LinkedHashMap;
import java.util.UUID;

public class SignerAuthenticationTokenExample
extends SDKSample {
    private AuthenticationClient authenticationClient = new AuthenticationClient(this.webpageUrl);
    public String signerSessionIdForMultiUse;
    public String signerSessionIdForSingleUse;
    private String signerSessionFieldKey = "SDK SignerAuthenticationTokenExample Signer";

    public static void main(String ... args) {
        new SignerAuthenticationTokenExample().run();
    }

    @Override
    public void execute() {
        String signerId = UUID.randomUUID().toString();
        DocumentPackage packageToCreate = PackageBuilder.newPackageNamed(this.getPackageName()).describedAs("This is a package created using the eSignLive SDK").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withCustomId("Client1").withFirstName("John").withLastName("Smith").withTitle("Managing Director").withCompany("Acme Inc.").withCustomId(signerId)).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0))).build();
        this.packageId = this.eslClient.createPackage(packageToCreate);
        this.eslClient.sendPackage(this.packageId);
        LinkedHashMap<String, String> signerSessionFields = new LinkedHashMap<String, String>();
        signerSessionFields.put(this.signerSessionFieldKey, this.email1);
        String signerAuthenticationToken = this.eslClient.getAuthenticationTokensService().createSignerAuthenticationToken(this.packageId.getId(), signerId, signerSessionFields);
        String signerAuthenticationTokenForSingleUse = this.eslClient.getAuthenticationTokensService().createSignerAuthenticationTokenForSingleUse(this.packageId.getId(), signerId, signerSessionFields);
        this.signerSessionIdForMultiUse = this.authenticationClient.getSessionIdForSignerAuthenticationToken(signerAuthenticationToken);
        this.signerSessionIdForSingleUse = this.authenticationClient.getSessionIdForSignerAuthenticationToken(signerAuthenticationTokenForSingleUse);
    }
}

