/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Optional;
import com.silanis.esl.api.model.Sender;
import com.silanis.esl.sdk.AccountMember;
import com.silanis.esl.sdk.SenderStatus;
import com.silanis.esl.sdk.internal.converter.AddressConverter;
import com.silanis.esl.sdk.internal.converter.SenderStatusConverter;

public class AccountMemberConverter {
    private Optional<Sender> optionalSender;
    private Optional<AccountMember> optionalAccountMember;

    public AccountMemberConverter(Sender apiSender) {
        this.optionalSender = Optional.of((Object)apiSender);
        this.optionalAccountMember = Optional.absent();
    }

    public AccountMemberConverter(AccountMember sdkAccountMember) {
        this.optionalSender = Optional.absent();
        this.optionalAccountMember = Optional.of((Object)sdkAccountMember);
    }

    public Sender toAPISender() {
        if (this.optionalAccountMember.isPresent()) {
            Sender result = new Sender();
            if (((AccountMember)this.optionalAccountMember.get()).getAddress() != null) {
                result.setAddress(new AddressConverter(((AccountMember)this.optionalAccountMember.get()).getAddress()).toAPIAddress());
            }
            result.setCompany(((AccountMember)this.optionalAccountMember.get()).getCompany());
            result.setEmail(((AccountMember)this.optionalAccountMember.get()).getEmail());
            result.setFirstName(((AccountMember)this.optionalAccountMember.get()).getFirstName());
            result.setLastName(((AccountMember)this.optionalAccountMember.get()).getLastName());
            result.setTitle(((AccountMember)this.optionalAccountMember.get()).getTitle());
            result.setLanguage(((AccountMember)this.optionalAccountMember.get()).getLanguage());
            result.setPhone(((AccountMember)this.optionalAccountMember.get()).getPhoneNumber());
            if (((AccountMember)this.optionalAccountMember.get()).getTimezoneId() != null) {
                result.setTimezoneId(((AccountMember)this.optionalAccountMember.get()).getTimezoneId());
            }
            if (((AccountMember)this.optionalAccountMember.get()).getStatus().isPresent()) {
                result.setStatus(new SenderStatusConverter((SenderStatus)((AccountMember)this.optionalAccountMember.get()).getStatus().get()).toAPISenderStatus());
            }
            return result;
        }
        return (Sender)this.optionalSender.get();
    }

    public AccountMember toSDKAccountMember() {
        if (this.optionalSender.isPresent()) {
            AccountMember result = new AccountMember();
            if (((Sender)this.optionalSender.get()).getAddress() != null) {
                result.setAddress(new AddressConverter(((Sender)this.optionalSender.get()).getAddress()).toSDKAddress());
            }
            result.setCompany(((Sender)this.optionalSender.get()).getCompany());
            result.setEmail(((Sender)this.optionalSender.get()).getEmail());
            result.setFirstName(((Sender)this.optionalSender.get()).getFirstName());
            result.setLastName(((Sender)this.optionalSender.get()).getLastName());
            result.setTitle(((Sender)this.optionalSender.get()).getTitle());
            result.setLanguage(((Sender)this.optionalSender.get()).getLanguage());
            result.setPhoneNumber(((Sender)this.optionalSender.get()).getPhone());
            result.setTimezoneId(((Sender)this.optionalSender.get()).getTimezoneId());
            result.setStatus(new SenderStatusConverter(((Sender)this.optionalSender.get()).getStatus()).toSDKSenderStatus());
            return result;
        }
        return (AccountMember)this.optionalAccountMember.get();
    }
}

