/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.silanis.esl.sdk.CompletionReport;
import com.silanis.esl.sdk.DocumentsCompletionReport;
import com.silanis.esl.sdk.PackageCompletionReport;
import com.silanis.esl.sdk.SenderCompletionReport;
import com.silanis.esl.sdk.SignersCompletionReport;
import com.silanis.esl.sdk.internal.converter.PackageStatusConverter;
import com.silanis.esl.sdk.internal.converter.SenderConverter;
import java.util.List;

public class CompletionReportConverter {
    private CompletionReport sdkCompletionReport = null;
    private com.silanis.esl.api.model.CompletionReport apiCompletionReport = null;

    public CompletionReportConverter(com.silanis.esl.api.model.CompletionReport apiCompletionReport) {
        this.apiCompletionReport = apiCompletionReport;
    }

    public CompletionReport toSDKCompletionReport() {
        if (this.apiCompletionReport == null) {
            return this.sdkCompletionReport;
        }
        List<com.silanis.esl.api.model.SenderCompletionReport> senderCompletionReportList = this.apiCompletionReport.getSenders();
        if (senderCompletionReportList.size() != 0) {
            CompletionReport result = new CompletionReport();
            result.setFrom(this.apiCompletionReport.getFrom());
            result.setTo(this.apiCompletionReport.getTo());
            result.setSenders(Lists.newArrayList((Iterable)Iterables.transform(this.apiCompletionReport.getSenders(), (Function)new Function<com.silanis.esl.api.model.SenderCompletionReport, SenderCompletionReport>(){

                public SenderCompletionReport apply(com.silanis.esl.api.model.SenderCompletionReport input) {
                    SenderCompletionReport sdkSenderCompletionReport = CompletionReportConverter.this.toSDKSenderCompletionReport(input);
                    List<com.silanis.esl.api.model.PackageCompletionReport> packageCompletionReportList = input.getPackages();
                    for (com.silanis.esl.api.model.PackageCompletionReport apiPackageCompletionReport : packageCompletionReportList) {
                        PackageCompletionReport sdkPackageCompletionReport = CompletionReportConverter.this.toSDKPackageCompletionReport(apiPackageCompletionReport);
                        List<com.silanis.esl.api.model.DocumentsCompletionReport> documentCompletionReportList = apiPackageCompletionReport.getDocuments();
                        for (com.silanis.esl.api.model.DocumentsCompletionReport apiDocumentsCompletionReport : documentCompletionReportList) {
                            DocumentsCompletionReport sdkDocumentsCompletionReport = CompletionReportConverter.this.toSDKDocumentCompletionReport(apiDocumentsCompletionReport);
                            sdkPackageCompletionReport.addDocument(sdkDocumentsCompletionReport);
                        }
                        List<com.silanis.esl.api.model.SignersCompletionReport> signersCompletionReportList = apiPackageCompletionReport.getSigners();
                        for (com.silanis.esl.api.model.SignersCompletionReport apiSignersCompletionReport : signersCompletionReportList) {
                            SignersCompletionReport sdkSignersCompletionReport = CompletionReportConverter.this.toSDKSignersCompletionReport(apiSignersCompletionReport);
                            sdkPackageCompletionReport.addSigner(sdkSignersCompletionReport);
                        }
                        sdkSenderCompletionReport.addPackage(sdkPackageCompletionReport);
                    }
                    return sdkSenderCompletionReport;
                }
            })));
            return result;
        }
        return this.sdkCompletionReport;
    }

    private SenderCompletionReport toSDKSenderCompletionReport(com.silanis.esl.api.model.SenderCompletionReport apiSenderCompletionReport) {
        SenderCompletionReport sdkSenderCompletionReport = new SenderCompletionReport();
        sdkSenderCompletionReport.setSender(new SenderConverter(apiSenderCompletionReport.getSender()).toSDKSender());
        return sdkSenderCompletionReport;
    }

    private PackageCompletionReport toSDKPackageCompletionReport(com.silanis.esl.api.model.PackageCompletionReport apiPackageCompletionReport) {
        PackageCompletionReport sdkPackageCompletionReport = new PackageCompletionReport(apiPackageCompletionReport.getName());
        sdkPackageCompletionReport.setId(apiPackageCompletionReport.getId());
        sdkPackageCompletionReport.setCreated(apiPackageCompletionReport.getCreated());
        sdkPackageCompletionReport.setPackageStatus(new PackageStatusConverter(apiPackageCompletionReport.getStatus()).toSDKPackageStatus());
        sdkPackageCompletionReport.setTrashed(apiPackageCompletionReport.getTrashed());
        return sdkPackageCompletionReport;
    }

    private DocumentsCompletionReport toSDKDocumentCompletionReport(com.silanis.esl.api.model.DocumentsCompletionReport apiDocumentsCompletionReport) {
        DocumentsCompletionReport sdkDocumentsCompletionReport = new DocumentsCompletionReport(apiDocumentsCompletionReport.getName());
        sdkDocumentsCompletionReport.setId(apiDocumentsCompletionReport.getId());
        if (apiDocumentsCompletionReport.getCompleted() != null) {
            sdkDocumentsCompletionReport.setCompleted(apiDocumentsCompletionReport.getCompleted());
        }
        if (apiDocumentsCompletionReport.getFirstSigned() != null) {
            sdkDocumentsCompletionReport.setFirstSigned(apiDocumentsCompletionReport.getFirstSigned());
        }
        if (apiDocumentsCompletionReport.getLastSigned() != null) {
            sdkDocumentsCompletionReport.setLastSigned(apiDocumentsCompletionReport.getLastSigned());
        }
        return sdkDocumentsCompletionReport;
    }

    private SignersCompletionReport toSDKSignersCompletionReport(com.silanis.esl.api.model.SignersCompletionReport apiSignersCompletionReport) {
        SignersCompletionReport sdkSignersCompletionReport = new SignersCompletionReport(apiSignersCompletionReport.getFirstName(), apiSignersCompletionReport.getLastName());
        sdkSignersCompletionReport.setEmail(apiSignersCompletionReport.getEmail());
        sdkSignersCompletionReport.setId(apiSignersCompletionReport.getId());
        if (apiSignersCompletionReport.getCompleted() != null) {
            sdkSignersCompletionReport.setCompleted(apiSignersCompletionReport.getCompleted());
        }
        if (apiSignersCompletionReport.getFirstSigned() != null) {
            sdkSignersCompletionReport.setFirstSigned(apiSignersCompletionReport.getFirstSigned());
        }
        if (apiSignersCompletionReport.getLastSigned() != null) {
            sdkSignersCompletionReport.setLastSigned(apiSignersCompletionReport.getLastSigned());
        }
        return sdkSignersCompletionReport;
    }
}

