/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.silanis.esl.sdk.DelegationEventReport;
import com.silanis.esl.sdk.DelegationReport;
import com.silanis.esl.sdk.internal.converter.DelegationEventReportConverter;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DelegationReportConverter {
    private DelegationReport sdkDelegationReport = null;
    private com.silanis.esl.api.model.DelegationReport apiDelegationReport = null;

    public DelegationReportConverter(com.silanis.esl.api.model.DelegationReport apiDelegationReport) {
        this.apiDelegationReport = apiDelegationReport;
    }

    public DelegationReportConverter(DelegationReport sdkDelegationReport) {
        this.sdkDelegationReport = sdkDelegationReport;
    }

    public DelegationReport toSDKDelegationReport() {
        if (this.apiDelegationReport == null) {
            return this.sdkDelegationReport;
        }
        DelegationReport result = new DelegationReport();
        Map sdkDelegationEventReports = Maps.transformEntries(this.apiDelegationReport.getDelegationEvents(), (Maps.EntryTransformer)new Maps.EntryTransformer<String, Collection<com.silanis.esl.api.model.DelegationEventReport>, List<DelegationEventReport>>(){

            public List<DelegationEventReport> transformEntry(String key, Collection<com.silanis.esl.api.model.DelegationEventReport> value) {
                return DelegationReportConverter.this.getSDKDelegationEventReportList(value);
            }
        });
        result.getDelegationEventReports().putAll(sdkDelegationEventReports);
        result.setFrom(this.apiDelegationReport.getFrom());
        result.setTo(this.apiDelegationReport.getTo());
        return result;
    }

    private List<DelegationEventReport> getSDKDelegationEventReportList(Collection<com.silanis.esl.api.model.DelegationEventReport> apiDelegationEventReportCollection) {
        return Lists.newArrayList((Iterable)Iterables.transform(apiDelegationEventReportCollection, (Function)new Function<com.silanis.esl.api.model.DelegationEventReport, DelegationEventReport>(){

            public DelegationEventReport apply(com.silanis.esl.api.model.DelegationEventReport input) {
                return new DelegationEventReportConverter(input).toSDKDelegationEventReport();
            }
        }));
    }

    public com.silanis.esl.api.model.DelegationReport toAPIDelegationReport() {
        if (this.sdkDelegationReport == null) {
            return this.apiDelegationReport;
        }
        com.silanis.esl.api.model.DelegationReport result = new com.silanis.esl.api.model.DelegationReport();
        Map apiDelegationEventReports = Maps.transformEntries(this.sdkDelegationReport.getDelegationEventReports(), (Maps.EntryTransformer)new Maps.EntryTransformer<String, List<DelegationEventReport>, Collection<com.silanis.esl.api.model.DelegationEventReport>>(){

            public Collection<com.silanis.esl.api.model.DelegationEventReport> transformEntry(String key, List<DelegationEventReport> value) {
                return DelegationReportConverter.this.getAPIDelegationEventReportCollection(value);
            }
        });
        result.getDelegationEvents().putAll(apiDelegationEventReports);
        result.setFrom(this.sdkDelegationReport.getFrom());
        result.setTo(this.sdkDelegationReport.getTo());
        return result;
    }

    private Collection<com.silanis.esl.api.model.DelegationEventReport> getAPIDelegationEventReportCollection(List<DelegationEventReport> sdkDelegationEventReportList) {
        return Lists.newArrayList((Iterable)Iterables.transform(sdkDelegationEventReportList, (Function)new Function<DelegationEventReport, com.silanis.esl.api.model.DelegationEventReport>(){

            public com.silanis.esl.api.model.DelegationEventReport apply(DelegationEventReport input) {
                return new DelegationEventReportConverter(input).toAPIDelegationEventReport();
            }
        }));
    }
}

