/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.silanis.esl.sdk.PackageStatus;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class PackageStatusConverter {
    private PackageStatus sdkPackageStatus = null;
    private String apiPackageStatus = null;

    public PackageStatusConverter(String apiPackageStatus) {
        this.apiPackageStatus = apiPackageStatus;
    }

    public PackageStatusConverter(PackageStatus sdkPackageStatus) {
        this.sdkPackageStatus = sdkPackageStatus;
    }

    public PackageStatus toSDKPackageStatus() {
        if (this.apiPackageStatus == null) {
            return this.sdkPackageStatus;
        }
        try {
            return (PackageStatus)Iterables.find(Arrays.asList(PackageStatus.values()), (Predicate)new Predicate<PackageStatus>(){

                public boolean apply(PackageStatus packageStatus) {
                    return PackageStatusConverter.this.apiPackageStatus.equals(packageStatus.getApiValue());
                }
            });
        }
        catch (NoSuchElementException e) {
            return PackageStatus.UNRECOGNIZED(this.apiPackageStatus);
        }
    }

    public String toAPIPackageStatus() {
        if (this.sdkPackageStatus == null) {
            return this.apiPackageStatus;
        }
        return this.sdkPackageStatus.getApiValue();
    }
}

