/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.silanis.esl.sdk.RequirementStatus;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class RequirementStatusConverter {
    private RequirementStatus sdkRequirementStatus = null;
    private String apiRequirementStatus = null;

    public RequirementStatusConverter(String apiRequirementStatus) {
        this.apiRequirementStatus = apiRequirementStatus;
    }

    public RequirementStatusConverter(RequirementStatus sdkRequirementStatus) {
        this.sdkRequirementStatus = sdkRequirementStatus;
    }

    public RequirementStatus toSDKRequirementStatus() {
        if (this.apiRequirementStatus == null) {
            return this.sdkRequirementStatus;
        }
        try {
            return (RequirementStatus)Iterables.find(Arrays.asList(RequirementStatus.values()), (Predicate)new Predicate<RequirementStatus>(){

                public boolean apply(RequirementStatus requirementStatus) {
                    return RequirementStatusConverter.this.apiRequirementStatus.equals(requirementStatus.getApiValue());
                }
            });
        }
        catch (NoSuchElementException e) {
            return RequirementStatus.UNRECOGNIZED(this.apiRequirementStatus);
        }
    }

    public String toAPIRequirementStatus() {
        if (this.sdkRequirementStatus == null) {
            return this.apiRequirementStatus;
        }
        return this.sdkRequirementStatus.getApiValue();
    }
}

