/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.silanis.esl.api.model.Result;
import com.silanis.esl.api.model.VerificationType;
import com.silanis.esl.sdk.AccountMember;
import com.silanis.esl.sdk.DelegationUser;
import com.silanis.esl.sdk.Direction;
import com.silanis.esl.sdk.PageRequest;
import com.silanis.esl.sdk.Sender;
import com.silanis.esl.sdk.SenderInfo;
import com.silanis.esl.sdk.internal.converter.AccountMemberConverter;
import com.silanis.esl.sdk.internal.converter.DelegationUserConverter;
import com.silanis.esl.sdk.internal.converter.SenderConverter;
import com.silanis.esl.sdk.service.apiclient.AccountApiClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AccountService {
    private AccountApiClient apiClient;

    public AccountService(AccountApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Sender inviteUser(AccountMember accountMember) {
        com.silanis.esl.api.model.Sender sender = new AccountMemberConverter(accountMember).toAPISender();
        sender = this.apiClient.inviteUser(sender);
        return new SenderConverter(sender).toSDKSender();
    }

    public void sendInvite(String senderId) {
        this.apiClient.sendInvite(senderId);
    }

    public Map<String, Sender> getSenders(Direction direction, PageRequest request) {
        Result<com.silanis.esl.api.model.Sender> apiResponse = this.apiClient.getSenders(direction, request);
        HashMap<String, Sender> result = new HashMap<String, Sender>();
        for (com.silanis.esl.api.model.Sender sender : apiResponse.getResults()) {
            result.put(sender.getEmail(), new SenderConverter(sender).toSDKSender());
        }
        return result;
    }

    public Sender getSender(String senderId) {
        com.silanis.esl.api.model.Sender apiResponse = this.apiClient.getSender(senderId);
        return new SenderConverter(apiResponse).toSDKSender();
    }

    public void deleteSender(String senderId) {
        this.apiClient.deleteSender(senderId);
    }

    public void updateSender(SenderInfo sender, String senderId) {
        com.silanis.esl.api.model.Sender apiSender = new SenderConverter(sender).toAPISender();
        apiSender.setId(senderId);
        this.apiClient.updateSender(apiSender, senderId);
    }

    public Map<String, Sender> getContacts() {
        List<com.silanis.esl.api.model.Sender> contacts = this.apiClient.getContacts();
        HashMap<String, Sender> result = new HashMap<String, Sender>();
        for (com.silanis.esl.api.model.Sender apiSender : contacts) {
            result.put(apiSender.getEmail(), new SenderConverter(apiSender).toSDKSender());
        }
        return result;
    }

    public List<DelegationUser> getDelegates(String senderId) {
        ArrayList<DelegationUser> result = new ArrayList<DelegationUser>();
        List<com.silanis.esl.api.model.DelegationUser> apiDelegationUsers = this.apiClient.getDelegates(senderId);
        for (com.silanis.esl.api.model.DelegationUser delegationUser : apiDelegationUsers) {
            result.add(new DelegationUserConverter(delegationUser).toSDKDelegationUser());
        }
        return result;
    }

    public void updateDelegates(String senderId, List<String> delegateIds) {
        this.apiClient.updateDelegates(senderId, delegateIds);
    }

    public void addDelegate(String senderId, DelegationUser delegationUser) {
        com.silanis.esl.api.model.DelegationUser apiDelegationUser = new DelegationUserConverter(delegationUser).toAPIDelegationUser();
        this.apiClient.addDelegate(senderId, apiDelegationUser);
    }

    public void removeDelegate(String senderId, String delegateId) {
        this.apiClient.removeDelegate(senderId, delegateId);
    }

    public void clearDelegates(String senderId) {
        this.apiClient.clearDelegates(senderId);
    }

    public List<VerificationType> getVerificationTypes() {
        return this.apiClient.getVerificationTypes();
    }
}

