/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.silanis.esl.api.model.Approval;
import com.silanis.esl.api.model.Package;
import com.silanis.esl.api.model.Role;
import com.silanis.esl.sdk.ConditionalField;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.Field;
import com.silanis.esl.sdk.FieldId;
import com.silanis.esl.sdk.GroupId;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.Signature;
import com.silanis.esl.sdk.SignatureId;
import com.silanis.esl.sdk.internal.converter.ConditionalFieldConverter;
import com.silanis.esl.sdk.internal.converter.DocumentPackageConverter;
import com.silanis.esl.sdk.internal.converter.FieldConverter;
import com.silanis.esl.sdk.internal.converter.SignatureConverter;
import com.silanis.esl.sdk.service.apiclient.ApprovalApiClient;
import java.util.ArrayList;
import java.util.List;

public class ApprovalService {
    private ApprovalApiClient apiClient;

    public ApprovalService(ApprovalApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void deleteSignature(PackageId packageId, String documentId, SignatureId signatureId) throws EslException {
        this.apiClient.deleteSignature(packageId.getId(), documentId, signatureId.getId());
    }

    public String addSignature(DocumentPackage sdkPackage, String documentId, Signature signature) throws EslException {
        Approval apiApproval = new SignatureConverter(signature).toAPIApproval();
        Package apiPackage = new DocumentPackageConverter(sdkPackage).toAPIPackage();
        if (signature.isPlaceholderSignature()) {
            apiApproval.setRole(signature.getRoleId().getId());
        } else if (signature.isGroupSignature()) {
            apiApproval.setRole(this.findRoleIdForGroup(signature.getGroupId(), apiPackage));
        } else {
            apiApproval.setRole(this.findRoleIdForSignature(signature.getSignerEmail(), apiPackage));
        }
        Approval apiApprovalResponse = this.apiClient.addSignature(sdkPackage.getId().getId(), documentId, apiApproval);
        return apiApprovalResponse.getId();
    }

    public void modifySignature(DocumentPackage sdkPackage, String documentId, Signature signature) throws EslException {
        Approval apiApproval = new SignatureConverter(signature).toAPIApproval();
        Package aPackage = new DocumentPackageConverter(sdkPackage).toAPIPackage();
        if (signature.isPlaceholderSignature()) {
            apiApproval.setRole(signature.getRoleId().getId());
        } else if (signature.isGroupSignature()) {
            apiApproval.setRole(this.findRoleIdForGroup(signature.getGroupId(), aPackage));
        } else {
            apiApproval.setRole(this.findRoleIdForSignature(signature.getSignerEmail(), aPackage));
        }
        this.apiClient.modifySignature(sdkPackage.getId().getId(), documentId, apiApproval);
    }

    public void updateSignatures(DocumentPackage sdkPackage, String documentId, List<Signature> signatureList) {
        Package apiPackage = new DocumentPackageConverter(sdkPackage).toAPIPackage();
        ArrayList<Approval> approvalList = new ArrayList<Approval>();
        for (Signature signature : signatureList) {
            Approval approval = new SignatureConverter(signature).toAPIApproval();
            if (signature.isPlaceholderSignature()) {
                approval.setRole(signature.getRoleId().getId());
            } else if (signature.isGroupSignature()) {
                approval.setRole(this.findRoleIdForGroup(signature.getGroupId(), apiPackage));
            } else {
                approval.setRole(this.findRoleIdForSignature(signature.getSignerEmail(), apiPackage));
            }
            approvalList.add(approval);
        }
        this.apiClient.updateSignatures(sdkPackage.getId().getId(), documentId, approvalList);
    }

    public Signature getSignature(DocumentPackage sdkPackage, String documentId, SignatureId signatureId) throws EslException {
        Approval apiResponse = this.apiClient.getSignature(sdkPackage.getId().getId(), documentId, signatureId.getId());
        Package aPackage = new DocumentPackageConverter(sdkPackage).toAPIPackage();
        return new SignatureConverter(apiResponse, aPackage).toSDKSignature();
    }

    public List<Signature> getAllSignableSignatures(DocumentPackage sdkPackage, String documentId, String signerId) throws EslException {
        ArrayList<Signature> signatures = new ArrayList<Signature>();
        Package aPackage = new DocumentPackageConverter(sdkPackage).toAPIPackage();
        List<Approval> approvals = this.apiClient.getAllSignableApprovals(sdkPackage.getId().getId(), documentId, signerId);
        for (Approval approval : approvals) {
            signatures.add(new SignatureConverter(approval, aPackage).toSDKSignature());
        }
        return signatures;
    }

    public String addField(PackageId packageId, String documentId, SignatureId signatureId, Field field) {
        com.silanis.esl.api.model.Field apiField = new FieldConverter(field).toAPIField();
        String fieldId = this.apiClient.addField(packageId, documentId, signatureId, apiField);
        return fieldId;
    }

    public void updateField(PackageId packageId, String documentId, SignatureId signatureId, Field field) {
        com.silanis.esl.api.model.Field apiField = new FieldConverter(field).toAPIField();
        this.apiClient.updateField(packageId.getId(), documentId, signatureId.getId(), apiField);
    }

    public void updateConditionalField(PackageId packageId, String documentId, SignatureId signatureId, ConditionalField conditionalField) {
        com.silanis.esl.api.model.ConditionalField apiField = new ConditionalFieldConverter(conditionalField).toAPIConditionalField();
        this.apiClient.updateConditionalField(packageId.getId(), documentId, signatureId.getId(), apiField);
    }

    public void deleteField(PackageId packageId, String documentId, SignatureId signatureId, FieldId fieldId) {
        this.apiClient.deleteField(packageId.getId(), documentId, signatureId.getId(), fieldId.getId());
    }

    public Field getField(PackageId packageId, String documentId, SignatureId signatureId, FieldId fieldId) {
        com.silanis.esl.api.model.Field apiField = this.apiClient.getField(packageId.getId(), documentId, signatureId.getId(), fieldId.getId());
        return new FieldConverter(apiField).toSDKField();
    }

    private String findRoleIdForGroup(GroupId groupId, Package createdPackage) {
        for (Role role : createdPackage.getRoles()) {
            if (role.getSigners().isEmpty() || role.getSigners().get(0).getGroup() == null || !role.getSigners().get(0).getGroup().getId().equals(groupId.getId())) continue;
            return role.getId();
        }
        throw new IllegalStateException("No role found for signer group " + groupId.getId());
    }

    private String findRoleIdForSignature(String signerEmail, Package createdPackage) {
        for (Role role : createdPackage.getRoles()) {
            if (role.getSigners().isEmpty() || role.getSigners().get(0).getEmail() == null || !signerEmail.equalsIgnoreCase(role.getSigners().get(0).getEmail())) continue;
            return role.getId();
        }
        throw new IllegalStateException("No role found for signer email " + signerEmail);
    }
}

