/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.silanis.esl.api.util.JacksonUtil;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.SigningLogo;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import com.silanis.esl.sdk.internal.converter.SigningLogoConverter;
import java.util.List;
import java.util.Map;

public class SigningStyleService {
    private UrlTemplate template;
    private RestClient client;

    public SigningStyleService(RestClient client, String baseUrl) {
        this.template = new UrlTemplate(baseUrl);
        this.client = client;
    }

    public Map<String, Object> createSigningThemes(String signingThemesString) {
        String path = this.template.urlFor("/account/signingThemes").build();
        try {
            String stringResponse = this.client.post(path, signingThemesString);
            return JacksonUtil.deserialize(stringResponse, Map.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not create the signing themes for account.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not create the signing themes for account.", e);
        }
    }

    public Map<String, Object> getSigningThemes() {
        String path = this.template.urlFor("/account/signingThemes").build();
        try {
            String stringResponse = this.client.get(path);
            return Serialization.fromJson(stringResponse, Map.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get the signing themes from account.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get the signing themes from account.", e);
        }
    }

    public void deleteSigningThemes() {
        String path = this.template.urlFor("/account/signingThemes").build();
        try {
            this.client.delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not delete the signing themes from account.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not delete the signing themes from account.", e);
        }
    }

    public Map<String, Object> updateSigningThemes(String signingThemesString) {
        String path = this.template.urlFor("/account/signingThemes").build();
        try {
            String stringResponse = this.client.put(path, signingThemesString);
            return JacksonUtil.deserialize(stringResponse, Map.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not update the signing themes to account.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not update the signing themes to account.", e);
        }
    }

    public void saveSigningLogos(List<SigningLogo> signingLogos) {
        String path = this.template.urlFor("/account/admin/signingLogos").build();
        String payload = JacksonUtil.serialize(signingLogos);
        try {
            this.client.post(path, payload);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not save the signing logos for account.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not save the signing logos for account.", e);
        }
    }

    public List getSigningLogos() {
        String path = this.template.urlFor("/account/admin/signingLogos").build();
        try {
            String stringResponse = this.client.get(path);
            return SigningLogoConverter.converToSDKSigningLogoList(Serialization.fromJsonToList(stringResponse, com.silanis.esl.api.model.SigningLogo.class));
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get the signing logos from account.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get the signing logos from account.", e);
        }
    }
}

