/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.hoplite.yaml;

import com.sksamuel.hoplite.Node;
import com.sksamuel.hoplite.NullNode;
import com.sksamuel.hoplite.PrimitiveNode;
import com.sksamuel.hoplite.StringNode;
import com.sksamuel.hoplite.yaml.MapProduction;
import com.sksamuel.hoplite.yaml.SequenceProduction;
import com.sksamuel.hoplite.yaml.TokenStream;
import com.sksamuel.hoplite.yaml.YamlParserKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0086\u0002\u00a8\u0006\n"}, d2={"Lcom/sksamuel/hoplite/yaml/TokenProduction;", "", "()V", "invoke", "Lcom/sksamuel/hoplite/Node;", "stream", "Lcom/sksamuel/hoplite/yaml/TokenStream;", "Lorg/yaml/snakeyaml/events/Event;", "source", "", "hoplite-yaml"})
public final class TokenProduction {
    public static final TokenProduction INSTANCE;

    @NotNull
    public final Node invoke(@NotNull TokenStream<Event> stream, @NotNull String source) {
        Node node;
        Intrinsics.checkParameterIsNotNull(stream, (String)"stream");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Event event = stream.current();
        if (event instanceof MappingStartEvent) {
            node = MapProduction.INSTANCE.invoke(stream, source);
        } else if (event instanceof SequenceStartEvent) {
            node = SequenceProduction.INSTANCE.invoke(stream, source);
        } else if (event instanceof ScalarEvent) {
            PrimitiveNode primitiveNode;
            if (Intrinsics.areEqual((Object)((ScalarEvent)event).getValue(), (Object)"null") && ((ScalarEvent)event).getScalarStyle() == DumperOptions.ScalarStyle.PLAIN) {
                Mark mark = ((ScalarEvent)event).getStartMark();
                Intrinsics.checkExpressionValueIsNotNull((Object)mark, (String)"event.startMark");
                primitiveNode = (PrimitiveNode)new NullNode(YamlParserKt.toPos(mark, source));
            } else {
                String string = ((ScalarEvent)event).getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.value");
                Mark mark = ((ScalarEvent)event).getStartMark();
                Intrinsics.checkExpressionValueIsNotNull((Object)mark, (String)"event.startMark");
                primitiveNode = (PrimitiveNode)new StringNode(string, YamlParserKt.toPos(mark, source));
            }
            node = (Node)primitiveNode;
        } else {
            throw (Throwable)new UnsupportedOperationException("Invalid YAML event " + YamlParserKt.id(stream.current()) + " at " + stream.current().getStartMark());
        }
        return node;
    }

    private TokenProduction() {
    }

    static {
        TokenProduction tokenProduction;
        INSTANCE = tokenProduction = new TokenProduction();
    }
}

