/*
 * See the file LICENSE for redistribution information.
 *
 * Copyright (c) 2002-2010 Oracle.  All rights reserved.
 *
 * $Id: SequenceOverflowException.java,v 1.4 2010/01/04 15:50:36 cwl Exp $
 */

package com.sleepycat.je;

/**
 * Thrown by {@link Sequence#get Sequence.get} if the end of the sequence is
 * reached and wrapping is not configured.
 *
 * <p>The {@link Transaction} handle is <em>not</em> invalidated as a result of
 * this exception.</p>
 *
 * @since 4.0
 */
public class SequenceOverflowException extends OperationFailureException {

    private static final long serialVersionUID = 1;

    /** 
     * For internal use only.
     * @hidden 
     */
    public SequenceOverflowException(String message) {
        super(null /*locker*/, false /*abortOnly*/, message, null /*cause*/);
    }

    /** 
     * For internal use only.
     * @hidden 
     */
    private SequenceOverflowException(String message,
                                      SequenceOverflowException cause) {
        super(message, cause);
    }

    /** 
     * For internal use only.
     * @hidden 
     */
    @Override
    public OperationFailureException wrapSelf(String msg) {
        return new SequenceOverflowException(msg, this);
    }
}
