/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.zephyrscale.junit.builder;

import com.smartbear.zephyrscale.junit.builder.CustomFormatExecutionBuilder;
import com.smartbear.zephyrscale.junit.customformat.CustomFormatContainer;
import com.smartbear.zephyrscale.junit.customformat.CustomFormatExecution;
import com.smartbear.zephyrscale.junit.decorator.TestDescriptionDecorator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class CustomFormatContainerBuilder {
    private CustomFormatContainer customFormatContainer = new CustomFormatContainer();
    private List<TestDescriptionDecorator> failedTests = new ArrayList<TestDescriptionDecorator>();

    public void registerFailure(TestDescriptionDecorator testDescriptionDecorator) {
        this.failedTests.add(testDescriptionDecorator);
    }

    public void registerFinished(TestDescriptionDecorator testDescriptionDecorator) {
        Optional<CustomFormatExecution> optionalCustomFormatExecution = this.customFormatContainer.getExecutionBySource(testDescriptionDecorator.getSource());
        if (optionalCustomFormatExecution.isPresent()) {
            CustomFormatExecution customFormatExecution = optionalCustomFormatExecution.get();
            this.updateResult(customFormatExecution, testDescriptionDecorator);
        } else {
            this.createResult(testDescriptionDecorator);
        }
    }

    private void createResult(TestDescriptionDecorator testDescriptionDecorator) {
        CustomFormatExecution customFormatExecution = new CustomFormatExecutionBuilder().build(testDescriptionDecorator).getCustomFormatExecution();
        this.updateResult(customFormatExecution, testDescriptionDecorator);
        this.customFormatContainer.addResult(customFormatExecution);
    }

    private void updateResult(CustomFormatExecution customFormatExecution, TestDescriptionDecorator testDescriptionDecorator) {
        String result = this.failedTests.contains(testDescriptionDecorator) ? "Failed" : "Passed";
        customFormatExecution.setResult(result);
    }

    public CustomFormatContainer getCustomFormatContainer() {
        return this.customFormatContainer;
    }
}

