/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.soebes.maven.plugins.dmg;

public enum DoxygenParameters {
	DOXYFILE_ENCODING(
			"# This tag specifies the encoding used for all characters in the config file \n"
		+	"# that follow. The default is UTF-8 which is also the encoding used for all \n"
		+	"# text before the first occurrence of this tag. Doxygen uses libiconv (or the \n"
		+	"# iconv built into libc) for the transcoding. See \n"
		+	"# http://www.gnu.org/software/libiconv for the list of possible encodings.\n",
		DoxygenParameterType.STRING,
		"UTF-8"
	),
	PROJECT_NAME(
			"# The PROJECT_NAME tag is a single word (or a sequence of words surrounded \n"
		+	"# by quotes) that should identify the project.\n",
		DoxygenParameterType.STRING,
		"MIGRATION.PARENT"
	),
	PROJECT_NUMBER(
			"# The PROJECT_NUMBER tag can be used to enter a project or revision number. \n"
		+	"# This could be handy for archiving the generated documentation or \n"
		+	"# if some version control system is used.\n",
		DoxygenParameterType.STRING,
		null
	),
	OUTPUT_DIRECTORY(
			"# The OUTPUT_DIRECTORY tag is used to specify the (relative or absolute) \n"
		+	"# base path where the generated documentation will be put. \n"
		+	"# If a relative path is entered, it will be relative to the location \n"
		+	"# where doxygen was started. If left blank the current directory will be used.\n",
		DoxygenParameterType.STRING_QUOTED,
		null
	),
	CREATE_SUBDIRS(
			"# If the CREATE_SUBDIRS tag is set to YES, then doxygen will create \n"
		+	"# 4096 sub-directories (in 2 levels) under the output directory of each output \n"
		+	"# format and will distribute the generated files over these directories. \n"
		+	"# Enabling this option can be useful when feeding doxygen a huge amount of \n"
		+	"# source files, where putting all generated files in the same directory would \n"
		+	"# otherwise cause performance problems for the file system.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	OUTPUT_LANGUAGE(
			"# The OUTPUT_LANGUAGE tag is used to specify the language in which all \n"
		+	"# documentation generated by doxygen is written. Doxygen will use this \n"
		+	"# information to generate all constant output in the proper language. \n"
		+	"# The default language is English, other supported languages are: \n"
		+	"# Afrikaans, Arabic, Brazilian, Catalan, Chinese, Chinese-Traditional, \n"
		+	"# Croatian, Czech, Danish, Dutch, Farsi, Finnish, French, German, Greek, \n"
		+	"# Hungarian, Italian, Japanese, Japanese-en (Japanese with English messages), \n"
		+	"# Korean, Korean-en, Lithuanian, Norwegian, Macedonian, Persian, Polish, \n"
		+	"# Portuguese, Romanian, Russian, Serbian, Serbian-Cyrilic, Slovak, Slovene, \n"
		+	"# Spanish, Swedish, and Ukrainian.\n",
		DoxygenParameterType.STRING,
		"English"
	),
	BRIEF_MEMBER_DESC(
			"# If the BRIEF_MEMBER_DESC tag is set to YES (the default) Doxygen will \n"
		+	"# include brief member descriptions after the members that are listed in \n"
		+	"# the file and class documentation (similar to JavaDoc). \n"
		+	"# Set to NO to disable this.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	REPEAT_BRIEF(
			"# If the REPEAT_BRIEF tag is set to YES (the default) Doxygen will prepend \n"
		+	"# the brief description of a member or function before the detailed description. \n"
		+	"# Note: if both HIDE_UNDOC_MEMBERS and BRIEF_MEMBER_DESC are set to NO, the \n"
		+	"# brief descriptions will be completely suppressed.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	ABBREVIATE_BRIEF(
			"# This tag implements a quasi-intelligent brief description abbreviator \n"
		+	"# that is used to form the text in various listings. Each string \n"
		+	"# in this list, if found as the leading text of the brief description, will be \n"
		+	"# stripped from the text and the result after processing the whole list, is \n"
		+	"# used as the annotated text. Otherwise, the brief description is used as-is. \n"
		+	"# If left blank, the following values are used (\"$name\" is automatically \n"
		+	"# replaced with the name of the entity): \"The $name class\" \"The $name widget\" \n"
		+	"# \"The $name file\" \"is\" \"provides\" \"specifies\" \"contains\" \n"
		+	"# \"represents\" \"a\" \"an\" \"the\"\n",
		DoxygenParameterType.STRING,
		null
	),
	ALWAYS_DETAILED_SEC(
			"# If the ALWAYS_DETAILED_SEC and REPEAT_BRIEF tags are both set to YES then \n"
		+	"# Doxygen will generate a detailed section even if there is only a brief \n"
		+	"# description.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	INLINE_INHERITED_MEMB(
			"# If the INLINE_INHERITED_MEMB tag is set to YES, doxygen will show all \n"
		+	"# inherited members of a class in the documentation of that class as if those \n"
		+	"# members were ordinary class members. Constructors, destructors and assignment \n"
		+	"# operators of the base classes will not be shown.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	FULL_PATH_NAMES(
			"# If the FULL_PATH_NAMES tag is set to YES then Doxygen will prepend the full \n"
		+	"# path before files name in the file list and in the header files. If set \n"
		+	"# to NO the shortest path that makes the file name unique will be used.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	STRIP_FROM_PATH(
			"# If the FULL_PATH_NAMES tag is set to YES then the STRIP_FROM_PATH tag \n"
		+	"# can be used to strip a user-defined part of the path. Stripping is \n"
		+	"# only done if one of the specified strings matches the left-hand part of \n"
		+	"# the path. The tag can be used to show relative paths in the file list. \n"
		+	"# If left blank the directory from which doxygen is run is used as the \n"
		+	"# path to strip.\n",
		DoxygenParameterType.STRING,
		"/home/marbkar/workspace-deps/depstest-0.2.0"
	),
	STRIP_FROM_INC_PATH(
			"# The STRIP_FROM_INC_PATH tag can be used to strip a user-defined part of \n"
		+	"# the path mentioned in the documentation of a class, which tells \n"
		+	"# the reader which header file to include in order to use a class. \n"
		+	"# If left blank only the name of the header file containing the class \n"
		+	"# definition is used. Otherwise one should specify the include paths that \n"
		+	"# are normally passed to the compiler using the -I flag.\n",
		DoxygenParameterType.STRING,
		null
	),
	SHORT_NAMES(
			"# If the SHORT_NAMES tag is set to YES, doxygen will generate much shorter \n"
		+	"# (but less readable) file names. This can be useful is your file systems \n"
		+	"# doesn't support long names like on DOS, Mac, or CD-ROM.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	JAVADOC_AUTOBRIEF(
			"# If the JAVADOC_AUTOBRIEF tag is set to YES then Doxygen \n"
		+	"# will interpret the first line (until the first dot) of a JavaDoc-style \n"
		+	"# comment as the brief description. If set to NO, the JavaDoc \n"
		+	"# comments will behave just like regular Qt-style comments \n"
		+	"# (thus requiring an explicit @brief command for a brief description.)\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	QT_AUTOBRIEF(
			"# If the QT_AUTOBRIEF tag is set to YES then Doxygen will \n"
		+	"# interpret the first line (until the first dot) of a Qt-style \n"
		+	"# comment as the brief description. If set to NO, the comments \n"
		+	"# will behave just like regular Qt-style comments (thus requiring \n"
		+	"# an explicit \\brief command for a brief description.)\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	MULTILINE_CPP_IS_BRIEF(
			"# The MULTILINE_CPP_IS_BRIEF tag can be set to YES to make Doxygen \n"
		+	"# treat a multi-line C++ special comment block (i.e. a block of //! or /// \n"
		+	"# comments) as a brief description. This used to be the default behaviour. \n"
		+	"# The new default is to treat a multi-line C++ comment block as a detailed \n"
		+	"# description. Set this tag to YES if you prefer the old behaviour instead.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	INHERIT_DOCS(
			"# If the INHERIT_DOCS tag is set to YES (the default) then an undocumented \n"
		+	"# member inherits the documentation from any documented member that it \n"
		+	"# re-implements.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	SEPARATE_MEMBER_PAGES(
			"# If the SEPARATE_MEMBER_PAGES tag is set to YES, then doxygen will produce \n"
		+	"# a new page for each member. If set to NO, the documentation of a member will \n"
		+	"# be part of the file/class/namespace that contains it.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	TAB_SIZE(
			"# The TAB_SIZE tag can be used to set the number of spaces in a tab. \n"
		+	"# Doxygen uses this value to replace tabs by spaces in code fragments.\n",
		DoxygenParameterType.INTEGER,
		"8"
	),
	ALIASES(
			"# This tag can be used to specify a number of aliases that acts \n"
		+	"# as commands in the documentation. An alias has the form \"name=value\". \n"
		+	"# For example adding \"sideeffect=\\par Side Effects:\\n\" will allow you to \n"
		+	"# put the command \\sideeffect (or @sideeffect) in the documentation, which \n"
		+	"# will result in a user-defined paragraph with heading \"Side Effects:\". \n"
		+	"# You can put \\n's in the value part of an alias to insert newlines.\n",
		DoxygenParameterType.STRING,
		null
	),
	OPTIMIZE_OUTPUT_FOR_C(
			"# Set the OPTIMIZE_OUTPUT_FOR_C tag to YES if your project consists of C \n"
		+	"# sources only. Doxygen will then generate output that is more tailored for C. \n"
		+	"# For instance, some of the names that are used will be different. The list \n"
		+	"# of all members will be omitted, etc.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	OPTIMIZE_OUTPUT_JAVA(
			"# Set the OPTIMIZE_OUTPUT_JAVA tag to YES if your project consists of Java \n"
		+	"# sources only. Doxygen will then generate output that is more tailored for \n"
		+	"# Java. For instance, namespaces will be presented as packages, qualified \n"
		+	"# scopes will look different, etc.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	OPTIMIZE_FOR_FORTRAN(
			"# Set the OPTIMIZE_FOR_FORTRAN tag to YES if your project consists of Fortran \n"
		+	"# sources only. Doxygen will then generate output that is more tailored for \n"
		+	"# Fortran.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	OPTIMIZE_OUTPUT_VHDL(
			"# Set the OPTIMIZE_OUTPUT_VHDL tag to YES if your project consists of VHDL \n"
		+	"# sources. Doxygen will then generate output that is tailored for \n"
		+	"# VHDL.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	BUILTIN_STL_SUPPORT(
			"# If you use STL classes (i.e. std::string, std::vector, etc.) but do not want \n"
		+	"# to include (a tag file for) the STL sources as input, then you should \n"
		+	"# set this tag to YES in order to let doxygen match functions declarations and \n"
		+	"# definitions whose arguments contain STL classes (e.g. func(std::string); v.s. \n"
		+	"# func(std::string) {}). This also make the inheritance and collaboration \n"
		+	"# diagrams that involve STL classes more complete and accurate.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	CPP_CLI_SUPPORT(
			"# If you use Microsoft's C++/CLI language, you should set this option to YES to\n"
		+	"# enable parsing support.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	SIP_SUPPORT(
			"# Set the SIP_SUPPORT tag to YES if your project consists of sip sources only. \n"
		+	"# Doxygen will parse them like normal C++ but will assume all classes use public \n"
		+	"# instead of private inheritance when no explicit protection keyword is present.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	IDL_PROPERTY_SUPPORT(
			"# For Microsoft's IDL there are propget and propput attributes to indicate getter \n"
		+	"# and setter methods for a property. Setting this option to YES (the default) \n"
		+	"# will make doxygen to replace the get and set methods by a property in the \n"
		+	"# documentation. This will only work if the methods are indeed getting or \n"
		+	"# setting a simple type. If this is not the case, or you want to show the \n"
		+	"# methods anyway, you should set this option to NO.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	DISTRIBUTE_GROUP_DOC(
			"# If member grouping is used in the documentation and the DISTRIBUTE_GROUP_DOC \n"
		+	"# tag is set to YES, then doxygen will reuse the documentation of the first \n"
		+	"# member in the group (if any) for the other members of the group. By default \n"
		+	"# all members of a group must be documented explicitly.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	SUBGROUPING(
			"# Set the SUBGROUPING tag to YES (the default) to allow class member groups of \n"
		+	"# the same type (for instance a group of public functions) to be put as a \n"
		+	"# subgroup of that type (e.g. under the Public Functions section). Set it to \n"
		+	"# NO to prevent subgrouping. Alternatively, this can be done per class using \n"
		+	"# the \\nosubgrouping command.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	TYPEDEF_HIDES_STRUCT(
			"# When TYPEDEF_HIDES_STRUCT is enabled, a typedef of a struct, union, or enum \n"
		+	"# is documented as struct, union, or enum with the name of the typedef. So \n"
		+	"# typedef struct TypeS {} TypeT, will appear in the documentation as a struct \n"
		+	"# with name TypeT. When disabled the typedef will appear as a member of a file, \n"
		+	"# namespace, or class. And the struct will be named TypeS. This can typically \n"
		+	"# be useful for C code in case the coding convention dictates that all compound \n"
		+	"# types are typedef'ed and only the typedef is referenced, never the tag name.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	SYMBOL_CACHE_SIZE(
			"# The SYMBOL_CACHE_SIZE determines the size of the internal cache use to \n"
		+	"# determine which symbols to keep in memory and which to flush to disk.\n"
		+	"# When the cache is full, less often used symbols will be written to disk.\n"
		+	"# For small to medium size projects (<1000 input files) the default value is \n"
		+	"# probably good enough. For larger projects a too small cache size can cause \n"
		+	"# doxygen to be busy swapping symbols to and from disk most of the time \n"
		+	"# causing a significant performance penality. \n"
		+	"# If the system has enough physical memory increasing the cache will improve the \n"
		+	"# performance by keeping more symbols in memory. Note that the value works on \n"
		+	"# a logarithmic scale so increasing the size by one will rougly double the \n"
		+	"# memory usage. The cache size is given by this formula: \n"
		+	"# 2^(16+SYMBOL_CACHE_SIZE). The valid range is 0..9, the default is 0, \n"
		+	"# corresponding to a cache size of 2^16 = 65536 symbols\n",
		DoxygenParameterType.INTEGER,
		"0"
	),
	EXTRACT_ALL(
			"# If the EXTRACT_ALL tag is set to YES doxygen will assume all entities in \n"
		+	"# documentation are documented, even if no documentation was available. \n"
		+	"# Private class members and static file members will be hidden unless \n"
		+	"# the EXTRACT_PRIVATE and EXTRACT_STATIC tags are set to YES\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	EXTRACT_PRIVATE(
			"# If the EXTRACT_PRIVATE tag is set to YES all private members of a class \n"
		+	"# will be included in the documentation.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	EXTRACT_STATIC(
			"# If the EXTRACT_STATIC tag is set to YES all static members of a file \n"
		+	"# will be included in the documentation.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	EXTRACT_LOCAL_CLASSES(
			"# If the EXTRACT_LOCAL_CLASSES tag is set to YES classes (and structs) \n"
		+	"# defined locally in source files will be included in the documentation. \n"
		+	"# If set to NO only classes defined in header files are included.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	EXTRACT_LOCAL_METHODS(
			"# This flag is only useful for Objective-C code. When set to YES local \n"
		+	"# methods, which are defined in the implementation section but not in \n"
		+	"# the interface are included in the documentation. \n"
		+	"# If set to NO (the default) only methods in the interface are included.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	EXTRACT_ANON_NSPACES(
			"# If this flag is set to YES, the members of anonymous namespaces will be \n"
		+	"# extracted and appear in the documentation as a namespace called \n"
		+	"# 'anonymous_namespace{file}', where file will be replaced with the base \n"
		+	"# name of the file that contains the anonymous namespace. By default \n"
		+	"# anonymous namespace are hidden.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	HIDE_UNDOC_MEMBERS(
			"# If the HIDE_UNDOC_MEMBERS tag is set to YES, Doxygen will hide all \n"
		+	"# undocumented members of documented classes, files or namespaces. \n"
		+	"# If set to NO (the default) these members will be included in the \n"
		+	"# various overviews, but no documentation section is generated. \n"
		+	"# This option has no effect if EXTRACT_ALL is enabled.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	HIDE_UNDOC_CLASSES(
			"# If the HIDE_UNDOC_CLASSES tag is set to YES, Doxygen will hide all \n"
		+	"# undocumented classes that are normally visible in the class hierarchy. \n"
		+	"# If set to NO (the default) these classes will be included in the various \n"
		+	"# overviews. This option has no effect if EXTRACT_ALL is enabled.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	HIDE_FRIEND_COMPOUNDS(
			"# If the HIDE_FRIEND_COMPOUNDS tag is set to YES, Doxygen will hide all \n"
		+	"# friend (class|struct|union) declarations. \n"
		+	"# If set to NO (the default) these declarations will be included in the \n"
		+	"# documentation.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	HIDE_IN_BODY_DOCS(
			"# If the HIDE_IN_BODY_DOCS tag is set to YES, Doxygen will hide any \n"
		+	"# documentation blocks found inside the body of a function. \n"
		+	"# If set to NO (the default) these blocks will be appended to the \n"
		+	"# function's detailed documentation block.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	INTERNAL_DOCS(
			"# The INTERNAL_DOCS tag determines if documentation \n"
		+	"# that is typed after a \\internal command is included. If the tag is set \n"
		+	"# to NO (the default) then the documentation will be excluded. \n"
		+	"# Set it to YES to include the internal documentation.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	CASE_SENSE_NAMES(
			"# If the CASE_SENSE_NAMES tag is set to NO then Doxygen will only generate \n"
		+	"# file names in lower-case letters. If set to YES upper-case letters are also \n"
		+	"# allowed. This is useful if you have classes or files whose names only differ \n"
		+	"# in case and if your file system supports case sensitive file names. Windows \n"
		+	"# and Mac users are advised to set this option to NO.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	HIDE_SCOPE_NAMES(
			"# If the HIDE_SCOPE_NAMES tag is set to NO (the default) then Doxygen \n"
		+	"# will show members with their full class and namespace scopes in the \n"
		+	"# documentation. If set to YES the scope will be hidden.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	SHOW_INCLUDE_FILES(
			"# If the SHOW_INCLUDE_FILES tag is set to YES (the default) then Doxygen \n"
		+	"# will put a list of the files that are included by a file in the documentation \n"
		+	"# of that file.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	INLINE_INFO(
			"# If the INLINE_INFO tag is set to YES (the default) then a tag [inline] \n"
		+	"# is inserted in the documentation for inline members.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	SORT_MEMBER_DOCS(
			"# If the SORT_MEMBER_DOCS tag is set to YES (the default) then doxygen \n"
		+	"# will sort the (detailed) documentation of file and class members \n"
		+	"# alphabetically by member name. If set to NO the members will appear in \n"
		+	"# declaration order.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	SORT_BRIEF_DOCS(
			"# If the SORT_BRIEF_DOCS tag is set to YES then doxygen will sort the \n"
		+	"# brief documentation of file, namespace and class members alphabetically \n"
		+	"# by member name. If set to NO (the default) the members will appear in \n"
		+	"# declaration order.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	SORT_GROUP_NAMES(
			"# If the SORT_GROUP_NAMES tag is set to YES then doxygen will sort the \n"
		+	"# hierarchy of group names into alphabetical order. If set to NO (the default) \n"
		+	"# the group names will appear in their defined order.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	SORT_BY_SCOPE_NAME(
			"# If the SORT_BY_SCOPE_NAME tag is set to YES, the class list will be \n"
		+	"# sorted by fully-qualified names, including namespaces. If set to \n"
		+	"# NO (the default), the class list will be sorted only by class name, \n"
		+	"# not including the namespace part. \n"
		+	"# Note: This option is not very useful if HIDE_SCOPE_NAMES is set to YES.\n"
		+	"# Note: This option applies only to the class list, not to the \n"
		+	"# alphabetical list.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	GENERATE_TODOLIST(
			"# The GENERATE_TODOLIST tag can be used to enable (YES) or \n"
		+	"# disable (NO) the todo list. This list is created by putting \\todo \n"
		+	"# commands in the documentation.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	GENERATE_TESTLIST(
			"# The GENERATE_TESTLIST tag can be used to enable (YES) or \n"
		+	"# disable (NO) the test list. This list is created by putting \\test \n"
		+	"# commands in the documentation.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	GENERATE_BUGLIST(
			"# The GENERATE_BUGLIST tag can be used to enable (YES) or \n"
		+	"# disable (NO) the bug list. This list is created by putting \\bug \n"
		+	"# commands in the documentation.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	GENERATE_DEPRECATEDLIST(
			"# The GENERATE_DEPRECATEDLIST tag can be used to enable (YES) or \n"
		+	"# disable (NO) the deprecated list. This list is created by putting \n"
		+	"# \\deprecated commands in the documentation.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	ENABLED_SECTIONS(
			"# The ENABLED_SECTIONS tag can be used to enable conditional \n"
		+	"# documentation sections, marked by \\if sectionname ... \\endif.\n",
		DoxygenParameterType.STRING,
		null
	),
	MAX_INITIALIZER_LINES(
			"# The MAX_INITIALIZER_LINES tag determines the maximum number of lines \n"
		+	"# the initial value of a variable or define consists of for it to appear in \n"
		+	"# the documentation. If the initializer consists of more lines than specified \n"
		+	"# here it will be hidden. Use a value of 0 to hide initializers completely. \n"
		+	"# The appearance of the initializer of individual variables and defines in the \n"
		+	"# documentation can be controlled using \\showinitializer or \\hideinitializer \n"
		+	"# command in the documentation regardless of this setting.\n",
		DoxygenParameterType.INTEGER,
		"30"
	),
	SHOW_USED_FILES(
			"# Set the SHOW_USED_FILES tag to NO to disable the list of files generated \n"
		+	"# at the bottom of the documentation of classes and structs. If set to YES the \n"
		+	"# list will mention the files that were used to generate the documentation.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	SHOW_DIRECTORIES(
			"# If the sources in your project are distributed over multiple directories \n"
		+	"# then setting the SHOW_DIRECTORIES tag to YES will show the directory hierarchy \n"
		+	"# in the documentation. The default is NO.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	SHOW_FILES(
			"# Set the SHOW_FILES tag to NO to disable the generation of the Files page.\n"
		+	"# This will remove the Files entry from the Quick Index and from the \n"
		+	"# Folder Tree View (if specified). The default is YES.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	SHOW_NAMESPACES(
			"# Set the SHOW_NAMESPACES tag to NO to disable the generation of the \n"
		+	"# Namespaces page.  This will remove the Namespaces entry from the Quick Index\n"
		+	"# and from the Folder Tree View (if specified). The default is YES.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	FILE_VERSION_FILTER(
			"# The FILE_VERSION_FILTER tag can be used to specify a program or script that \n"
		+	"# doxygen should invoke to get the current version for each file (typically from \n"
		+	"# the version control system). Doxygen will invoke the program by executing (via \n"
		+	"# popen()) the command <command> <input-file>, where <command> is the value of \n"
		+	"# the FILE_VERSION_FILTER tag, and <input-file> is the name of an input file \n"
		+	"# provided by doxygen. Whatever the program writes to standard output \n"
		+	"# is used as the file version. See the manual for examples.\n",
		DoxygenParameterType.STRING,
		null
	),
	LAYOUT_FILE(
			"# The LAYOUT_FILE tag can be used to specify a layout file which will be parsed by \n"
		+	"# doxygen. The layout file controls the global structure of the generated output files \n"
		+	"# in an output format independent way. The create the layout file that represents \n"
		+	"# doxygen's defaults, run doxygen with the -l option. You can optionally specify a \n"
		+	"# file name after the option, if omitted DoxygenLayout.xml will be used as the name \n"
		+	"# of the layout file.\n",
		DoxygenParameterType.STRING,
		null
	),
	QUIET(
			"# The QUIET tag can be used to turn on/off the messages that are generated \n"
		+	"# by doxygen. Possible values are YES and NO. If left blank NO is used.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	WARNINGS(
			"# The WARNINGS tag can be used to turn on/off the warning messages that are \n"
		+	"# generated by doxygen. Possible values are YES and NO. If left blank \n"
		+	"# NO is used.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	WARN_IF_UNDOCUMENTED(
			"# If WARN_IF_UNDOCUMENTED is set to YES, then doxygen will generate warnings \n"
		+	"# for undocumented members. If EXTRACT_ALL is set to YES then this flag will \n"
		+	"# automatically be disabled.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	WARN_IF_DOC_ERROR(
			"# If WARN_IF_DOC_ERROR is set to YES, doxygen will generate warnings for \n"
		+	"# potential errors in the documentation, such as not documenting some \n"
		+	"# parameters in a documented function, or documenting parameters that \n"
		+	"# don't exist or using markup commands wrongly.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	WARN_NO_PARAMDOC(
			"# This WARN_NO_PARAMDOC option can be abled to get warnings for \n"
		+	"# functions that are documented, but have no documentation for their parameters \n"
		+	"# or return value. If set to NO (the default) doxygen will only warn about \n"
		+	"# wrong or incomplete parameter documentation, but not about the absence of \n"
		+	"# documentation.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	WARN_FORMAT(
			"# The WARN_FORMAT tag determines the format of the warning messages that \n"
		+	"# doxygen can produce. The string should contain the $file, $line, and $text \n"
		+	"# tags, which will be replaced by the file and line number from which the \n"
		+	"# warning originated and the warning text. Optionally the format may contain \n"
		+	"# $version, which will be replaced by the version of the file (if it could \n"
		+	"# be obtained via FILE_VERSION_FILTER)\n",
		DoxygenParameterType.STRING,
		"$file:$line: $text"
	),
	WARN_LOGFILE(
			"# The WARN_LOGFILE tag can be used to specify a file to which warning \n"
		+	"# and error messages should be written. If left blank the output is written \n"
		+	"# to stderr.\n",
		DoxygenParameterType.STRING,
		null
	),
	INPUT(
			"# The INPUT tag can be used to specify the files and/or directories that contain \n"
		+	"# documented source files. You may enter file names like \"myfile.cpp\" or \n"
		+	"# directories like \"/usr/src/myproject\". Separate the files or directories \n"
		+	"# with spaces.\n",
		DoxygenParameterType.STRING,
		null
	),
	INPUT_ENCODING(
			"# This tag can be used to specify the character encoding of the source files \n"
		+	"# that doxygen parses. Internally doxygen uses the UTF-8 encoding, which is \n"
		+	"# also the default input encoding. Doxygen uses libiconv (or the iconv built \n"
		+	"# into libc) for the transcoding. See http://www.gnu.org/software/libiconv for \n"
		+	"# the list of possible encodings.\n",
		DoxygenParameterType.STRING,
		"UTF-8"
	),
	FILE_PATTERNS(
			"# If the value of the INPUT tag contains directories, you can use the \n"
		+	"# FILE_PATTERNS tag to specify one or more wildcard pattern (like *.cpp \n"
		+	"# and *.h) to filter out the source-files in the directories. If left \n"
		+	"# blank the following patterns are tested: \n"
		+	"# *.c *.cc *.cxx *.cpp *.c++ *.java *.ii *.ixx *.ipp *.i++ *.inl *.h *.hh *.hxx \n"
		+	"# *.hpp *.h++ *.idl *.odl *.cs *.php *.php3 *.inc *.m *.mm *.py *.f90\n",
		DoxygenParameterType.STRING,
		"*.doxygen *.doxy *.cpp *.cxx *.hpp *.hxx *.ipp *.ixx *.py *.java"
	),
	RECURSIVE(
			"# The RECURSIVE tag can be used to turn specify whether or not subdirectories \n"
		+	"# should be searched for input files as well. Possible values are YES and NO. \n"
		+	"# If left blank NO is used.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	EXCLUDE(
			"# The EXCLUDE tag can be used to specify files and/or directories that should \n"
		+	"# excluded from the INPUT source files. This way you can easily exclude a \n"
		+	"# subdirectory from a directory tree whose root is specified with the INPUT tag.\n",
		DoxygenParameterType.STRING,
		".svn"
	),
	EXCLUDE_SYMLINKS(
			"# The EXCLUDE_SYMLINKS tag can be used select whether or not files or \n"
		+	"# directories that are symbolic links (a Unix filesystem feature) are excluded \n"
		+	"# from the input.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	EXCLUDE_PATTERNS(
			"# If the value of the INPUT tag contains directories, you can use the \n"
		+	"# EXCLUDE_PATTERNS tag to specify one or more wildcard patterns to exclude \n"
		+	"# certain files from those directories. Note that the wildcards are matched \n"
		+	"# against the file with absolute path, so to exclude all test directories \n"
		+	"# for example use the pattern */test/*\n",
		DoxygenParameterType.STRING,
		null
	),
	EXCLUDE_SYMBOLS(
			"# The EXCLUDE_SYMBOLS tag can be used to specify one or more symbol names \n"
		+	"# (namespaces, classes, functions, etc.) that should be excluded from the \n"
		+	"# output. The symbol name can be a fully qualified name, a word, or if the \n"
		+	"# wildcard * is used, a substring. Examples: ANamespace, AClass, \n"
		+	"# AClass::ANamespace, ANamespace::*Test\n",
		DoxygenParameterType.STRING,
		null
	),
	EXAMPLE_PATH(
			"# The EXAMPLE_PATH tag can be used to specify one or more files or \n"
		+	"# directories that contain example code fragments that are included (see \n"
		+	"# the \\include command).\n",
		DoxygenParameterType.STRING,
		null
	),
	EXAMPLE_PATTERNS(
			"# If the value of the EXAMPLE_PATH tag contains directories, you can use the \n"
		+	"# EXAMPLE_PATTERNS tag to specify one or more wildcard pattern (like *.cpp \n"
		+	"# and *.h) to filter out the source-files in the directories. If left \n"
		+	"# blank all files are included.\n",
		DoxygenParameterType.STRING,
		null
	),
	EXAMPLE_RECURSIVE(
			"# If the EXAMPLE_RECURSIVE tag is set to YES then subdirectories will be \n"
		+	"# searched for input files to be used with the \\include or \\dontinclude \n"
		+	"# commands irrespective of the value of the RECURSIVE tag. \n"
		+	"# Possible values are YES and NO. If left blank NO is used.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	IMAGE_PATH(
			"# The IMAGE_PATH tag can be used to specify one or more files or \n"
		+	"# directories that contain image that are included in the documentation (see \n"
		+	"# the \\image command).\n",
		DoxygenParameterType.STRING,
		null
	),
	INPUT_FILTER(
			"# The INPUT_FILTER tag can be used to specify a program that doxygen should \n"
		+	"# invoke to filter for each input file. Doxygen will invoke the filter program \n"
		+	"# by executing (via popen()) the command <filter> <input-file>, where <filter> \n"
		+	"# is the value of the INPUT_FILTER tag, and <input-file> is the name of an \n"
		+	"# input file. Doxygen will then use the output that the filter program writes \n"
		+	"# to standard output.  If FILTER_PATTERNS is specified, this tag will be \n"
		+	"# ignored.\n",
		DoxygenParameterType.STRING,
		null
	),
	FILTER_PATTERNS(
			"# The FILTER_PATTERNS tag can be used to specify filters on a per file pattern \n"
		+	"# basis.  Doxygen will compare the file name with each pattern and apply the \n"
		+	"# filter if there is a match.  The filters are a list of the form: \n"
		+	"# pattern=filter (like *.cpp=my_cpp_filter). See INPUT_FILTER for further \n"
		+	"# info on how filters are used. If FILTER_PATTERNS is empty, INPUT_FILTER \n"
		+	"# is applied to all files.\n",
		DoxygenParameterType.STRING,
		null
	),
	FILTER_SOURCE_FILES(
			"# If the FILTER_SOURCE_FILES tag is set to YES, the input filter (if set using \n"
		+	"# INPUT_FILTER) will be used to filter the input files when producing source \n"
		+	"# files to browse (i.e. when SOURCE_BROWSER is set to YES).\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	SOURCE_BROWSER(
			"# If the SOURCE_BROWSER tag is set to YES then a list of source files will \n"
		+	"# be generated. Documented entities will be cross-referenced with these sources. \n"
		+	"# Note: To get rid of all source code in the generated output, make sure also \n"
		+	"# VERBATIM_HEADERS is set to NO.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	INLINE_SOURCES(
			"# Setting the INLINE_SOURCES tag to YES will include the body \n"
		+	"# of functions and classes directly in the documentation.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	STRIP_CODE_COMMENTS(
			"# Setting the STRIP_CODE_COMMENTS tag to YES (the default) will instruct \n"
		+	"# doxygen to hide any special comment blocks from generated source code \n"
		+	"# fragments. Normal C and C++ comments will always remain visible.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	REFERENCED_BY_RELATION(
			"# If the REFERENCED_BY_RELATION tag is set to YES \n"
		+	"# then for each documented function all documented \n"
		+	"# functions referencing it will be listed.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	REFERENCES_RELATION(
			"# If the REFERENCES_RELATION tag is set to YES \n"
		+	"# then for each documented function all documented entities \n"
		+	"# called/used by that function will be listed.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	REFERENCES_LINK_SOURCE(
			"# If the REFERENCES_LINK_SOURCE tag is set to YES (the default)\n"
		+	"# and SOURCE_BROWSER tag is set to YES, then the hyperlinks from\n"
		+	"# functions in REFERENCES_RELATION and REFERENCED_BY_RELATION lists will\n"
		+	"# link to the source code.  Otherwise they will link to the documentstion.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	USE_HTAGS(
			"# If the USE_HTAGS tag is set to YES then the references to source code \n"
		+	"# will point to the HTML generated by the htags(1) tool instead of doxygen \n"
		+	"# built-in source browser. The htags tool is part of GNU's global source \n"
		+	"# tagging system (see http://www.gnu.org/software/global/global.html). You \n"
		+	"# will need version 4.8.6 or higher.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	VERBATIM_HEADERS(
			"# If the VERBATIM_HEADERS tag is set to YES (the default) then Doxygen \n"
		+	"# will generate a verbatim copy of the header file for each class for \n"
		+	"# which an include is specified. Set to NO to disable this.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	ALPHABETICAL_INDEX(
			"# If the ALPHABETICAL_INDEX tag is set to YES, an alphabetical index \n"
		+	"# of all compounds will be generated. Enable this if the project \n"
		+	"# contains a lot of classes, structs, unions or interfaces.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	COLS_IN_ALPHA_INDEX(
			"# If the alphabetical index is enabled (see ALPHABETICAL_INDEX) then \n"
		+	"# the COLS_IN_ALPHA_INDEX tag can be used to specify the number of columns \n"
		+	"# in which this list will be split (can be a number in the range [1..20])\n",
		DoxygenParameterType.INTEGER,
		"5"
	),
	IGNORE_PREFIX(
			"# In case all classes in a project start with a common prefix, all \n"
		+	"# classes will be put under the same header in the alphabetical index. \n"
		+	"# The IGNORE_PREFIX tag can be used to specify one or more prefixes that \n"
		+	"# should be ignored while generating the index headers.\n",
		DoxygenParameterType.STRING,
		null
	),
	GENERATE_HTML(
			"# If the GENERATE_HTML tag is set to YES (the default) Doxygen will \n"
		+	"# generate HTML output.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	HTML_OUTPUT(
			"# The HTML_OUTPUT tag is used to specify where the HTML docs will be put. \n"
		+	"# If a relative path is entered the value of OUTPUT_DIRECTORY will be \n"
		+	"# put in front of it. If left blank `html' will be used as the default path.\n",
		DoxygenParameterType.STRING,
		"html-doc"
	),
	HTML_FILE_EXTENSION(
			"# The HTML_FILE_EXTENSION tag can be used to specify the file extension for \n"
		+	"# each generated HTML page (for example: .htm,.php,.asp). If it is left blank \n"
		+	"# doxygen will generate files with .html extension.\n",
		DoxygenParameterType.STRING,
		".html"
	),
	HTML_HEADER(
			"# The HTML_HEADER tag can be used to specify a personal HTML header for \n"
		+	"# each generated HTML page. If it is left blank doxygen will generate a \n"
		+	"# standard header.\n",
		DoxygenParameterType.STRING,
		null
	),
	HTML_FOOTER(
			"# The HTML_FOOTER tag can be used to specify a personal HTML footer for \n"
		+	"# each generated HTML page. If it is left blank doxygen will generate a \n"
		+	"# standard footer.\n",
		DoxygenParameterType.STRING,
		null
	),
	HTML_STYLESHEET(
			"# The HTML_STYLESHEET tag can be used to specify a user-defined cascading \n"
		+	"# style sheet that is used by each HTML page. It can be used to \n"
		+	"# fine-tune the look of the HTML output. If the tag is left blank doxygen \n"
		+	"# will generate a default style sheet. Note that doxygen will try to copy \n"
		+	"# the style sheet file to the HTML output directory, so don't put your own \n"
		+	"# stylesheet in the HTML output directory as well, or it will be erased!\n",
		DoxygenParameterType.STRING,
		null
	),
	HTML_ALIGN_MEMBERS(
			"# If the HTML_ALIGN_MEMBERS tag is set to YES, the members of classes, \n"
		+	"# files or namespaces will be aligned in HTML using tables. If set to \n"
		+	"# NO a bullet list will be used.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	HTML_DYNAMIC_SECTIONS(
			"# If the HTML_DYNAMIC_SECTIONS tag is set to YES then the generated HTML \n"
		+	"# documentation will contain sections that can be hidden and shown after the \n"
		+	"# page has loaded. For this to work a browser that supports \n"
		+	"# JavaScript and DHTML is required (for instance Mozilla 1.0+, Firefox \n"
		+	"# Netscape 6.0+, Internet explorer 5.0+, Konqueror, or Safari).\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	GENERATE_DOCSET(
			"# If the GENERATE_DOCSET tag is set to YES, additional index files \n"
		+	"# will be generated that can be used as input for Apple's Xcode 3 \n"
		+	"# integrated development environment, introduced with OSX 10.5 (Leopard). \n"
		+	"# To create a documentation set, doxygen will generate a Makefile in the \n"
		+	"# HTML output directory. Running make will produce the docset in that \n"
		+	"# directory and running \"make install\" will install the docset in \n"
		+	"# ~/Library/Developer/Shared/Documentation/DocSets so that Xcode will find \n"
		+	"# it at startup. \n"
		+	"# See http://developer.apple.com/tools/creatingdocsetswithdoxygen.html for more information.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	DOCSET_FEEDNAME(
			"# When GENERATE_DOCSET tag is set to YES, this tag determines the name of the \n"
		+	"# feed. A documentation feed provides an umbrella under which multiple \n"
		+	"# documentation sets from a single provider (such as a company or product suite) \n"
		+	"# can be grouped.\n",
		DoxygenParameterType.STRING,
		"Doxygen generated docs"
	),
	DOCSET_BUNDLE_ID(
			"# When GENERATE_DOCSET tag is set to YES, this tag specifies a string that \n"
		+	"# should uniquely identify the documentation set bundle. This should be a \n"
		+	"# reverse domain-name style string, e.g. com.mycompany.MyDocSet. Doxygen \n"
		+	"# will append .docset to the name.\n",
		DoxygenParameterType.STRING,
		"org.doxygen.Project"
	),
	GENERATE_HTMLHELP(
			"# If the GENERATE_HTMLHELP tag is set to YES, additional index files \n"
		+	"# will be generated that can be used as input for tools like the \n"
		+	"# Microsoft HTML help workshop to generate a compiled HTML help file (.chm) \n"
		+	"# of the generated HTML documentation.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	CHM_FILE(
			"# If the GENERATE_HTMLHELP tag is set to YES, the CHM_FILE tag can \n"
		+	"# be used to specify the file name of the resulting .chm file. You \n"
		+	"# can add a path in front of the file if the result should not be \n"
		+	"# written to the html output directory.\n",
		DoxygenParameterType.STRING,
		null
	),
	HHC_LOCATION(
			"# If the GENERATE_HTMLHELP tag is set to YES, the HHC_LOCATION tag can \n"
		+	"# be used to specify the location (absolute path including file name) of \n"
		+	"# the HTML help compiler (hhc.exe). If non-empty doxygen will try to run \n"
		+	"# the HTML help compiler on the generated index.hhp.\n",
		DoxygenParameterType.STRING,
		null
	),
	GENERATE_CHI(
			"# If the GENERATE_HTMLHELP tag is set to YES, the GENERATE_CHI flag \n"
		+	"# controls if a separate .chi index file is generated (YES) or that \n"
		+	"# it should be included in the master .chm file (NO).\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	CHM_INDEX_ENCODING(
			"# If the GENERATE_HTMLHELP tag is set to YES, the CHM_INDEX_ENCODING\n"
		+	"# is used to encode HtmlHelp index (hhk), content (hhc) and project file\n"
		+	"# content.\n",
		DoxygenParameterType.STRING,
		null
	),
	BINARY_TOC(
			"# If the GENERATE_HTMLHELP tag is set to YES, the BINARY_TOC flag \n"
		+	"# controls whether a binary table of contents is generated (YES) or a \n"
		+	"# normal table of contents (NO) in the .chm file.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	TOC_EXPAND(
			"# The TOC_EXPAND flag can be set to YES to add extra items for group members \n"
		+	"# to the contents of the HTML help documentation and to the tree view.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	GENERATE_QHP(
			"# If the GENERATE_QHP tag is set to YES and both QHP_NAMESPACE and QHP_VIRTUAL_FOLDER \n"
		+	"# are set, an additional index file will be generated that can be used as input for \n"
		+	"# Qt's qhelpgenerator to generate a Qt Compressed Help (.qch) of the generated \n"
		+	"# HTML documentation.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	QCH_FILE(
			"# If the QHG_LOCATION tag is specified, the QCH_FILE tag can \n"
		+	"# be used to specify the file name of the resulting .qch file. \n"
		+	"# The path specified is relative to the HTML output folder.\n",
		DoxygenParameterType.STRING,
		null
	),
	QHP_NAMESPACE(
			"# The QHP_NAMESPACE tag specifies the namespace to use when generating \n"
		+	"# Qt Help Project output. For more information please see \n"
		+	"# <a href=\"http://doc.trolltech.com/qthelpproject.html#namespace\">Qt Help Project / Namespace</a>.\n",
		DoxygenParameterType.STRING,
		"org.doxygen.Project"
	),
	QHP_VIRTUAL_FOLDER(
			"# The QHP_VIRTUAL_FOLDER tag specifies the namespace to use when generating \n"
		+	"# Qt Help Project output. For more information please see \n"
		+	"# <a href=\"http://doc.trolltech.com/qthelpproject.html#virtual-folders\">Qt Help Project / Virtual Folders</a>.\n",
		DoxygenParameterType.STRING,
		"doc"
	),
	QHG_LOCATION(
			"# If the GENERATE_QHP tag is set to YES, the QHG_LOCATION tag can \n"
		+	"# be used to specify the location of Qt's qhelpgenerator. \n"
		+	"# If non-empty doxygen will try to run qhelpgenerator on the generated \n"
		+	"# .qhp file .\n",
		DoxygenParameterType.STRING,
		null
	),
	DISABLE_INDEX(
			"# The DISABLE_INDEX tag can be used to turn on/off the condensed index at \n"
		+	"# top of each HTML page. The value NO (the default) enables the index and \n"
		+	"# the value YES disables it.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	ENUM_VALUES_PER_LINE(
			"# This tag can be used to set the number of enum values (range [1..20]) \n"
		+	"# that doxygen will group on one line in the generated HTML documentation.\n",
		DoxygenParameterType.INTEGER,
		"4"
	),
	GENERATE_TREEVIEW(
			"# The GENERATE_TREEVIEW tag is used to specify whether a tree-like index\n"
		+	"# structure should be generated to display hierarchical information.\n"
		+	"# If the tag value is set to FRAME, a side panel will be generated\n"
		+	"# containing a tree-like index structure (just like the one that \n"
		+	"# is generated for HTML Help). For this to work a browser that supports \n"
		+	"# JavaScript, DHTML, CSS and frames is required (for instance Mozilla 1.0+, \n"
		+	"# Netscape 6.0+, Internet explorer 5.0+, or Konqueror). Windows users are \n"
		+	"# probably better off using the HTML help feature. Other possible values \n"
		+	"# for this tag are: HIERARCHIES, which will generate the Groups, Directories,\n"
		+	"# and Class Hierarchy pages using a tree view instead of an ordered list;\n"
		+	"# ALL, which combines the behavior of FRAME and HIERARCHIES; and NONE, which\n"
		+	"# disables this behavior completely. For backwards compatibility with previous\n"
		+	"# releases of Doxygen, the values YES and NO are equivalent to FRAME and NONE\n"
		+	"# respectively.\n",
		DoxygenParameterType.STRING,
		"ALL"
	),
	TREEVIEW_WIDTH(
			"# If the treeview is enabled (see GENERATE_TREEVIEW) then this tag can be \n"
		+	"# used to set the initial width (in pixels) of the frame in which the tree \n"
		+	"# is shown.\n",
		DoxygenParameterType.INTEGER,
		"250"
	),
	FORMULA_FONTSIZE(
			"# Use this tag to change the font size of Latex formulas included \n"
		+	"# as images in the HTML documentation. The default is 10. Note that \n"
		+	"# when you change the font size after a successful doxygen run you need \n"
		+	"# to manually remove any form_*.png images from the HTML output directory \n"
		+	"# to force them to be regenerated.\n",
		DoxygenParameterType.INTEGER,
		"10"
	),
	GENERATE_LATEX(
			"# If the GENERATE_LATEX tag is set to YES (the default) Doxygen will \n"
		+	"# generate Latex output.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	LATEX_OUTPUT(
			"# The LATEX_OUTPUT tag is used to specify where the LaTeX docs will be put. \n"
		+	"# If a relative path is entered the value of OUTPUT_DIRECTORY will be \n"
		+	"# put in front of it. If left blank `latex' will be used as the default path.\n",
		DoxygenParameterType.STRING,
		"latex"
	),
	LATEX_CMD_NAME(
			"# The LATEX_CMD_NAME tag can be used to specify the LaTeX command name to be \n"
		+	"# invoked. If left blank `latex' will be used as the default command name.\n",
		DoxygenParameterType.STRING,
		"latex"
	),
	MAKEINDEX_CMD_NAME(
			"# The MAKEINDEX_CMD_NAME tag can be used to specify the command name to \n"
		+	"# generate index for LaTeX. If left blank `makeindex' will be used as the \n"
		+	"# default command name.\n",
		DoxygenParameterType.STRING,
		"makeindex"
	),
	COMPACT_LATEX(
			"# If the COMPACT_LATEX tag is set to YES Doxygen generates more compact \n"
		+	"# LaTeX documents. This may be useful for small projects and may help to \n"
		+	"# save some trees in general.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	PAPER_TYPE(
			"# The PAPER_TYPE tag can be used to set the paper type that is used \n"
		+	"# by the printer. Possible values are: a4, a4wide, letter, legal and \n"
		+	"# executive. If left blank a4wide will be used.\n",
		DoxygenParameterType.STRING,
		"a4wide"
	),
	EXTRA_PACKAGES(
			"# The EXTRA_PACKAGES tag can be to specify one or more names of LaTeX \n"
		+	"# packages that should be included in the LaTeX output.\n",
		DoxygenParameterType.STRING,
		null
	),
	LATEX_HEADER(
			"# The LATEX_HEADER tag can be used to specify a personal LaTeX header for \n"
		+	"# the generated latex document. The header should contain everything until \n"
		+	"# the first chapter. If it is left blank doxygen will generate a \n"
		+	"# standard header. Notice: only use this tag if you know what you are doing!\n",
		DoxygenParameterType.STRING,
		null
	),
	PDF_HYPERLINKS(
			"# If the PDF_HYPERLINKS tag is set to YES, the LaTeX that is generated \n"
		+	"# is prepared for conversion to pdf (using ps2pdf). The pdf file will \n"
		+	"# contain links (just like the HTML output) instead of page references \n"
		+	"# This makes the output suitable for online browsing using a pdf viewer.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	USE_PDFLATEX(
			"# If the USE_PDFLATEX tag is set to YES, pdflatex will be used instead of \n"
		+	"# plain latex in the generated Makefile. Set this option to YES to get a \n"
		+	"# higher quality PDF documentation.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	LATEX_BATCHMODE(
			"# If the LATEX_BATCHMODE tag is set to YES, doxygen will add the \\\\batchmode. \n"
		+	"# command to the generated LaTeX files. This will instruct LaTeX to keep \n"
		+	"# running if errors occur, instead of asking the user for help. \n"
		+	"# This option is also used when generating formulas in HTML.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	LATEX_HIDE_INDICES(
			"# If LATEX_HIDE_INDICES is set to YES then doxygen will not \n"
		+	"# include the index chapters (such as File Index, Compound Index, etc.) \n"
		+	"# in the output.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	GENERATE_RTF(
			"# If the GENERATE_RTF tag is set to YES Doxygen will generate RTF output \n"
		+	"# The RTF output is optimized for Word 97 and may not look very pretty with \n"
		+	"# other RTF readers or editors.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	RTF_OUTPUT(
			"# The RTF_OUTPUT tag is used to specify where the RTF docs will be put. \n"
		+	"# If a relative path is entered the value of OUTPUT_DIRECTORY will be \n"
		+	"# put in front of it. If left blank `rtf' will be used as the default path.\n",
		DoxygenParameterType.STRING,
		"rtf"
	),
	COMPACT_RTF(
			"# If the COMPACT_RTF tag is set to YES Doxygen generates more compact \n"
		+	"# RTF documents. This may be useful for small projects and may help to \n"
		+	"# save some trees in general.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	RTF_HYPERLINKS(
			"# If the RTF_HYPERLINKS tag is set to YES, the RTF that is generated \n"
		+	"# will contain hyperlink fields. The RTF file will \n"
		+	"# contain links (just like the HTML output) instead of page references. \n"
		+	"# This makes the output suitable for online browsing using WORD or other \n"
		+	"# programs which support those fields. \n"
		+	"# Note: wordpad (write) and others do not support links.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	RTF_STYLESHEET_FILE(
			"# Load stylesheet definitions from file. Syntax is similar to doxygen's \n"
		+	"# config file, i.e. a series of assignments. You only have to provide \n"
		+	"# replacements, missing definitions are set to their default value.\n",
		DoxygenParameterType.STRING,
		null
	),
	RTF_EXTENSIONS_FILE(
			"# Set optional variables used in the generation of an rtf document. \n"
		+	"# Syntax is similar to doxygen's config file.\n",
		DoxygenParameterType.STRING,
		null
	),
	GENERATE_MAN(
			"# If the GENERATE_MAN tag is set to YES (the default) Doxygen will \n"
		+	"# generate man pages\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	MAN_OUTPUT(
			"# The MAN_OUTPUT tag is used to specify where the man pages will be put. \n"
		+	"# If a relative path is entered the value of OUTPUT_DIRECTORY will be \n"
		+	"# put in front of it. If left blank `man' will be used as the default path.\n",
		DoxygenParameterType.STRING,
		"man"
	),
	MAN_EXTENSION(
			"# The MAN_EXTENSION tag determines the extension that is added to \n"
		+	"# the generated man pages (default is the subroutine's section .3)\n",
		DoxygenParameterType.STRING,
		".3"
	),
	MAN_LINKS(
			"# If the MAN_LINKS tag is set to YES and Doxygen generates man output, \n"
		+	"# then it will generate one additional man file for each entity \n"
		+	"# documented in the real man page(s). These additional files \n"
		+	"# only source the real man page, but without them the man command \n"
		+	"# would be unable to find the correct page. The default is NO.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	GENERATE_XML(
			"# If the GENERATE_XML tag is set to YES Doxygen will \n"
		+	"# generate an XML file that captures the structure of \n"
		+	"# the code including all documentation.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	XML_OUTPUT(
			"# The XML_OUTPUT tag is used to specify where the XML pages will be put. \n"
		+	"# If a relative path is entered the value of OUTPUT_DIRECTORY will be \n"
		+	"# put in front of it. If left blank `xml' will be used as the default path.\n",
		DoxygenParameterType.STRING,
		"xml"
	),
	XML_SCHEMA(
			"# The XML_SCHEMA tag can be used to specify an XML schema, \n"
		+	"# which can be used by a validating XML parser to check the \n"
		+	"# syntax of the XML files.\n",
		DoxygenParameterType.STRING,
		null
	),
	XML_DTD(
			"# The XML_DTD tag can be used to specify an XML DTD, \n"
		+	"# which can be used by a validating XML parser to check the \n"
		+	"# syntax of the XML files.\n",
		DoxygenParameterType.STRING,
		null
	),
	XML_PROGRAMLISTING(
			"# If the XML_PROGRAMLISTING tag is set to YES Doxygen will \n"
		+	"# dump the program listings (including syntax highlighting \n"
		+	"# and cross-referencing information) to the XML output. Note that \n"
		+	"# enabling this will significantly increase the size of the XML output.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	GENERATE_AUTOGEN_DEF(
			"# If the GENERATE_AUTOGEN_DEF tag is set to YES Doxygen will \n"
		+	"# generate an AutoGen Definitions (see autogen.sf.net) file \n"
		+	"# that captures the structure of the code including all \n"
		+	"# documentation. Note that this feature is still experimental \n"
		+	"# and incomplete at the moment.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	GENERATE_PERLMOD(
			"# If the GENERATE_PERLMOD tag is set to YES Doxygen will \n"
		+	"# generate a Perl module file that captures the structure of \n"
		+	"# the code including all documentation. Note that this \n"
		+	"# feature is still experimental and incomplete at the \n"
		+	"# moment.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	PERLMOD_LATEX(
			"# If the PERLMOD_LATEX tag is set to YES Doxygen will generate \n"
		+	"# the necessary Makefile rules, Perl scripts and LaTeX code to be able \n"
		+	"# to generate PDF and DVI output from the Perl module output.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	PERLMOD_PRETTY(
			"# If the PERLMOD_PRETTY tag is set to YES the Perl module output will be \n"
		+	"# nicely formatted so it can be parsed by a human reader.  This is useful \n"
		+	"# if you want to understand what is going on.  On the other hand, if this \n"
		+	"# tag is set to NO the size of the Perl module output will be much smaller \n"
		+	"# and Perl will parse it just the same.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	PERLMOD_MAKEVAR_PREFIX(
			"# The names of the make variables in the generated doxyrules.make file \n"
		+	"# are prefixed with the string contained in PERLMOD_MAKEVAR_PREFIX. \n"
		+	"# This is useful so different doxyrules.make files included by the same \n"
		+	"# Makefile don't overwrite each other's variables.\n",
		DoxygenParameterType.STRING,
		null
	),
	ENABLE_PREPROCESSING(
			"# If the ENABLE_PREPROCESSING tag is set to YES (the default) Doxygen will \n"
		+	"# evaluate all C-preprocessor directives found in the sources and include \n"
		+	"# files.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	MACRO_EXPANSION(
			"# If the MACRO_EXPANSION tag is set to YES Doxygen will expand all macro \n"
		+	"# names in the source code. If set to NO (the default) only conditional \n"
		+	"# compilation will be performed. Macro expansion can be done in a controlled \n"
		+	"# way by setting EXPAND_ONLY_PREDEF to YES.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	EXPAND_ONLY_PREDEF(
			"# If the EXPAND_ONLY_PREDEF and MACRO_EXPANSION tags are both set to YES \n"
		+	"# then the macro expansion is limited to the macros specified with the \n"
		+	"# PREDEFINED and EXPAND_AS_DEFINED tags.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	SEARCH_INCLUDES(
			"# If the SEARCH_INCLUDES tag is set to YES (the default) the includes files \n"
		+	"# in the INCLUDE_PATH (see below) will be search if a #include is found.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	INCLUDE_PATH(
			"# The INCLUDE_PATH tag can be used to specify one or more directories that \n"
		+	"# contain include files that are not input files but should be processed by \n"
		+	"# the preprocessor.\n",
		DoxygenParameterType.STRING,
		null
	),
	INCLUDE_FILE_PATTERNS(
			"# You can use the INCLUDE_FILE_PATTERNS tag to specify one or more wildcard \n"
		+	"# patterns (like *.h and *.hpp) to filter out the header-files in the \n"
		+	"# directories. If left blank, the patterns specified with FILE_PATTERNS will \n"
		+	"# be used.\n",
		DoxygenParameterType.STRING,
		null
	),
	PREDEFINED(
			"# The PREDEFINED tag can be used to specify one or more macro names that \n"
		+	"# are defined before the preprocessor is started (similar to the -D option of \n"
		+	"# gcc). The argument of the tag is a list of macros of the form: name \n"
		+	"# or name=definition (no spaces). If the definition and the = are \n"
		+	"# omitted =1 is assumed. To prevent a macro definition from being \n"
		+	"# undefined via #undef or recursively expanded use the := operator \n"
		+	"# instead of the = operator.\n",
		DoxygenParameterType.STRING,
		null
	),
	EXPAND_AS_DEFINED(
			"# If the MACRO_EXPANSION and EXPAND_ONLY_PREDEF tags are set to YES then \n"
		+	"# this tag can be used to specify a list of macro names that should be expanded. \n"
		+	"# The macro definition that is found in the sources will be used. \n"
		+	"# Use the PREDEFINED tag if you want to use a different macro definition.\n",
		DoxygenParameterType.STRING,
		null
	),
	SKIP_FUNCTION_MACROS(
			"# If the SKIP_FUNCTION_MACROS tag is set to YES (the default) then \n"
		+	"# doxygen's preprocessor will remove all function-like macros that are alone \n"
		+	"# on a line, have an all uppercase name, and do not end with a semicolon. Such \n"
		+	"# function macros are typically used for boiler-plate code, and will confuse \n"
		+	"# the parser if not removed.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	TAGFILES(
			"# The TAGFILES option can be used to specify one or more tagfiles. \n"
		+	"# Optionally an initial location of the external documentation \n"
		+	"# can be added for each tagfile. The format of a tag file without \n"
		+	"# this location is as follows: \n"
		+	"# TAGFILES = file1 file2 ... \n"
		+	"# Adding location for the tag files is done as follows: \n"
		+	"# TAGFILES = file1=loc1 \"file2 = loc2\" ... \n"
		+	"# where \"loc1\" and \"loc2\" can be relative or absolute paths or \n"
		+	"# URLs. If a location is present for each tag, the installdox tool \n"
		+	"# does not have to be run to correct the links.\n"
		+	"# Note that each tag file must have a unique name\n"
		+	"# (where the name does NOT include the path)\n"
		+	"# If a tag file is not located in the directory in which doxygen \n"
		+	"# is run, you must also specify the path to the tagfile here.\n",
		DoxygenParameterType.STRING,
		null
	),
	GENERATE_TAGFILE(
			"# When a file name is specified after GENERATE_TAGFILE, doxygen will create \n"
		+	"# a tag file that is based on the input files it reads.\n",
		DoxygenParameterType.STRING,
		null
	),
	ALLEXTERNALS(
			"# If the ALLEXTERNALS tag is set to YES all external classes will be listed \n"
		+	"# in the class index. If set to NO only the inherited external classes \n"
		+	"# will be listed.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	EXTERNAL_GROUPS(
			"# If the EXTERNAL_GROUPS tag is set to YES all external groups will be listed \n"
		+	"# in the modules index. If set to NO, only the current project's groups will \n"
		+	"# be listed.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	PERL_PATH(
			"# The PERL_PATH should be the absolute path and name of the perl script \n"
		+	"# interpreter (i.e. the result of `which perl').\n",
		DoxygenParameterType.STRING,
		"/usr/bin/perl"
	),
	CLASS_DIAGRAMS(
			"# If the CLASS_DIAGRAMS tag is set to YES (the default) Doxygen will \n"
		+	"# generate a inheritance diagram (in HTML, RTF and LaTeX) for classes with base \n"
		+	"# or super classes. Setting the tag to NO turns the diagrams off. Note that \n"
		+	"# this option is superseded by the HAVE_DOT option below. This is only a \n"
		+	"# fallback. It is recommended to install and use dot, since it yields more \n"
		+	"# powerful graphs.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	MSCGEN_PATH(
			"# You can define message sequence charts within doxygen comments using the \\msc \n"
		+	"# command. Doxygen will then run the mscgen tool (see \n"
		+	"# http://www.mcternan.me.uk/mscgen/) to produce the chart and insert it in the \n"
		+	"# documentation. The MSCGEN_PATH tag allows you to specify the directory where \n"
		+	"# the mscgen tool resides. If left empty the tool is assumed to be found in the \n"
		+	"# default search path.\n",
		DoxygenParameterType.STRING,
		null
	),
	HIDE_UNDOC_RELATIONS(
			"# If set to YES, the inheritance and collaboration graphs will hide \n"
		+	"# inheritance and usage relations if the target is undocumented \n"
		+	"# or is not a class.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	HAVE_DOT(
			"# If you set the HAVE_DOT tag to YES then doxygen will assume the dot tool is \n"
		+	"# available from the path. This tool is part of Graphviz, a graph visualization \n"
		+	"# toolkit from AT&T and Lucent Bell Labs. The other options in this section \n"
		+	"# have no effect if this option is set to NO (the default)\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	DOT_FONTNAME(
			"# By default doxygen will write a font called FreeSans.ttf to the output \n"
		+	"# directory and reference it in all dot files that doxygen generates. This \n"
		+	"# font does not include all possible unicode characters however, so when you need \n"
		+	"# these (or just want a differently looking font) you can specify the font name \n"
		+	"# using DOT_FONTNAME. You need need to make sure dot is able to find the font, \n"
		+	"# which can be done by putting it in a standard location or by setting the \n"
		+	"# DOTFONTPATH environment variable or by setting DOT_FONTPATH to the directory \n"
		+	"# containing the font.\n",
		DoxygenParameterType.STRING,
		"FreeSans"
	),
	DOT_FONTSIZE(
			"# The DOT_FONTSIZE tag can be used to set the size of the font of dot graphs. \n"
		+	"# The default size is 10pt.\n",
		DoxygenParameterType.INTEGER,
		"10"
	),
	DOT_FONTPATH(
			"# By default doxygen will tell dot to use the output directory to look for the \n"
		+	"# FreeSans.ttf font (which doxygen will put there itself). If you specify a \n"
		+	"# different font using DOT_FONTNAME you can set the path where dot \n"
		+	"# can find it using this tag.\n",
		DoxygenParameterType.STRING,
		null
	),
	CLASS_GRAPH(
			"# If the CLASS_GRAPH and HAVE_DOT tags are set to YES then doxygen \n"
		+	"# will generate a graph for each documented class showing the direct and \n"
		+	"# indirect inheritance relations. Setting this tag to YES will force the \n"
		+	"# the CLASS_DIAGRAMS tag to NO.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	COLLABORATION_GRAPH(
			"# If the COLLABORATION_GRAPH and HAVE_DOT tags are set to YES then doxygen \n"
		+	"# will generate a graph for each documented class showing the direct and \n"
		+	"# indirect implementation dependencies (inheritance, containment, and \n"
		+	"# class references variables) of the class with other documented classes.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	GROUP_GRAPHS(
			"# If the GROUP_GRAPHS and HAVE_DOT tags are set to YES then doxygen \n"
		+	"# will generate a graph for groups, showing the direct groups dependencies\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	UML_LOOK(
			"# If the UML_LOOK tag is set to YES doxygen will generate inheritance and \n"
		+	"# collaboration diagrams in a style similar to the OMG's Unified Modeling \n"
		+	"# Language.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	TEMPLATE_RELATIONS(
			"# If set to YES, the inheritance and collaboration graphs will show the \n"
		+	"# relations between templates and their instances.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	INCLUDE_GRAPH(
			"# If the ENABLE_PREPROCESSING, SEARCH_INCLUDES, INCLUDE_GRAPH, and HAVE_DOT \n"
		+	"# tags are set to YES then doxygen will generate a graph for each documented \n"
		+	"# file showing the direct and indirect include dependencies of the file with \n"
		+	"# other documented files.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	INCLUDED_BY_GRAPH(
			"# If the ENABLE_PREPROCESSING, SEARCH_INCLUDES, INCLUDED_BY_GRAPH, and \n"
		+	"# HAVE_DOT tags are set to YES then doxygen will generate a graph for each \n"
		+	"# documented header file showing the documented files that directly or \n"
		+	"# indirectly include this file.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	CALL_GRAPH(
			"# If the CALL_GRAPH and HAVE_DOT options are set to YES then \n"
		+	"# doxygen will generate a call dependency graph for every global function \n"
		+	"# or class method. Note that enabling this option will significantly increase \n"
		+	"# the time of a run. So in most cases it will be better to enable call graphs \n"
		+	"# for selected functions only using the \\callgraph command.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	CALLER_GRAPH(
			"# If the CALLER_GRAPH and HAVE_DOT tags are set to YES then \n"
		+	"# doxygen will generate a caller dependency graph for every global function \n"
		+	"# or class method. Note that enabling this option will significantly increase \n"
		+	"# the time of a run. So in most cases it will be better to enable caller \n"
		+	"# graphs for selected functions only using the \\callergraph command.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	GRAPHICAL_HIERARCHY(
			"# If the GRAPHICAL_HIERARCHY and HAVE_DOT tags are set to YES then doxygen \n"
		+	"# will graphical hierarchy of all classes instead of a textual one.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	DIRECTORY_GRAPH(
			"# If the DIRECTORY_GRAPH, SHOW_DIRECTORIES and HAVE_DOT tags are set to YES \n"
		+	"# then doxygen will show the dependencies a directory has on other directories \n"
		+	"# in a graphical way. The dependency relations are determined by the #include\n"
		+	"# relations between the files in the directories.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	DOT_IMAGE_FORMAT(
			"# The DOT_IMAGE_FORMAT tag can be used to set the image format of the images \n"
		+	"# generated by dot. Possible values are png, jpg, or gif\n"
		+	"# If left blank png will be used.\n",
		DoxygenParameterType.STRING,
		"png"
	),
	DOT_PATH(
			"# The tag DOT_PATH can be used to specify the path where the dot tool can be \n"
		+	"# found. If left blank, it is assumed the dot tool can be found in the path.\n",
		DoxygenParameterType.STRING,
		"/usr/bin"
	),
	DOTFILE_DIRS(
			"# The DOTFILE_DIRS tag can be used to specify one or more directories that \n"
		+	"# contain dot files that are included in the documentation (see the \n"
		+	"# \\dotfile command).\n",
		DoxygenParameterType.STRING,
		null
	),
	DOT_GRAPH_MAX_NODES(
			"# The DOT_GRAPH_MAX_NODES tag can be used to set the maximum number of \n"
		+	"# nodes that will be shown in the graph. If the number of nodes in a graph \n"
		+	"# becomes larger than this value, doxygen will truncate the graph, which is \n"
		+	"# visualized by representing a node as a red box. Note that doxygen if the \n"
		+	"# number of direct children of the root node in a graph is already larger than \n"
		+	"# DOT_GRAPH_MAX_NODES then the graph will not be shown at all. Also note \n"
		+	"# that the size of a graph can be further restricted by MAX_DOT_GRAPH_DEPTH.\n",
		DoxygenParameterType.INTEGER,
		"50"
	),
	MAX_DOT_GRAPH_DEPTH(
			"# The MAX_DOT_GRAPH_DEPTH tag can be used to set the maximum depth of the \n"
		+	"# graphs generated by dot. A depth value of 3 means that only nodes reachable \n"
		+	"# from the root by following a path via at most 3 edges will be shown. Nodes \n"
		+	"# that lay further from the root node will be omitted. Note that setting this \n"
		+	"# option to 1 or 2 may greatly reduce the computation time needed for large \n"
		+	"# code bases. Also note that the size of a graph can be further restricted by \n"
		+	"# DOT_GRAPH_MAX_NODES. Using a depth of 0 means no depth restriction.\n",
		DoxygenParameterType.INTEGER,
		"0"
	),
	DOT_TRANSPARENT(
			"# Set the DOT_TRANSPARENT tag to YES to generate images with a transparent \n"
		+	"# background. This is disabled by default, because dot on Windows does not \n"
		+	"# seem to support this out of the box. Warning: Depending on the platform used, \n"
		+	"# enabling this option may lead to badly anti-aliased labels on the edges of \n"
		+	"# a graph (i.e. they become hard to read).\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	DOT_MULTI_TARGETS(
			"# Set the DOT_MULTI_TARGETS tag to YES allow dot to generate multiple output \n"
		+	"# files in one run (i.e. multiple -o and -T options on the command line). This \n"
		+	"# makes dot run faster, but since only newer versions of dot (>1.8.10) \n"
		+	"# support this, this feature is disabled by default.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	GENERATE_LEGEND(
			"# If the GENERATE_LEGEND tag is set to YES (the default) Doxygen will \n"
		+	"# generate a legend page explaining the meaning of the various boxes and \n"
		+	"# arrows in the dot generated graphs.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	DOT_CLEANUP(
			"# If the DOT_CLEANUP tag is set to YES (the default) Doxygen will \n"
		+	"# remove the intermediate dot files that are used to generate \n"
		+	"# the various graphs.\n",
		DoxygenParameterType.BOOLEAN,
		"true"
	),
	SEARCHENGINE(
			"# The SEARCHENGINE tag specifies whether or not a search engine should be \n"
		+	"# used. If set to NO the values of all tags below this one will be ignored.\n",
		DoxygenParameterType.BOOLEAN,
		"false"
	),
	;
	
	private String description;
	private DoxygenParameterType type;
	private String defaultValue;

	private DoxygenParameters(String description, DoxygenParameterType type, String defaultValue) {
		this.description = description;
		this.type = type;
		this.defaultValue = defaultValue;
	}

	public String getDescription() {
		return description;
	}

	public DoxygenParameterType getType() {
		return type;
	}

	public String getDefaultValue() {
		return defaultValue;
	}
}