package com.soebes.maven.plugins.dmg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on doxygen-maven-plugin.<br/> Call <pre>  mvn doxygen:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Fri Feb 12 17:33:51 CET 2010
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.5.1)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "com.soebes.maven.plugins.dmg:doxygen-maven-plugin:1.0.1", 0 );
        append( sb, "", 0 );

        append( sb, "Doxygen Maven Plugin", 0 );
        append( sb, "The Doxygen Maven Plugin provides the ability to generate Doxygen documentation from various source files.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 2 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "doxygen:help", 0 );
            append( sb, "Display help information on doxygen-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0doxygen:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "report".equals( goal ) )
        {
            append( sb, "doxygen:report", 0 );
            append( sb, "This part will create the report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "abbreviateBrief", 2 );
                append( sb, "This tag implements a quasi-intelligent brief description abbreviator that is used to form the text in various listings. Each string in this list, if found as the leading text of the brief description, will be stripped from the text and the result after processing the whole list, is used as the annotated text. Otherwise, the brief description is used as-is. If left blank, the following values are used (\'$name\' is automatically replaced with the name of the entity): \'The $name class\' \'The $name widget\' \'The $name file\' \'is\' \'provides\' \'specifies\' \'contains\' \'represents\' \'a\' \'an\' \'the\'", 3 );
                append( sb, "", 0 );

                append( sb, "aliases", 2 );
                append( sb, "This tag can be used to specify a number of aliases that acts as commands in the documentation. An alias has the form \'name=value\'. For example adding \'sideeffect=\\par Side Effects:\\n\' will allow you to put the command \\sideeffect (or @sideeffect) in the documentation, which will result in a user-defined paragraph with heading \'Side Effects:\'. You can put \\n\'s in the value part of an alias to insert newlines.", 3 );
                append( sb, "", 0 );

                append( sb, "allexternals (Default: false)", 2 );
                append( sb, "If the ALLEXTERNALS tag is set to YES all external classes will be listed in the class index. If set to NO only the inherited external classes will be listed.", 3 );
                append( sb, "", 0 );

                append( sb, "alphabeticalIndex (Default: true)", 2 );
                append( sb, "If the ALPHABETICAL_INDEX tag is set to YES, an alphabetical index of all compounds will be generated. Enable this if the project contains a lot of classes, structs, unions or interfaces.", 3 );
                append( sb, "", 0 );

                append( sb, "alwaysDetailedSec (Default: false)", 2 );
                append( sb, "If the ALWAYS_DETAILED_SEC and REPEAT_BRIEF tags are both set to YES then Doxygen will generate a detailed section even if there is only a brief description.", 3 );
                append( sb, "", 0 );

                append( sb, "binaryToc (Default: false)", 2 );
                append( sb, "If the GENERATE_HTMLHELP tag is set to YES, the BINARY_TOC flag controls whether a binary table of contents is generated (YES) or a normal table of contents (NO) in the .chm file.", 3 );
                append( sb, "", 0 );

                append( sb, "briefMemberDesc (Default: true)", 2 );
                append( sb, "If the BRIEF_MEMBER_DESC tag is set to YES (the default) Doxygen will include brief member descriptions after the members that are listed in the file and class documentation (similar to JavaDoc). Set to NO to disable this.", 3 );
                append( sb, "", 0 );

                append( sb, "builtinStlSupport (Default: true)", 2 );
                append( sb, "If you use STL classes (i.e. std::string, std::vector, etc.) but do not want to include (a tag file for) the STL sources as input, then you should set this tag to YES in order to let doxygen match functions declarations and definitions whose arguments contain STL classes (e.g. func(std::string); v.s. func(std::string) {}). This also make the inheritance and collaboration diagrams that involve STL classes more complete and accurate.", 3 );
                append( sb, "", 0 );

                append( sb, "callerGraph (Default: false)", 2 );
                append( sb, "If the CALLER_GRAPH and HAVE_DOT tags are set to YES then doxygen will generate a caller dependency graph for every global function or class method. Note that enabling this option will significantly increase the time of a run. So in most cases it will be better to enable caller graphs for selected functions only using the \\callergraph command.", 3 );
                append( sb, "", 0 );

                append( sb, "callGraph (Default: false)", 2 );
                append( sb, "If the CALL_GRAPH and HAVE_DOT options are set to YES then doxygen will generate a call dependency graph for every global function or class method. Note that enabling this option will significantly increase the time of a run. So in most cases it will be better to enable call graphs for selected functions only using the \\callgraph command.", 3 );
                append( sb, "", 0 );

                append( sb, "caseSenseNames (Default: true)", 2 );
                append( sb, "If the CASE_SENSE_NAMES tag is set to NO then Doxygen will only generate file names in lower-case letters. If set to YES upper-case letters are also allowed. This is useful if you have classes or files whose names only differ in case and if your file system supports case sensitive file names. Windows and Mac users are advised to set this option to NO.", 3 );
                append( sb, "", 0 );

                append( sb, "chmFile", 2 );
                append( sb, "If the GENERATE_HTMLHELP tag is set to YES, the CHM_FILE tag can be used to specify the file name of the resulting .chm file. You can add a path in front of the file if the result should not be written to the html output directory.", 3 );
                append( sb, "", 0 );

                append( sb, "chmIndexEncoding", 2 );
                append( sb, "If the GENERATE_HTMLHELP tag is set to YES, the CHM_INDEX_ENCODING is used to encode HtmlHelp index (hhk), content (hhc) and project file content.", 3 );
                append( sb, "", 0 );

                append( sb, "classDiagrams (Default: true)", 2 );
                append( sb, "If the CLASS_DIAGRAMS tag is set to YES (the default) Doxygen will generate a inheritance diagram (in HTML, RTF and LaTeX) for classes with base or super classes. Setting the tag to NO turns the diagrams off. Note that this option is superseded by the HAVE_DOT option below. This is only a fallback. It is recommended to install and use dot, since it yields more powerful graphs.", 3 );
                append( sb, "", 0 );

                append( sb, "classGraph (Default: true)", 2 );
                append( sb, "If the CLASS_GRAPH and HAVE_DOT tags are set to YES then doxygen will generate a graph for each documented class showing the direct and indirect inheritance relations. Setting this tag to YES will force the the CLASS_DIAGRAMS tag to NO.", 3 );
                append( sb, "", 0 );

                append( sb, "collaborationGraph (Default: true)", 2 );
                append( sb, "If the COLLABORATION_GRAPH and HAVE_DOT tags are set to YES then doxygen will generate a graph for each documented class showing the direct and indirect implementation dependencies (inheritance, containment, and class references variables) of the class with other documented classes.", 3 );
                append( sb, "", 0 );

                append( sb, "colsInAlphaIndex (Default: 5)", 2 );
                append( sb, "If the alphabetical index is enabled (see ALPHABETICAL_INDEX) then the COLS_IN_ALPHA_INDEX tag can be used to specify the number of columns in which this list will be split (can be a number in the range [1..20])", 3 );
                append( sb, "", 0 );

                append( sb, "compactLatex (Default: false)", 2 );
                append( sb, "If the COMPACT_LATEX tag is set to YES Doxygen generates more compact LaTeX documents. This may be useful for small projects and may help to save some trees in general.", 3 );
                append( sb, "", 0 );

                append( sb, "compactRtf (Default: false)", 2 );
                append( sb, "If the COMPACT_RTF tag is set to YES Doxygen generates more compact RTF documents. This may be useful for small projects and may help to save some trees in general.", 3 );
                append( sb, "", 0 );

                append( sb, "configurationFile", 2 );
                append( sb, "This defines which file will be used as Doxygen configuration file instead of creating one.", 3 );
                append( sb, "", 0 );

                append( sb, "cppCliSupport (Default: false)", 2 );
                append( sb, "If you use Microsoft\'s C++/CLI language, you should set this option to YES to enable parsing support.", 3 );
                append( sb, "", 0 );

                append( sb, "createSubdirs (Default: false)", 2 );
                append( sb, "If the CREATE_SUBDIRS tag is set to YES, then doxygen will create 4096 sub-directories (in 2 levels) under the output directory of each output format and will distribute the generated files over these directories. Enabling this option can be useful when feeding doxygen a huge amount of source files, where putting all generated files in the same directory would otherwise cause performance problems for the file system.", 3 );
                append( sb, "", 0 );

                append( sb, "destDir (Default: doxygen)", 2 );
                append( sb, "The name of the destination directory.", 3 );
                append( sb, "", 0 );

                append( sb, "directoryGraph (Default: true)", 2 );
                append( sb, "If the DIRECTORY_GRAPH, SHOW_DIRECTORIES and HAVE_DOT tags are set to YES then doxygen will show the dependencies a directory has on other directories in a graphical way. The dependency relations are determined by the #include relations between the files in the directories.", 3 );
                append( sb, "", 0 );

                append( sb, "disableIndex (Default: false)", 2 );
                append( sb, "The DISABLE_INDEX tag can be used to turn on/off the condensed index at top of each HTML page. The value NO (the default) enables the index and the value YES disables it.", 3 );
                append( sb, "", 0 );

                append( sb, "distributeGroupDoc (Default: false)", 2 );
                append( sb, "If member grouping is used in the documentation and the DISTRIBUTE_GROUP_DOC tag is set to YES, then doxygen will reuse the documentation of the first member in the group (if any) for the other members of the group. By default all members of a group must be documented explicitly.", 3 );
                append( sb, "", 0 );

                append( sb, "docsetBundleId (Default: org.doxygen.Project)", 2 );
                append( sb, "When GENERATE_DOCSET tag is set to YES, this tag specifies a string that should uniquely identify the documentation set bundle. This should be a reverse domain-name style string, e.g. com.mycompany.MyDocSet. Doxygen will append .docset to the name.", 3 );
                append( sb, "", 0 );

                append( sb, "docsetFeedname", 2 );
                append( sb, "When GENERATE_DOCSET tag is set to YES, this tag determines the name of the feed. A documentation feed provides an umbrella under which multiple documentation sets from a single provider (such as a company or product suite) can be grouped.", 3 );
                append( sb, "", 0 );

                append( sb, "dotCleanup (Default: true)", 2 );
                append( sb, "If the DOT_CLEANUP tag is set to YES (the default) Doxygen will remove the intermediate dot files that are used to generate the various graphs.", 3 );
                append( sb, "", 0 );

                append( sb, "dotfileDirs", 2 );
                append( sb, "The DOTFILE_DIRS tag can be used to specify one or more directories that contain dot files that are included in the documentation (see the \\dotfile command).", 3 );
                append( sb, "", 0 );

                append( sb, "dotFontname (Default: FreeSans)", 2 );
                append( sb, "By default doxygen will write a font called FreeSans.ttf to the output directory and reference it in all dot files that doxygen generates. This font does not include all possible unicode characters however, so when you need these (or just want a differently looking font) you can specify the font name using DOT_FONTNAME. You need need to make sure dot is able to find the font, which can be done by putting it in a standard location or by setting the DOTFONTPATH environment variable or by setting DOT_FONTPATH to the directory containing the font.", 3 );
                append( sb, "", 0 );

                append( sb, "dotFontpath", 2 );
                append( sb, "By default doxygen will tell dot to use the output directory to look for the FreeSans.ttf font (which doxygen will put there itself). If you specify a different font using DOT_FONTNAME you can set the path where dot can find it using this tag.", 3 );
                append( sb, "", 0 );

                append( sb, "dotFontsize (Default: 10)", 2 );
                append( sb, "The DOT_FONTSIZE tag can be used to set the size of the font of dot graphs. The default size is 10pt.", 3 );
                append( sb, "", 0 );

                append( sb, "dotGraphMaxNodes (Default: 50)", 2 );
                append( sb, "The DOT_GRAPH_MAX_NODES tag can be used to set the maximum number of nodes that will be shown in the graph. If the number of nodes in a graph becomes larger than this value, doxygen will truncate the graph, which is visualized by representing a node as a red box. Note that doxygen if the number of direct children of the root node in a graph is already larger than DOT_GRAPH_MAX_NODES then the graph will not be shown at all. Also note that the size of a graph can be further restricted by MAX_DOT_GRAPH_DEPTH.", 3 );
                append( sb, "", 0 );

                append( sb, "dotImageFormat (Default: png)", 2 );
                append( sb, "The DOT_IMAGE_FORMAT tag can be used to set the image format of the images generated by dot. Possible values are png, jpg, or gif If left blank png will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "dotMultiTargets (Default: true)", 2 );
                append( sb, "Set the DOT_MULTI_TARGETS tag to YES allow dot to generate multiple output files in one run (i.e. multiple -o and -T options on the command line). This makes dot run faster, but since only newer versions of dot (>1.8.10) support this, this feature is disabled by default.", 3 );
                append( sb, "", 0 );

                append( sb, "dotPath (Default: /usr/bin)", 2 );
                append( sb, "The tag DOT_PATH can be used to specify the path where the dot tool can be found. If left blank, it is assumed the dot tool can be found in the path.", 3 );
                append( sb, "", 0 );

                append( sb, "dotTransparent (Default: true)", 2 );
                append( sb, "Set the DOT_TRANSPARENT tag to YES to generate images with a transparent background. This is disabled by default, because dot on Windows does not seem to support this out of the box. Warning: Depending on the platform used, enabling this option may lead to badly anti-aliased labels on the edges of a graph (i.e. they become hard to read).", 3 );
                append( sb, "", 0 );

                append( sb, "doxyfileEncoding (Default: UTF-8)", 2 );
                append( sb, "This tag specifies the encoding used for all characters in the config file that follow. The default is UTF-8 which is also the encoding used for all text before the first occurrence of this tag. Doxygen uses libiconv (or the iconv built into libc) for the transcoding. See http://www.gnu.org/software/libiconv for the list of possible encodings.", 3 );
                append( sb, "", 0 );

                append( sb, "enabledSections", 2 );
                append( sb, "The ENABLED_SECTIONS tag can be used to enable conditional documentation sections, marked by \\if sectionname ... \\endif.", 3 );
                append( sb, "", 0 );

                append( sb, "enablePreprocessing (Default: true)", 2 );
                append( sb, "If the ENABLE_PREPROCESSING tag is set to YES (the default) Doxygen will evaluate all C-preprocessor directives found in the sources and include files.", 3 );
                append( sb, "", 0 );

                append( sb, "enumValuesPerLine (Default: 4)", 2 );
                append( sb, "This tag can be used to set the number of enum values (range [1..20]) that doxygen will group on one line in the generated HTML documentation.", 3 );
                append( sb, "", 0 );

                append( sb, "examplePath", 2 );
                append( sb, "The EXAMPLE_PATH tag can be used to specify one or more files or directories that contain example code fragments that are included (see the \\include command).", 3 );
                append( sb, "", 0 );

                append( sb, "examplePatterns", 2 );
                append( sb, "If the value of the EXAMPLE_PATH tag contains directories, you can use the EXAMPLE_PATTERNS tag to specify one or more wildcard pattern (like *.cpp and *.h) to filter out the source-files in the directories. If left blank all files are included.", 3 );
                append( sb, "", 0 );

                append( sb, "exampleRecursive (Default: false)", 2 );
                append( sb, "If the EXAMPLE_RECURSIVE tag is set to YES then subdirectories will be searched for input files to be used with the \\include or \\dontinclude commands irrespective of the value of the RECURSIVE tag. Possible values are YES and NO. If left blank NO is used.", 3 );
                append( sb, "", 0 );

                append( sb, "exclude (Default: .svn)", 2 );
                append( sb, "The EXCLUDE tag can be used to specify files and/or directories that should excluded from the INPUT source files. This way you can easily exclude a subdirectory from a directory tree whose root is specified with the INPUT tag.", 3 );
                append( sb, "", 0 );

                append( sb, "excludePatterns", 2 );
                append( sb, "If the value of the INPUT tag contains directories, you can use the EXCLUDE_PATTERNS tag to specify one or more wildcard patterns to exclude certain files from those directories. Note that the wildcards are matched against the file with absolute path, so to exclude all test directories for example use the pattern &x2a/test/&x2a", 3 );
                append( sb, "", 0 );

                append( sb, "excludeSymbols", 2 );
                append( sb, "The EXCLUDE_SYMBOLS tag can be used to specify one or more symbol names (namespaces, classes, functions, etc.) that should be excluded from the output. The symbol name can be a fully qualified name, a word, or if the wildcard * is used, a substring. Examples: ANamespace, AClass, AClass::ANamespace, ANamespace::*Test", 3 );
                append( sb, "", 0 );

                append( sb, "excludeSymlinks (Default: false)", 2 );
                append( sb, "The EXCLUDE_SYMLINKS tag can be used select whether or not files or directories that are symbolic links (a Unix filesystem feature) are excluded from the input.", 3 );
                append( sb, "", 0 );

                append( sb, "executable (Default: doxygen)", 2 );
                append( sb, "This defines the name and/or the absolute path to he doxygen executable. Usually you shouldn\'t change this, cause the plugin will automatically search for the executable.", 3 );
                append( sb, "", 0 );

                append( sb, "expandAsDefined", 2 );
                append( sb, "If the MACRO_EXPANSION and EXPAND_ONLY_PREDEF tags are set to YES then this tag can be used to specify a list of macro names that should be expanded. The macro definition that is found in the sources will be used. Use the PREDEFINED tag if you want to use a different macro definition.", 3 );
                append( sb, "", 0 );

                append( sb, "expandOnlyPredef (Default: false)", 2 );
                append( sb, "If the EXPAND_ONLY_PREDEF and MACRO_EXPANSION tags are both set to YES then the macro expansion is limited to the macros specified with the PREDEFINED and EXPAND_AS_DEFINED tags.", 3 );
                append( sb, "", 0 );

                append( sb, "externalGroups (Default: true)", 2 );
                append( sb, "If the EXTERNAL_GROUPS tag is set to YES all external groups will be listed in the modules index. If set to NO, only the current project\'s groups will be listed.", 3 );
                append( sb, "", 0 );

                append( sb, "extractAll (Default: false)", 2 );
                append( sb, "If the EXTRACT_ALL tag is set to YES doxygen will assume all entities in documentation are documented, even if no documentation was available. Private class members and static file members will be hidden unless the EXTRACT_PRIVATE and EXTRACT_STATIC tags are set to YES", 3 );
                append( sb, "", 0 );

                append( sb, "extractAnonNspaces (Default: false)", 2 );
                append( sb, "If this flag is set to YES, the members of anonymous namespaces will be extracted and appear in the documentation as a namespace called \'anonymous_namespace{file}\', where file will be replaced with the base name of the file that contains the anonymous namespace. By default anonymous namespace are hidden.", 3 );
                append( sb, "", 0 );

                append( sb, "extractLocalClasses (Default: true)", 2 );
                append( sb, "If the EXTRACT_LOCAL_CLASSES tag is set to YES classes (and structs) defined locally in source files will be included in the documentation. If set to NO only classes defined in header files are included.", 3 );
                append( sb, "", 0 );

                append( sb, "extractLocalMethods (Default: false)", 2 );
                append( sb, "This flag is only useful for Objective-C code. When set to YES local methods, which are defined in the implementation section but not in the interface are included in the documentation. If set to NO (the default) only methods in the interface are included.", 3 );
                append( sb, "", 0 );

                append( sb, "extractPrivate (Default: false)", 2 );
                append( sb, "If the EXTRACT_PRIVATE tag is set to YES all private members of a class will be included in the documentation.", 3 );
                append( sb, "", 0 );

                append( sb, "extractStatic (Default: false)", 2 );
                append( sb, "If the EXTRACT_STATIC tag is set to YES all static members of a file will be included in the documentation.", 3 );
                append( sb, "", 0 );

                append( sb, "extraPackages", 2 );
                append( sb, "The EXTRA_PACKAGES tag can be to specify one or more names of LaTeX packages that should be included in the LaTeX output.", 3 );
                append( sb, "", 0 );

                append( sb, "filePatterns (Default: *.doxygen *.doxy *.cpp *.cxx *.hpp *.hxx *.ipp *.ixx *.py *.java)", 2 );
                append( sb, "If the value of the INPUT tag contains directories, you can use the FILE_PATTERNS tag to specify one or more wildcard pattern (like *.cpp and *.h) to filter out the source-files in the directories. If left blank the following patterns are tested: *.c *.cc *.cxx *.cpp *.c++ *.java *.ii *.ixx *.ipp *.i++ *.inl *.h *.hh *.hxx *.hpp *.h++ *.idl *.odl *.cs *.php *.php3 *.inc *.m *.mm *.py *.f90", 3 );
                append( sb, "", 0 );

                append( sb, "fileVersionFilter", 2 );
                append( sb, "The FILE_VERSION_FILTER tag can be used to specify a program or script that doxygen should invoke to get the current version for each file (typically from the version control system). Doxygen will invoke the program by executing (via popen()) the command <command> <input-file>, where <command> is the value of the FILE_VERSION_FILTER tag, and <input-file> is the name of an input file provided by doxygen. Whatever the program writes to standard output is used as the file version. See the manual for examples.", 3 );
                append( sb, "", 0 );

                append( sb, "filterPatterns", 2 );
                append( sb, "The FILTER_PATTERNS tag can be used to specify filters on a per file pattern basis. Doxygen will compare the file name with each pattern and apply the filter if there is a match. The filters are a list of the form: pattern=filter (like *.cpp=my_cpp_filter). See INPUT_FILTER for further info on how filters are used. If FILTER_PATTERNS is empty, INPUT_FILTER is applied to all files.", 3 );
                append( sb, "", 0 );

                append( sb, "filterSourceFiles (Default: false)", 2 );
                append( sb, "If the FILTER_SOURCE_FILES tag is set to YES, the input filter (if set using INPUT_FILTER) will be used to filter the input files when producing source files to browse (i.e. when SOURCE_BROWSER is set to YES).", 3 );
                append( sb, "", 0 );

                append( sb, "formulaFontsize (Default: 10)", 2 );
                append( sb, "Use this tag to change the font size of Latex formulas included as images in the HTML documentation. The default is 10. Note that when you change the font size after a successful doxygen run you need to manually remove any form_*.png images from the HTML output directory to force them to be regenerated.", 3 );
                append( sb, "", 0 );

                append( sb, "fullPathNames (Default: true)", 2 );
                append( sb, "If the FULL_PATH_NAMES tag is set to YES then Doxygen will prepend the full path before files name in the file list and in the header files. If set to NO the shortest path that makes the file name unique will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "generateAutogenDef (Default: false)", 2 );
                append( sb, "If the GENERATE_AUTOGEN_DEF tag is set to YES Doxygen will generate an AutoGen Definitions (see autogen.sf.net) file that captures the structure of the code including all documentation. Note that this feature is still experimental and incomplete at the moment.", 3 );
                append( sb, "", 0 );

                append( sb, "generateBuglist (Default: true)", 2 );
                append( sb, "The GENERATE_BUGLIST tag can be used to enable (YES) or disable (NO) the bug list. This list is created by putting \\bug commands in the documentation.", 3 );
                append( sb, "", 0 );

                append( sb, "generateChi (Default: false)", 2 );
                append( sb, "If the GENERATE_HTMLHELP tag is set to YES, the GENERATE_CHI flag controls if a separate .chi index file is generated (YES) or that it should be included in the master .chm file (NO).", 3 );
                append( sb, "", 0 );

                append( sb, "generateDeprecatedlist (Default: true)", 2 );
                append( sb, "The GENERATE_DEPRECATEDLIST tag can be used to enable (YES) or disable (NO) the deprecated list. This list is created by putting \\deprecated commands in the documentation.", 3 );
                append( sb, "", 0 );

                append( sb, "generateDocset (Default: false)", 2 );
                append( sb, "If the GENERATE_DOCSET tag is set to YES, additional index files will be generated that can be used as input for Apple\'s Xcode 3 integrated development environment, introduced with OSX 10.5 (Leopard). To create a documentation set, doxygen will generate a Makefile in the HTML output directory. Running make will produce the docset in that directory and running \'make install\' will install the docset in ~/Library/Developer/Shared/Documentation/DocSets so that Xcode will find it at startup. See http://developer.apple.com/tools/creatingdocsetswithdoxygen.html for more information.", 3 );
                append( sb, "", 0 );

                append( sb, "generateHtml (Default: true)", 2 );
                append( sb, "If the GENERATE_HTML tag is set to YES (the default) Doxygen will generate HTML output.", 3 );
                append( sb, "", 0 );

                append( sb, "generateHtmlhelp (Default: false)", 2 );
                append( sb, "If the GENERATE_HTMLHELP tag is set to YES, additional index files will be generated that can be used as input for tools like the Microsoft HTML help workshop to generate a compiled HTML help file (.chm) of the generated HTML documentation.", 3 );
                append( sb, "", 0 );

                append( sb, "generateLatex (Default: false)", 2 );
                append( sb, "If the GENERATE_LATEX tag is set to YES (the default) Doxygen will generate Latex output.", 3 );
                append( sb, "", 0 );

                append( sb, "generateLegend (Default: true)", 2 );
                append( sb, "If the GENERATE_LEGEND tag is set to YES (the default) Doxygen will generate a legend page explaining the meaning of the various boxes and arrows in the dot generated graphs.", 3 );
                append( sb, "", 0 );

                append( sb, "generateMan (Default: false)", 2 );
                append( sb, "If the GENERATE_MAN tag is set to YES (the default) Doxygen will generate man pages", 3 );
                append( sb, "", 0 );

                append( sb, "generatePerlmod (Default: false)", 2 );
                append( sb, "If the GENERATE_PERLMOD tag is set to YES Doxygen will generate a Perl module file that captures the structure of the code including all documentation. Note that this feature is still experimental and incomplete at the moment.", 3 );
                append( sb, "", 0 );

                append( sb, "generateQhp (Default: false)", 2 );
                append( sb, "If the GENERATE_QHP tag is set to YES and both QHP_NAMESPACE and QHP_VIRTUAL_FOLDER are set, an additional index file will be generated that can be used as input for Qt\'s qhelpgenerator to generate a Qt Compressed Help (.qch) of the generated HTML documentation.", 3 );
                append( sb, "", 0 );

                append( sb, "generateRtf (Default: false)", 2 );
                append( sb, "If the GENERATE_RTF tag is set to YES Doxygen will generate RTF output The RTF output is optimized for Word 97 and may not look very pretty with other RTF readers or editors.", 3 );
                append( sb, "", 0 );

                append( sb, "generateTagfile", 2 );
                append( sb, "When a file name is specified after GENERATE_TAGFILE, doxygen will create a tag file that is based on the input files it reads.", 3 );
                append( sb, "", 0 );

                append( sb, "generateTestlist (Default: true)", 2 );
                append( sb, "The GENERATE_TESTLIST tag can be used to enable (YES) or disable (NO) the test list. This list is created by putting \\test commands in the documentation.", 3 );
                append( sb, "", 0 );

                append( sb, "generateTodolist (Default: true)", 2 );
                append( sb, "The GENERATE_TODOLIST tag can be used to enable (YES) or disable (NO) the todo list. This list is created by putting \\todo commands in the documentation.", 3 );
                append( sb, "", 0 );

                append( sb, "generateTreeview (Default: ALL)", 2 );
                append( sb, "The GENERATE_TREEVIEW tag is used to specify whether a tree-like index structure should be generated to display hierarchical information. If the tag value is set to FRAME, a side panel will be generated containing a tree-like index structure (just like the one that is generated for HTML Help). For this to work a browser that supports JavaScript, DHTML, CSS and frames is required (for instance Mozilla 1.0+, Netscape 6.0+, Internet explorer 5.0+, or Konqueror). Windows users are probably better off using the HTML help feature. Other possible values for this tag are: HIERARCHIES, which will generate the Groups, Directories, and Class Hierarchy pages using a tree view instead of an ordered list; ALL, which combines the behavior of FRAME and HIERARCHIES; and NONE, which disables this behavior completely. For backwards compatibility with previous releases of Doxygen, the values YES and NO are equivalent to FRAME and NONE respectively.", 3 );
                append( sb, "", 0 );

                append( sb, "generateXml (Default: false)", 2 );
                append( sb, "If the GENERATE_XML tag is set to YES Doxygen will generate an XML file that captures the structure of the code including all documentation.", 3 );
                append( sb, "", 0 );

                append( sb, "graphicalHierarchy (Default: true)", 2 );
                append( sb, "If the GRAPHICAL_HIERARCHY and HAVE_DOT tags are set to YES then doxygen will graphical hierarchy of all classes instead of a textual one.", 3 );
                append( sb, "", 0 );

                append( sb, "groupGraphs (Default: true)", 2 );
                append( sb, "If the GROUP_GRAPHS and HAVE_DOT tags are set to YES then doxygen will generate a graph for groups, showing the direct groups dependencies", 3 );
                append( sb, "", 0 );

                append( sb, "haveDot (Default: true)", 2 );
                append( sb, "If you set the HAVE_DOT tag to YES then doxygen will assume the dot tool is available from the path. This tool is part of Graphviz, a graph visualization toolkit from AT&T and Lucent Bell Labs. The other options in this section have no effect if this option is set to NO (the default)", 3 );
                append( sb, "", 0 );

                append( sb, "hhcLocation", 2 );
                append( sb, "If the GENERATE_HTMLHELP tag is set to YES, the HHC_LOCATION tag can be used to specify the location (absolute path including file name) of the HTML help compiler (hhc.exe). If non-empty doxygen will try to run the HTML help compiler on the generated index.hhp.", 3 );
                append( sb, "", 0 );

                append( sb, "hideFriendCompounds (Default: false)", 2 );
                append( sb, "If the HIDE_FRIEND_COMPOUNDS tag is set to YES, Doxygen will hide all friend (class|struct|union) declarations. If set to NO (the default) these declarations will be included in the documentation.", 3 );
                append( sb, "", 0 );

                append( sb, "hideInBodyDocs (Default: false)", 2 );
                append( sb, "If the HIDE_IN_BODY_DOCS tag is set to YES, Doxygen will hide any documentation blocks found inside the body of a function. If set to NO (the default) these blocks will be appended to the function\'s detailed documentation block.", 3 );
                append( sb, "", 0 );

                append( sb, "hideScopeNames (Default: false)", 2 );
                append( sb, "If the HIDE_SCOPE_NAMES tag is set to NO (the default) then Doxygen will show members with their full class and namespace scopes in the documentation. If set to YES the scope will be hidden.", 3 );
                append( sb, "", 0 );

                append( sb, "hideUndocClasses (Default: false)", 2 );
                append( sb, "If the HIDE_UNDOC_CLASSES tag is set to YES, Doxygen will hide all undocumented classes that are normally visible in the class hierarchy. If set to NO (the default) these classes will be included in the various overviews. This option has no effect if EXTRACT_ALL is enabled.", 3 );
                append( sb, "", 0 );

                append( sb, "hideUndocMembers (Default: false)", 2 );
                append( sb, "If the HIDE_UNDOC_MEMBERS tag is set to YES, Doxygen will hide all undocumented members of documented classes, files or namespaces. If set to NO (the default) these members will be included in the various overviews, but no documentation section is generated. This option has no effect if EXTRACT_ALL is enabled.", 3 );
                append( sb, "", 0 );

                append( sb, "hideUndocRelations (Default: true)", 2 );
                append( sb, "If set to YES, the inheritance and collaboration graphs will hide inheritance and usage relations if the target is undocumented or is not a class.", 3 );
                append( sb, "", 0 );

                append( sb, "htmlAlignMembers (Default: true)", 2 );
                append( sb, "If the HTML_ALIGN_MEMBERS tag is set to YES, the members of classes, files or namespaces will be aligned in HTML using tables. If set to NO a bullet list will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "htmlDynamicSections (Default: true)", 2 );
                append( sb, "If the HTML_DYNAMIC_SECTIONS tag is set to YES then the generated HTML documentation will contain sections that can be hidden and shown after the page has loaded. For this to work a browser that supports JavaScript and DHTML is required (for instance Mozilla 1.0+, Firefox Netscape 6.0+, Internet explorer 5.0+, Konqueror, or Safari).", 3 );
                append( sb, "", 0 );

                append( sb, "htmlFileExtension (Default: .html)", 2 );
                append( sb, "The HTML_FILE_EXTENSION tag can be used to specify the file extension for each generated HTML page (for example: .htm,.php,.asp). If it is left blank doxygen will generate files with .html extension.", 3 );
                append( sb, "", 0 );

                append( sb, "htmlFooter", 2 );
                append( sb, "The HTML_FOOTER tag can be used to specify a personal HTML footer for each generated HTML page. If it is left blank doxygen will generate a standard footer.", 3 );
                append( sb, "", 0 );

                append( sb, "htmlHeader", 2 );
                append( sb, "The HTML_HEADER tag can be used to specify a personal HTML header for each generated HTML page. If it is left blank doxygen will generate a standard header.", 3 );
                append( sb, "", 0 );

                append( sb, "htmlOutput (Default: doxygen)", 2 );
                append( sb, "The HTML_OUTPUT tag is used to specify where the HTML docs will be put. If a relative path is entered the value of OUTPUT_DIRECTORY will be put in front of it. If left blank `html\' will be used as the default path.", 3 );
                append( sb, "", 0 );

                append( sb, "htmlStylesheet", 2 );
                append( sb, "The HTML_STYLESHEET tag can be used to specify a user-defined cascading style sheet that is used by each HTML page. It can be used to fine-tune the look of the HTML output. If the tag is left blank doxygen will generate a default style sheet. Note that doxygen will try to copy the style sheet file to the HTML output directory, so don\'t put your own stylesheet in the HTML output directory as well, or it will be erased!", 3 );
                append( sb, "", 0 );

                append( sb, "idlPropertySupport (Default: true)", 2 );
                append( sb, "For Microsoft\'s IDL there are propget and propput attributes to indicate getter and setter methods for a property. Setting this option to YES (the default) will make doxygen to replace the get and set methods by a property in the documentation. This will only work if the methods are indeed getting or setting a simple type. If this is not the case, or you want to show the methods anyway, you should set this option to NO.", 3 );
                append( sb, "", 0 );

                append( sb, "ignorePrefix", 2 );
                append( sb, "In case all classes in a project start with a common prefix, all classes will be put under the same header in the alphabetical index. The IGNORE_PREFIX tag can be used to specify one or more prefixes that should be ignored while generating the index headers.", 3 );
                append( sb, "", 0 );

                append( sb, "imagePath", 2 );
                append( sb, "The IMAGE_PATH tag can be used to specify one or more files or directories that contain image that are included in the documentation (see the \\image command).", 3 );
                append( sb, "", 0 );

                append( sb, "includedByGraph (Default: true)", 2 );
                append( sb, "If the ENABLE_PREPROCESSING, SEARCH_INCLUDES, INCLUDED_BY_GRAPH, and HAVE_DOT tags are set to YES then doxygen will generate a graph for each documented header file showing the documented files that directly or indirectly include this file.", 3 );
                append( sb, "", 0 );

                append( sb, "includeFilePatterns", 2 );
                append( sb, "You can use the INCLUDE_FILE_PATTERNS tag to specify one or more wildcard patterns (like *.h and *.hpp) to filter out the header-files in the directories. If left blank, the patterns specified with FILE_PATTERNS will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "includeGraph (Default: true)", 2 );
                append( sb, "If the ENABLE_PREPROCESSING, SEARCH_INCLUDES, INCLUDE_GRAPH, and HAVE_DOT tags are set to YES then doxygen will generate a graph for each documented file showing the direct and indirect include dependencies of the file with other documented files.", 3 );
                append( sb, "", 0 );

                append( sb, "includePath", 2 );
                append( sb, "The INCLUDE_PATH tag can be used to specify one or more directories that contain include files that are not input files but should be processed by the preprocessor.", 3 );
                append( sb, "", 0 );

                append( sb, "inheritDocs (Default: true)", 2 );
                append( sb, "If the INHERIT_DOCS tag is set to YES (the default) then an undocumented member inherits the documentation from any documented member that it re-implements.", 3 );
                append( sb, "", 0 );

                append( sb, "inlineInfo (Default: true)", 2 );
                append( sb, "If the INLINE_INFO tag is set to YES (the default) then a tag [inline] is inserted in the documentation for inline members.", 3 );
                append( sb, "", 0 );

                append( sb, "inlineInheritedMemb (Default: false)", 2 );
                append( sb, "If the INLINE_INHERITED_MEMB tag is set to YES, doxygen will show all inherited members of a class in the documentation of that class as if those members were ordinary class members. Constructors, destructors and assignment operators of the base classes will not be shown.", 3 );
                append( sb, "", 0 );

                append( sb, "inlineSources (Default: false)", 2 );
                append( sb, "Setting the INLINE_SOURCES tag to YES will include the body of functions and classes directly in the documentation.", 3 );
                append( sb, "", 0 );

                append( sb, "input", 2 );
                append( sb, "The INPUT tag can be used to specify the files and/or directories that contain documented source files. You may enter file names like \'myfile.cpp\' or directories like \'/usr/src/myproject\'. Separate the files or directories with spaces.", 3 );
                append( sb, "", 0 );

                append( sb, "inputEncoding (Default: UTF-8)", 2 );
                append( sb, "This tag can be used to specify the character encoding of the source files that doxygen parses. Internally doxygen uses the UTF-8 encoding, which is also the default input encoding. Doxygen uses libiconv (or the iconv built into libc) for the transcoding. See http://www.gnu.org/software/libiconv for the list of possible encodings.", 3 );
                append( sb, "", 0 );

                append( sb, "inputFilter", 2 );
                append( sb, "The INPUT_FILTER tag can be used to specify a program that doxygen should invoke to filter for each input file. Doxygen will invoke the filter program by executing (via popen()) the command <filter> <input-file>, where <filter> is the value of the INPUT_FILTER tag, and <input-file> is the name of an input file. Doxygen will then use the output that the filter program writes to standard output. If FILTER_PATTERNS is specified, this tag will be ignored.", 3 );
                append( sb, "", 0 );

                append( sb, "internalDocs (Default: false)", 2 );
                append( sb, "The INTERNAL_DOCS tag determines if documentation that is typed after a \\internal command is included. If the tag is set to NO (the default) then the documentation will be excluded. Set it to YES to include the internal documentation.", 3 );
                append( sb, "", 0 );

                append( sb, "javadocAutobrief (Default: false)", 2 );
                append( sb, "If the JAVADOC_AUTOBRIEF tag is set to YES then Doxygen will interpret the first line (until the first dot) of a JavaDoc-style comment as the brief description. If set to NO, the JavaDoc comments will behave just like regular Qt-style comments (thus requiring an explicit @brief command for a brief description.)", 3 );
                append( sb, "", 0 );

                append( sb, "latexBatchmode (Default: false)", 2 );
                append( sb, "If the LATEX_BATCHMODE tag is set to YES, doxygen will add the \\\\batchmode. command to the generated LaTeX files. This will instruct LaTeX to keep running if errors occur, instead of asking the user for help. This option is also used when generating formulas in HTML.", 3 );
                append( sb, "", 0 );

                append( sb, "latexCmdName (Default: latex)", 2 );
                append( sb, "The LATEX_CMD_NAME tag can be used to specify the LaTeX command name to be invoked. If left blank `latex\' will be used as the default command name.", 3 );
                append( sb, "", 0 );

                append( sb, "latexHeader", 2 );
                append( sb, "The LATEX_HEADER tag can be used to specify a personal LaTeX header for the generated latex document. The header should contain everything until the first chapter. If it is left blank doxygen will generate a standard header. Notice: only use this tag if you know what you are doing!", 3 );
                append( sb, "", 0 );

                append( sb, "latexHideIndices (Default: false)", 2 );
                append( sb, "If LATEX_HIDE_INDICES is set to YES then doxygen will not include the index chapters (such as File Index, Compound Index, etc.) in the output.", 3 );
                append( sb, "", 0 );

                append( sb, "latexOutput (Default: latex)", 2 );
                append( sb, "The LATEX_OUTPUT tag is used to specify where the LaTeX docs will be put. If a relative path is entered the value of OUTPUT_DIRECTORY will be put in front of it. If left blank `latex\' will be used as the default path.", 3 );
                append( sb, "", 0 );

                append( sb, "layoutFile", 2 );
                append( sb, "The LAYOUT_FILE tag can be used to specify a layout file which will be parsed by doxygen. The layout file controls the global structure of the generated output files in an output format independent way. The create the layout file that represents doxygen\'s defaults, run doxygen with the -l option. You can optionally specify a file name after the option, if omitted DoxygenLayout.xml will be used as the name of the layout file.", 3 );
                append( sb, "", 0 );

                append( sb, "macroExpansion (Default: false)", 2 );
                append( sb, "If the MACRO_EXPANSION tag is set to YES Doxygen will expand all macro names in the source code. If set to NO (the default) only conditional compilation will be performed. Macro expansion can be done in a controlled way by setting EXPAND_ONLY_PREDEF to YES.", 3 );
                append( sb, "", 0 );

                append( sb, "makeindexCmdName (Default: makeindex)", 2 );
                append( sb, "The MAKEINDEX_CMD_NAME tag can be used to specify the command name to generate index for LaTeX. If left blank `makeindex\' will be used as the default command name.", 3 );
                append( sb, "", 0 );

                append( sb, "manExtension (Default: .3)", 2 );
                append( sb, "The MAN_EXTENSION tag determines the extension that is added to the generated man pages (default is the subroutine\'s section .3)", 3 );
                append( sb, "", 0 );

                append( sb, "manLinks (Default: false)", 2 );
                append( sb, "If the MAN_LINKS tag is set to YES and Doxygen generates man output, then it will generate one additional man file for each entity documented in the real man page(s). These additional files only source the real man page, but without them the man command would be unable to find the correct page. The default is NO.", 3 );
                append( sb, "", 0 );

                append( sb, "manOutput (Default: man)", 2 );
                append( sb, "The MAN_OUTPUT tag is used to specify where the man pages will be put. If a relative path is entered the value of OUTPUT_DIRECTORY will be put in front of it. If left blank `man\' will be used as the default path.", 3 );
                append( sb, "", 0 );

                append( sb, "maxDotGraphDepth (Default: 0)", 2 );
                append( sb, "The MAX_DOT_GRAPH_DEPTH tag can be used to set the maximum depth of the graphs generated by dot. A depth value of 3 means that only nodes reachable from the root by following a path via at most 3 edges will be shown. Nodes that lay further from the root node will be omitted. Note that setting this option to 1 or 2 may greatly reduce the computation time needed for large code bases. Also note that the size of a graph can be further restricted by DOT_GRAPH_MAX_NODES. Using a depth of 0 means no depth restriction.", 3 );
                append( sb, "", 0 );

                append( sb, "maxInitializerLines (Default: 30)", 2 );
                append( sb, "The MAX_INITIALIZER_LINES tag determines the maximum number of lines the initial value of a variable or define consists of for it to appear in the documentation. If the initializer consists of more lines than specified here it will be hidden. Use a value of 0 to hide initializers completely. The appearance of the initializer of individual variables and defines in the documentation can be controlled using \\showinitializer or \\hideinitializer command in the documentation regardless of this setting.", 3 );
                append( sb, "", 0 );

                append( sb, "mscgenPath", 2 );
                append( sb, "You can define message sequence charts within doxygen comments using the \\msc command. Doxygen will then run the mscgen tool (see http://www.mcternan.me.uk/mscgen/) to produce the chart and insert it in the documentation. The MSCGEN_PATH tag allows you to specify the directory where the mscgen tool resides. If left empty the tool is assumed to be found in the default search path.", 3 );
                append( sb, "", 0 );

                append( sb, "multilineCppIsBrief (Default: false)", 2 );
                append( sb, "The MULTILINE_CPP_IS_BRIEF tag can be set to YES to make Doxygen treat a multi-line C++ special comment block (i.e. a block of //! or /// comments) as a brief description. This used to be the default behaviour. The new default is to treat a multi-line C++ comment block as a detailed description. Set this tag to YES if you prefer the old behaviour instead.", 3 );
                append( sb, "", 0 );

                append( sb, "optimizeForFortran (Default: false)", 2 );
                append( sb, "Set the OPTIMIZE_FOR_FORTRAN tag to YES if your project consists of Fortran sources only. Doxygen will then generate output that is more tailored for Fortran.", 3 );
                append( sb, "", 0 );

                append( sb, "optimizeOutputForC (Default: false)", 2 );
                append( sb, "Set the OPTIMIZE_OUTPUT_FOR_C tag to YES if your project consists of C sources only. Doxygen will then generate output that is more tailored for C. For instance, some of the names that are used will be different. The list of all members will be omitted, etc.", 3 );
                append( sb, "", 0 );

                append( sb, "optimizeOutputJava (Default: false)", 2 );
                append( sb, "Set the OPTIMIZE_OUTPUT_JAVA tag to YES if your project consists of Java sources only. Doxygen will then generate output that is more tailored for Java. For instance, namespaces will be presented as packages, qualified scopes will look different, etc.", 3 );
                append( sb, "", 0 );

                append( sb, "optimizeOutputVhdl (Default: false)", 2 );
                append( sb, "Set the OPTIMIZE_OUTPUT_VHDL tag to YES if your project consists of VHDL sources. Doxygen will then generate output that is tailored for VHDL.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2 );
                append( sb, "The OUTPUT_DIRECTORY tag is used to specify the (relative or absolute) base path where the generated documentation will be put. If a relative path is entered, it will be relative to the location where doxygen was started. If left blank the current directory will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "outputLanguage (Default: English)", 2 );
                append( sb, "The OUTPUT_LANGUAGE tag is used to specify the language in which all documentation generated by doxygen is written. Doxygen will use this information to generate all constant output in the proper language. The default language is English, other supported languages are: Afrikaans, Arabic, Brazilian, Catalan, Chinese, Chinese-Traditional, Croatian, Czech, Danish, Dutch, Farsi, Finnish, French, German, Greek, Hungarian, Italian, Japanese, Japanese-en (Japanese with English messages), Korean, Korean-en, Lithuanian, Norwegian, Macedonian, Persian, Polish, Portuguese, Romanian, Russian, Serbian, Serbian-Cyrilic, Slovak, Slovene, Spanish, Swedish, and Ukrainian.", 3 );
                append( sb, "", 0 );

                append( sb, "paperType (Default: a4wide)", 2 );
                append( sb, "The PAPER_TYPE tag can be used to set the paper type that is used by the printer. Possible values are: a4, a4wide, letter, legal and executive. If left blank a4wide will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "pdfHyperlinks (Default: true)", 2 );
                append( sb, "If the PDF_HYPERLINKS tag is set to YES, the LaTeX that is generated is prepared for conversion to pdf (using ps2pdf). The pdf file will contain links (just like the HTML output) instead of page references This makes the output suitable for online browsing using a pdf viewer.", 3 );
                append( sb, "", 0 );

                append( sb, "perlmodLatex (Default: false)", 2 );
                append( sb, "If the PERLMOD_LATEX tag is set to YES Doxygen will generate the necessary Makefile rules, Perl scripts and LaTeX code to be able to generate PDF and DVI output from the Perl module output.", 3 );
                append( sb, "", 0 );

                append( sb, "perlmodMakevarPrefix", 2 );
                append( sb, "The names of the make variables in the generated doxyrules.make file are prefixed with the string contained in PERLMOD_MAKEVAR_PREFIX. This is useful so different doxyrules.make files included by the same Makefile don\'t overwrite each other\'s variables.", 3 );
                append( sb, "", 0 );

                append( sb, "perlmodPretty (Default: true)", 2 );
                append( sb, "If the PERLMOD_PRETTY tag is set to YES the Perl module output will be nicely formatted so it can be parsed by a human reader. This is useful if you want to understand what is going on. On the other hand, if this tag is set to NO the size of the Perl module output will be much smaller and Perl will parse it just the same.", 3 );
                append( sb, "", 0 );

                append( sb, "perlPath (Default: /usr/bin/perl)", 2 );
                append( sb, "The PERL_PATH should be the absolute path and name of the perl script interpreter (i.e. the result of `which perl\').", 3 );
                append( sb, "", 0 );

                append( sb, "predefined", 2 );
                append( sb, "The PREDEFINED tag can be used to specify one or more macro names that are defined before the preprocessor is started (similar to the -D option of gcc). The argument of the tag is a list of macros of the form: name or name=definition (no spaces). If the definition and the = are omitted =1 is assumed. To prevent a macro definition from being undefined via #undef or recursively expanded use the := operator instead of the = operator.", 3 );
                append( sb, "", 0 );

                append( sb, "projectName (Default: MIGRATION.PARENT)", 2 );
                append( sb, "The PROJECT_NAME tag is a single word (or a sequence of words surrounded by quotes) that should identify the project.", 3 );
                append( sb, "", 0 );

                append( sb, "projectNumber", 2 );
                append( sb, "The PROJECT_NUMBER tag can be used to enter a project or revision number. This could be handy for archiving the generated documentation or if some version control system is used.", 3 );
                append( sb, "", 0 );

                append( sb, "qchFile", 2 );
                append( sb, "If the QHG_LOCATION tag is specified, the QCH_FILE tag can be used to specify the file name of the resulting .qch file. The path specified is relative to the HTML output folder.", 3 );
                append( sb, "", 0 );

                append( sb, "qhgLocation", 2 );
                append( sb, "If the GENERATE_QHP tag is set to YES, the QHG_LOCATION tag can be used to specify the location of Qt\'s qhelpgenerator. If non-empty doxygen will try to run qhelpgenerator on the generated .qhp file .", 3 );
                append( sb, "", 0 );

                append( sb, "qhpNamespace (Default: org.doxygen.Project)", 2 );
                append( sb, "The QHP_NAMESPACE tag specifies the namespace to use when generating Qt Help Project output. For more information please see <a href=\'http://doc.trolltech.com/qthelpproject.html#namespace\'>Qt Help Project / Namespace</a>.", 3 );
                append( sb, "", 0 );

                append( sb, "qhpVirtualFolder (Default: doc)", 2 );
                append( sb, "The QHP_VIRTUAL_FOLDER tag specifies the namespace to use when generating Qt Help Project output. For more information please see <a href=\'http://doc.trolltech.com/qthelpproject.html#virtual-folders\'>Qt Help Project / Virtual Folders</a>.", 3 );
                append( sb, "", 0 );

                append( sb, "qtAutobrief (Default: false)", 2 );
                append( sb, "If the QT_AUTOBRIEF tag is set to YES then Doxygen will interpret the first line (until the first dot) of a Qt-style comment as the brief description. If set to NO, the comments will behave just like regular Qt-style comments (thus requiring an explicit \\brief command for a brief description.)", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: true)", 2 );
                append( sb, "The QUIET tag can be used to turn on/off the messages that are generated by doxygen. Possible values are YES and NO. If left blank NO is used.", 3 );
                append( sb, "", 0 );

                append( sb, "recursive (Default: false)", 2 );
                append( sb, "The RECURSIVE tag can be used to turn specify whether or not subdirectories should be searched for input files as well. Possible values are YES and NO. If left blank NO is used.", 3 );
                append( sb, "", 0 );

                append( sb, "referencedByRelation (Default: false)", 2 );
                append( sb, "If the REFERENCED_BY_RELATION tag is set to YES then for each documented function all documented functions referencing it will be listed.", 3 );
                append( sb, "", 0 );

                append( sb, "referencesLinkSource (Default: true)", 2 );
                append( sb, "If the REFERENCES_LINK_SOURCE tag is set to YES (the default) and SOURCE_BROWSER tag is set to YES, then the hyperlinks from functions in REFERENCES_RELATION and REFERENCED_BY_RELATION lists will link to the source code. Otherwise they will link to the documentstion.", 3 );
                append( sb, "", 0 );

                append( sb, "referencesRelation (Default: false)", 2 );
                append( sb, "If the REFERENCES_RELATION tag is set to YES then for each documented function all documented entities called/used by that function will be listed.", 3 );
                append( sb, "", 0 );

                append( sb, "repeatBrief (Default: true)", 2 );
                append( sb, "If the REPEAT_BRIEF tag is set to YES (the default) Doxygen will prepend the brief description of a member or function before the detailed description. Note: if both HIDE_UNDOC_MEMBERS and BRIEF_MEMBER_DESC are set to NO, the brief descriptions will be completely suppressed.", 3 );
                append( sb, "", 0 );

                append( sb, "reportOutputDirectory (Default: ${project.reporting.outputDirectory})", 2 );
                append( sb, "Specifies the destination directory where javadoc saves the generated HTML files.", 3 );
                append( sb, "", 0 );

                append( sb, "rtfExtensionsFile", 2 );
                append( sb, "Set optional variables used in the generation of an rtf document. Syntax is similar to doxygen\'s config file.", 3 );
                append( sb, "", 0 );

                append( sb, "rtfHyperlinks (Default: false)", 2 );
                append( sb, "If the RTF_HYPERLINKS tag is set to YES, the RTF that is generated will contain hyperlink fields. The RTF file will contain links (just like the HTML output) instead of page references. This makes the output suitable for online browsing using WORD or other programs which support those fields. Note: wordpad (write) and others do not support links.", 3 );
                append( sb, "", 0 );

                append( sb, "rtfOutput (Default: rtf)", 2 );
                append( sb, "The RTF_OUTPUT tag is used to specify where the RTF docs will be put. If a relative path is entered the value of OUTPUT_DIRECTORY will be put in front of it. If left blank `rtf\' will be used as the default path.", 3 );
                append( sb, "", 0 );

                append( sb, "rtfStylesheetFile", 2 );
                append( sb, "Load stylesheet definitions from file. Syntax is similar to doxygen\'s config file, i.e. a series of assignments. You only have to provide replacements, missing definitions are set to their default value.", 3 );
                append( sb, "", 0 );

                append( sb, "searchengine (Default: false)", 2 );
                append( sb, "The SEARCHENGINE tag specifies whether or not a search engine should be used. If set to NO the values of all tags below this one will be ignored.", 3 );
                append( sb, "", 0 );

                append( sb, "searchIncludes (Default: true)", 2 );
                append( sb, "If the SEARCH_INCLUDES tag is set to YES (the default) the includes files in the INCLUDE_PATH (see below) will be search if a #include is found.", 3 );
                append( sb, "", 0 );

                append( sb, "separateMemberPages (Default: false)", 2 );
                append( sb, "If the SEPARATE_MEMBER_PAGES tag is set to YES, then doxygen will produce a new page for each member. If set to NO, the documentation of a member will be part of the file/class/namespace that contains it.", 3 );
                append( sb, "", 0 );

                append( sb, "shortNames (Default: false)", 2 );
                append( sb, "If the SHORT_NAMES tag is set to YES, doxygen will generate much shorter (but less readable) file names. This can be useful is your file systems doesn\'t support long names like on DOS, Mac, or CD-ROM.", 3 );
                append( sb, "", 0 );

                append( sb, "showDirectories (Default: true)", 2 );
                append( sb, "If the sources in your project are distributed over multiple directories then setting the SHOW_DIRECTORIES tag to YES will show the directory hierarchy in the documentation. The default is NO.", 3 );
                append( sb, "", 0 );

                append( sb, "showFiles (Default: true)", 2 );
                append( sb, "Set the SHOW_FILES tag to NO to disable the generation of the Files page. This will remove the Files entry from the Quick Index and from the Folder Tree View (if specified). The default is YES.", 3 );
                append( sb, "", 0 );

                append( sb, "showIncludeFiles (Default: true)", 2 );
                append( sb, "If the SHOW_INCLUDE_FILES tag is set to YES (the default) then Doxygen will put a list of the files that are included by a file in the documentation of that file.", 3 );
                append( sb, "", 0 );

                append( sb, "showNamespaces (Default: true)", 2 );
                append( sb, "Set the SHOW_NAMESPACES tag to NO to disable the generation of the Namespaces page. This will remove the Namespaces entry from the Quick Index and from the Folder Tree View (if specified). The default is YES.", 3 );
                append( sb, "", 0 );

                append( sb, "showUsedFiles (Default: true)", 2 );
                append( sb, "Set the SHOW_USED_FILES tag to NO to disable the list of files generated at the bottom of the documentation of classes and structs. If set to YES the list will mention the files that were used to generate the documentation.", 3 );
                append( sb, "", 0 );

                append( sb, "sipSupport (Default: false)", 2 );
                append( sb, "Set the SIP_SUPPORT tag to YES if your project consists of sip sources only. Doxygen will parse them like normal C++ but will assume all classes use public instead of private inheritance when no explicit protection keyword is present.", 3 );
                append( sb, "", 0 );

                append( sb, "skipFunctionMacros (Default: true)", 2 );
                append( sb, "If the SKIP_FUNCTION_MACROS tag is set to YES (the default) then doxygen\'s preprocessor will remove all function-like macros that are alone on a line, have an all uppercase name, and do not end with a semicolon. Such function macros are typically used for boiler-plate code, and will confuse the parser if not removed.", 3 );
                append( sb, "", 0 );

                append( sb, "sortBriefDocs (Default: false)", 2 );
                append( sb, "If the SORT_BRIEF_DOCS tag is set to YES then doxygen will sort the brief documentation of file, namespace and class members alphabetically by member name. If set to NO (the default) the members will appear in declaration order.", 3 );
                append( sb, "", 0 );

                append( sb, "sortByScopeName (Default: false)", 2 );
                append( sb, "If the SORT_BY_SCOPE_NAME tag is set to YES, the class list will be sorted by fully-qualified names, including namespaces. If set to NO (the default), the class list will be sorted only by class name, not including the namespace part. Note: This option is not very useful if HIDE_SCOPE_NAMES is set to YES. Note: This option applies only to the class list, not to the alphabetical list.", 3 );
                append( sb, "", 0 );

                append( sb, "sortGroupNames (Default: false)", 2 );
                append( sb, "If the SORT_GROUP_NAMES tag is set to YES then doxygen will sort the hierarchy of group names into alphabetical order. If set to NO (the default) the group names will appear in their defined order.", 3 );
                append( sb, "", 0 );

                append( sb, "sortMemberDocs (Default: true)", 2 );
                append( sb, "If the SORT_MEMBER_DOCS tag is set to YES (the default) then doxygen will sort the (detailed) documentation of file and class members alphabetically by member name. If set to NO the members will appear in declaration order.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceBrowser (Default: true)", 2 );
                append( sb, "If the SOURCE_BROWSER tag is set to YES then a list of source files will be generated. Documented entities will be cross-referenced with these sources. Note: To get rid of all source code in the generated output, make sure also VERBATIM_HEADERS is set to NO.", 3 );
                append( sb, "", 0 );

                append( sb, "stripCodeComments (Default: true)", 2 );
                append( sb, "Setting the STRIP_CODE_COMMENTS tag to YES (the default) will instruct doxygen to hide any special comment blocks from generated source code fragments. Normal C and C++ comments will always remain visible.", 3 );
                append( sb, "", 0 );

                append( sb, "stripFromIncPath", 2 );
                append( sb, "The STRIP_FROM_INC_PATH tag can be used to strip a user-defined part of the path mentioned in the documentation of a class, which tells the reader which header file to include in order to use a class. If left blank only the name of the header file containing the class definition is used. Otherwise one should specify the include paths that are normally passed to the compiler using the -I flag.", 3 );
                append( sb, "", 0 );

                append( sb, "stripFromPath", 2 );
                append( sb, "If the FULL_PATH_NAMES tag is set to YES then the STRIP_FROM_PATH tag can be used to strip a user-defined part of the path. Stripping is only done if one of the specified strings matches the left-hand part of the path. The tag can be used to show relative paths in the file list. If left blank the directory from which doxygen is run is used as the path to strip.", 3 );
                append( sb, "", 0 );

                append( sb, "subgrouping (Default: true)", 2 );
                append( sb, "Set the SUBGROUPING tag to YES (the default) to allow class member groups of the same type (for instance a group of public functions) to be put as a subgroup of that type (e.g. under the Public Functions section). Set it to NO to prevent subgrouping. Alternatively, this can be done per class using the \\nosubgrouping command.", 3 );
                append( sb, "", 0 );

                append( sb, "symbolCacheSize (Default: 0)", 2 );
                append( sb, "The SYMBOL_CACHE_SIZE determines the size of the internal cache use to determine which symbols to keep in memory and which to flush to disk. When the cache is full, less often used symbols will be written to disk. For small to medium size projects (<1000 input files) the default value is probably good enough. For larger projects a too small cache size can cause doxygen to be busy swapping symbols to and from disk most of the time causing a significant performance penality. If the system has enough physical memory increasing the cache will improve the performance by keeping more symbols in memory. Note that the value works on a logarithmic scale so increasing the size by one will rougly double the memory usage. The cache size is given by this formula: 2^(16+SYMBOL_CACHE_SIZE). The valid range is 0..9, the default is 0, corresponding to a cache size of 2^16 = 65536 symbols", 3 );
                append( sb, "", 0 );

                append( sb, "tabSize (Default: 8)", 2 );
                append( sb, "The TAB_SIZE tag can be used to set the number of spaces in a tab. Doxygen uses this value to replace tabs by spaces in code fragments.", 3 );
                append( sb, "", 0 );

                append( sb, "tagfiles", 2 );
                append( sb, "The TAGFILES option can be used to specify one or more tagfiles. Optionally an initial location of the external documentation can be added for each tagfile. The format of a tag file without this location is as follows: TAGFILES = file1 file2 ... Adding location for the tag files is done as follows: TAGFILES = file1=loc1 \'file2 = loc2\' ... where \'loc1\' and \'loc2\' can be relative or absolute paths or URLs. If a location is present for each tag, the installdox tool does not have to be run to correct the links. Note that each tag file must have a unique name (where the name does NOT include the path) If a tag file is not located in the directory in which doxygen is run, you must also specify the path to the tagfile here.", 3 );
                append( sb, "", 0 );

                append( sb, "templateRelations (Default: false)", 2 );
                append( sb, "If set to YES, the inheritance and collaboration graphs will show the relations between templates and their instances.", 3 );
                append( sb, "", 0 );

                append( sb, "tocExpand (Default: false)", 2 );
                append( sb, "The TOC_EXPAND flag can be set to YES to add extra items for group members to the contents of the HTML help documentation and to the tree view.", 3 );
                append( sb, "", 0 );

                append( sb, "treeviewWidth (Default: 250)", 2 );
                append( sb, "If the treeview is enabled (see GENERATE_TREEVIEW) then this tag can be used to set the initial width (in pixels) of the frame in which the tree is shown.", 3 );
                append( sb, "", 0 );

                append( sb, "typedefHidesStruct (Default: false)", 2 );
                append( sb, "When TYPEDEF_HIDES_STRUCT is enabled, a typedef of a struct, union, or enum is documented as struct, union, or enum with the name of the typedef. So typedef struct TypeS {} TypeT, will appear in the documentation as a struct with name TypeT. When disabled the typedef will appear as a member of a file, namespace, or class. And the struct will be named TypeS. This can typically be useful for C code in case the coding convention dictates that all compound types are typedef\'ed and only the typedef is referenced, never the tag name.", 3 );
                append( sb, "", 0 );

                append( sb, "umlLook (Default: false)", 2 );
                append( sb, "If the UML_LOOK tag is set to YES doxygen will generate inheritance and collaboration diagrams in a style similar to the OMG\'s Unified Modeling Language.", 3 );
                append( sb, "", 0 );

                append( sb, "useHtags (Default: false)", 2 );
                append( sb, "If the USE_HTAGS tag is set to YES then the references to source code will point to the HTML generated by the htags(1) tool instead of doxygen built-in source browser. The htags tool is part of GNU\'s global source tagging system (see http://www.gnu.org/software/global/global.html). You will need version 4.8.6 or higher.", 3 );
                append( sb, "", 0 );

                append( sb, "usePdflatex (Default: true)", 2 );
                append( sb, "If the USE_PDFLATEX tag is set to YES, pdflatex will be used instead of plain latex in the generated Makefile. Set this option to YES to get a higher quality PDF documentation.", 3 );
                append( sb, "", 0 );

                append( sb, "verbatimHeaders (Default: true)", 2 );
                append( sb, "If the VERBATIM_HEADERS tag is set to YES (the default) then Doxygen will generate a verbatim copy of the header file for each class for which an include is specified. Set to NO to disable this.", 3 );
                append( sb, "", 0 );

                append( sb, "warnFormat", 2 );
                append( sb, "The WARN_FORMAT tag determines the format of the warning messages that doxygen can produce. The string should contain the $file, $line, and $text tags, which will be replaced by the file and line number from which the warning originated and the warning text. Optionally the format may contain $version, which will be replaced by the version of the file (if it could be obtained via FILE_VERSION_FILTER)", 3 );
                append( sb, "", 0 );

                append( sb, "warnIfDocError (Default: true)", 2 );
                append( sb, "If WARN_IF_DOC_ERROR is set to YES, doxygen will generate warnings for potential errors in the documentation, such as not documenting some parameters in a documented function, or documenting parameters that don\'t exist or using markup commands wrongly.", 3 );
                append( sb, "", 0 );

                append( sb, "warnIfUndocumented (Default: true)", 2 );
                append( sb, "If WARN_IF_UNDOCUMENTED is set to YES, then doxygen will generate warnings for undocumented members. If EXTRACT_ALL is set to YES then this flag will automatically be disabled.", 3 );
                append( sb, "", 0 );

                append( sb, "warnings (Default: true)", 2 );
                append( sb, "The WARNINGS tag can be used to turn on/off the warning messages that are generated by doxygen. Possible values are YES and NO. If left blank NO is used.", 3 );
                append( sb, "", 0 );

                append( sb, "warnLogfile", 2 );
                append( sb, "The WARN_LOGFILE tag can be used to specify a file to which warning and error messages should be written. If left blank the output is written to stderr.", 3 );
                append( sb, "", 0 );

                append( sb, "warnNoParamdoc (Default: true)", 2 );
                append( sb, "This WARN_NO_PARAMDOC option can be abled to get warnings for functions that are documented, but have no documentation for their parameters or return value. If set to NO (the default) doxygen will only warn about wrong or incomplete parameter documentation, but not about the absence of documentation.", 3 );
                append( sb, "", 0 );

                append( sb, "xmlDtd", 2 );
                append( sb, "The XML_DTD tag can be used to specify an XML DTD, which can be used by a validating XML parser to check the syntax of the XML files.", 3 );
                append( sb, "", 0 );

                append( sb, "xmlOutput (Default: xml)", 2 );
                append( sb, "The XML_OUTPUT tag is used to specify where the XML pages will be put. If a relative path is entered the value of OUTPUT_DIRECTORY will be put in front of it. If left blank `xml\' will be used as the default path.", 3 );
                append( sb, "", 0 );

                append( sb, "xmlProgramlisting (Default: true)", 2 );
                append( sb, "If the XML_PROGRAMLISTING tag is set to YES Doxygen will dump the program listings (including syntax highlighting and cross-referencing information) to the XML output. Note that enabling this will significantly increase the size of the XML output.", 3 );
                append( sb, "", 0 );

                append( sb, "xmlSchema", 2 );
                append( sb, "The XML_SCHEMA tag can be used to specify an XML schema, which can be used by a validating XML parser to check the syntax of the XML files.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
