/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.plugins.dmg;

import com.soebes.maven.plugins.dmg.AbstractDoxygenMojo;
import java.io.File;
import java.util.Locale;
import org.apache.maven.doxia.module.xhtml.decoration.render.RenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;

public class DoxygenReport
extends AbstractDoxygenMojo
implements MavenReport {
    private File reportOutputDirectory;
    private String destDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping doxgenc generation");
            return;
        }
        try {
            RenderingContext context = new RenderingContext(this.getOutputDirectory(), this.getOutputName() + ".html");
            SiteRendererSink sink = new SiteRendererSink(context);
            Locale locale = Locale.getDefault();
            this.generate((Sink)sink, locale);
        }
        catch (MavenReportException e) {
            this.getLog().error((CharSequence)("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation:" + e.getMessage()), (Throwable)e);
        }
        catch (RuntimeException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.setOutputDirectory(this.getReportOutputDirectory());
        this.executeReport(locale);
    }

    public File getReportOutputDirectory() {
        if (this.reportOutputDirectory == null) {
            return this.reportOutputDirectory;
        }
        return this.reportOutputDirectory;
    }

    protected MavenProject getProject() {
        return this.getProject();
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public String getOutputName() {
        return "doxygen/index";
    }

    public boolean isExternalReport() {
        return true;
    }

    public String getDescription(Locale locale) {
        return "Doxygen Report";
    }

    public String getName(Locale locale) {
        return "Doxygen";
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public boolean canGenerateReport() {
        return true;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.reportOutputDirectory = this.getOutputDirectory();
    }
}

