/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremill.session;

import com.softwaremill.session.Crypto$;
import com.softwaremill.session.DecodeResult;
import com.softwaremill.session.JwtSessionEncoder$;
import com.softwaremill.session.SessionConfig;
import com.softwaremill.session.SessionEncoder;
import com.softwaremill.session.SessionSerializer;
import com.softwaremill.session.SessionUtil$;
import java.io.Serializable;
import java.util.Base64;
import java.util.UUID;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\t\u0013\u0001eA\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006Y!\r\u0005\t\r\u0002\u0011\t\u0011)A\u0006\u000f\")1\n\u0001C\u0001\u0019\")\u0011\u000b\u0001C!%\")q\r\u0001C\u0001Q\")A\u000e\u0001C![\")!\u0010\u0001C\tw\")Q\u0010\u0001C\t}\"9\u0011Q\u0001\u0001\u0005\u0012\u0005\u001d\u0001BB)\u0001\t#\ti\u0002\u0003\u0004m\u0001\u0011E\u00111\u0005\u0005\b\u0003S\u0001A\u0011CA\u0016\u000f%\tyCEA\u0001\u0012\u0003\t\tD\u0002\u0005\u0012%\u0005\u0005\t\u0012AA\u001a\u0011\u0019Ye\u0002\"\u0001\u00026!I\u0011q\u0007\b\u0012\u0002\u0013\u0005\u0011\u0011\b\u0002\u0012\u0015^$8+Z:tS>tWI\\2pI\u0016\u0014(BA\n\u0015\u0003\u001d\u0019Xm]:j_:T!!\u0006\f\u0002\u0019M|g\r^<be\u0016l\u0017\u000e\u001c7\u000b\u0003]\t1aY8n\u0007\u0001)\"AG\u0014\u0014\u0007\u0001Y\u0012\u0005\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u0004E\r*S\"\u0001\n\n\u0005\u0011\u0012\"AD*fgNLwN\\#oG>$WM\u001d\t\u0003M\u001db\u0001\u0001B\u0003)\u0001\t\u0007\u0011FA\u0001U#\tQS\u0006\u0005\u0002\u001dW%\u0011A&\b\u0002\b\u001d>$\b.\u001b8h!\tab&\u0003\u00020;\t\u0019\u0011I\\=\u0002\u0015M,'/[1mSj,'\u000f\u0005\u0003#e\u0015\"\u0014BA\u001a\u0013\u0005E\u0019Vm]:j_:\u001cVM]5bY&TXM\u001d\t\u0003k\rs!A\u000e!\u000f\u0005]jdB\u0001\u001d<\u001b\u0005I$B\u0001\u001e\u0019\u0003\u0019a$o\\8u}%\tA(A\u0002pe\u001eL!AP \u0002\r)\u001cxN\u001c\u001bt\u0015\u0005a\u0014BA!C\u0003\u001d\u0001\u0018mY6bO\u0016T!AP \n\u0005\u0011+%A\u0002&WC2,XM\u0003\u0002B\u0005\u00069am\u001c:nCR\u001c\bC\u0001%J\u001b\u0005\u0011\u0015B\u0001&C\u0005\u001d1uN]7biN\fa\u0001P5oSRtD#A'\u0015\u00079{\u0005\u000bE\u0002#\u0001\u0015BQ\u0001M\u0002A\u0004EBqAR\u0002\u0011\u0002\u0003\u000fq)\u0001\u0004f]\u000e|G-\u001a\u000b\u0005'nk&\r\u0005\u0002U1:\u0011QK\u0016\t\u0003quI!aV\u000f\u0002\rA\u0013X\rZ3g\u0013\tI&L\u0001\u0004TiJLgn\u001a\u0006\u0003/vAQ\u0001\u0018\u0003A\u0002\u0015\n\u0011\u0001\u001e\u0005\u0006=\u0012\u0001\raX\u0001\n]><X*\u001b7mSN\u0004\"\u0001\b1\n\u0005\u0005l\"\u0001\u0002'p]\u001eDQa\u0019\u0003A\u0002\u0011\faaY8oM&<\u0007C\u0001\u0012f\u0013\t1'CA\u0007TKN\u001c\u0018n\u001c8D_:4\u0017nZ\u0001\rK:\u001cw\u000eZ3Wa}+tL\r\u000b\u0005'&T7\u000eC\u0003]\u000b\u0001\u0007Q\u0005C\u0003_\u000b\u0001\u0007q\fC\u0003d\u000b\u0001\u0007A-\u0001\u0004eK\u000e|G-\u001a\u000b\u0004]^L\bcA8si6\t\u0001O\u0003\u0002r;\u0005!Q\u000f^5m\u0013\t\u0019\bOA\u0002Uef\u00042AI;&\u0013\t1(C\u0001\u0007EK\u000e|G-\u001a*fgVdG\u000fC\u0003y\r\u0001\u00071+A\u0001t\u0011\u0015\u0019g\u00011\u0001e\u00031\u0019'/Z1uK\"+\u0017\rZ3s)\t!D\u0010C\u0003d\u000f\u0001\u0007A-A\u0007de\u0016\fG/\u001a)bs2|\u0017\r\u001a\u000b\u0007i}\f\t!a\u0001\t\u000bqC\u0001\u0019A\u0013\t\u000byC\u0001\u0019A0\t\u000b\rD\u0001\u0019\u00013\u0002\u001d\u0015DHO]1diB\u000b\u0017\u0010\\8bIR1\u0011\u0011BA\f\u00037\u0001Ba\u001c:\u0002\fA1A$!\u0004&\u0003#I1!a\u0004\u001e\u0005\u0019!V\u000f\u001d7feA!A$a\u0005`\u0013\r\t)\"\b\u0002\u0007\u001fB$\u0018n\u001c8\t\r\u0005e\u0011\u00021\u00015\u0003\u0005\u0001\b\"B2\n\u0001\u0004!GcA*\u0002 !1\u0011\u0011\u0005\u0006A\u0002Q\n!A\u001b<\u0015\t\u0005\u0015\u0012q\u0005\t\u0004_J$\u0004\"\u0002=\f\u0001\u0004\u0019\u0016\u0001\u00043fG>$WM\u0016\u0019`k}\u0013D\u0003BA\u0013\u0003[AQ\u0001\u001f\u0007A\u0002M\u000b\u0011CS<u'\u0016\u001c8/[8o\u000b:\u001cw\u000eZ3s!\t\u0011cb\u0005\u0002\u000f7Q\u0011\u0011\u0011G\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\t\u0005m\u0012\u0011\u000b\u000b\u0003\u0003{Q3aRA W\t\t\t\u0005\u0005\u0003\u0002D\u00055SBAA#\u0015\u0011\t9%!\u0013\u0002\u0013Ut7\r[3dW\u0016$'bAA&;\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0013Q\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G!\u0002\u0015\u0011\u0005\u0004I\u0003")
public class JwtSessionEncoder<T>
implements SessionEncoder<T> {
    private final SessionSerializer<T, JsonAST.JValue> serializer;
    private final Formats formats;

    public static <T> Formats $lessinit$greater$default$2() {
        return JwtSessionEncoder$.MODULE$.$lessinit$greater$default$2();
    }

    public String encode(T t, long nowMillis, SessionConfig config) {
        String h = this.encode(this.createHeader(config));
        String p = this.encode(this.createPayload(t, nowMillis, config));
        String base = new StringBuilder(1).append(h).append(".").append(p).toString();
        String signature = config.jws().alg().sign(base);
        return new StringBuilder(1).append(base).append(".").append(signature).toString();
    }

    public String encodeV0_5_2(T t, long nowMillis, SessionConfig config) {
        String h = this.encode(this.createHeader(config));
        String p = this.encode(this.createPayload(t, nowMillis, config));
        String base = new StringBuilder(1).append(h).append(".").append(p).toString();
        String signature = Crypto$.MODULE$.sign_HmacSHA256_base64_v0_5_2(base, config.serverSecret());
        return new StringBuilder(1).append(base).append(".").append(signature).toString();
    }

    public Try<DecodeResult<T>> decode(String s, SessionConfig config) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2;
            String sCleaned = s.startsWith("Bearer") ? s.substring(7).trim() : s;
            List list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sCleaned.split("\\."))).toList();
            Some some = List$.MODULE$.unapplySeq((Seq)list);
            if (some.isEmpty() || some.get() == null || ((LinearSeqOptimized)some.get()).lengthCompare(3) != 0) {
                throw new MatchError((Object)list);
            }
            String h = (String)((LinearSeqOptimized)some.get()).apply(0);
            String p = (String)((LinearSeqOptimized)some.get()).apply(1);
            String signature = (String)((LinearSeqOptimized)some.get()).apply(2);
            Tuple3 tuple3 = new Tuple3((Object)h, (Object)p, (Object)signature);
            Tuple3 tuple32 = tuple3;
            String h2 = (String)tuple32._1();
            String p2 = (String)tuple32._2();
            String signature2 = (String)tuple32._3();
            Try<JsonAST.JValue> decodedValue = this.decode(p2);
            Tuple2 tuple22 = tuple2 = decodedValue.isFailure() && config.tokenMigrationV0_5_3Enabled() ? new Tuple2(this.decodeV0_5_2(p2), (Object)BoxesRunTime.boxToBoolean((boolean)true)) : new Tuple2(decodedValue, (Object)BoxesRunTime.boxToBoolean((boolean)false));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Try decodedValue2 = (Try)tuple2._1();
            boolean decodedLegacy = tuple2._2$mcZ$sp();
            Tuple2 tuple23 = new Tuple2((Object)decodedValue2, (Object)BoxesRunTime.boxToBoolean((boolean)decodedLegacy));
            Tuple2 tuple24 = tuple23;
            Try decodedValue3 = (Try)tuple24._1();
            boolean decodedLegacy2 = tuple24._2$mcZ$sp();
            return decodedValue3.flatMap((Function1 & Serializable & scala.Serializable)jv -> this.extractPayload((JsonAST.JValue)jv, config).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)JwtSessionEncoder.$anonfun$decode$3(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$3 -> {
                DecodeResult decodeResult;
                Tuple2 tuple2 = x$3;
                if (tuple2 != null) {
                    Object t = tuple2._1();
                    Option exp = (Option)tuple2._2();
                    boolean signatureMatches = SessionUtil$.MODULE$.constantTimeEquals(signature2, config.jws().alg().sign(new StringBuilder(1).append(h2).append(".").append(p2).toString()));
                    if (!signatureMatches && config.tokenMigrationV0_5_3Enabled()) {
                        boolean signatureMatchesLegacy = SessionUtil$.MODULE$.constantTimeEquals(signature2, Crypto$.MODULE$.sign_HmacSHA256_base64_v0_5_2(new StringBuilder(1).append(h2).append(".").append(p2).toString(), config.serverSecret()));
                        boolean isLegacy = signatureMatchesLegacy || decodedLegacy2;
                        decodeResult = new DecodeResult(t, exp, signatureMatchesLegacy, isLegacy);
                    } else {
                        decodeResult = new DecodeResult(t, exp, signatureMatches, decodedLegacy2);
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                DecodeResult decodeResult2 = decodeResult;
                return decodeResult2;
            }));
        }).flatten(Predef$.MODULE$.$conforms());
    }

    public JsonAST.JValue createHeader(SessionConfig config) {
        return package$.MODULE$.JObject().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"alg"), (Object)package$.MODULE$.JString().apply(config.jws().alg().value())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typ"), (Object)package$.MODULE$.JString().apply("JWT"))}));
    }

    public JsonAST.JValue createPayload(T t, long nowMillis, SessionConfig config) {
        JsonAST.JValue jValue;
        List iss = JwtSessionEncoder.stringClaim$1("iss", config.jwt().issuer()).toList();
        List sub = JwtSessionEncoder.stringClaim$1("sub", config.jwt().subject()).toList();
        List aud = JwtSessionEncoder.stringClaim$1("aud", config.jwt().audience()).toList();
        List exp = JwtSessionEncoder.numericDateClaimFromTimeout$1("exp", config.jwt().expirationTimeout(), nowMillis).toList();
        List nbf = JwtSessionEncoder.numericDateClaimFromTimeout$1("nbf", config.jwt().notBeforeOffset(), nowMillis).toList();
        Nil$ iat = config.jwt().includeIssuedAt() ? JwtSessionEncoder.numericDateClaimFromTimeout$1("iat", (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), nowMillis).toList() : Nil$.MODULE$;
        Nil$ jti = config.jwt().includeRandomJwtId() ? JwtSessionEncoder.stringClaim$1("jti", (Option)new Some((Object)new StringBuilder(0).append((String)config.jwt().issuer().map((Function1 & Serializable & scala.Serializable)x$5 -> new StringBuilder(1).append((String)x$5).append("-").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(UUID.randomUUID().toString()).toString())).toList() : Nil$.MODULE$;
        List registeredClaims = (List)((List)((List)((List)((List)((List)iss.$plus$plus((GenTraversableOnce)sub, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)aud, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)exp, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)nbf, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)iat, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)jti, List$.MODULE$.canBuildFrom());
        JsonAST.JValue serialized = (JsonAST.JValue)this.serializer.serialize(t);
        if (config.sessionEncryptData()) {
            JsonAST.JObject serializedWrapped = package$.MODULE$.JObject().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Object)serialized)}));
            jValue = package$.MODULE$.JString().apply(Crypto$.MODULE$.encrypt_AES(JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)serializedWrapped, this.formats)), config.serverSecret()));
        } else {
            jValue = serialized;
        }
        JsonAST.JValue data = jValue;
        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"data"), (Object)data);
        return package$.MODULE$.JObject().apply(registeredClaims.$colon$colon((Object)tuple2));
    }

    public Try<Tuple2<T, Option<Object>>> extractPayload(JsonAST.JValue p, SessionConfig config) {
        JsonAST.JValue jValue;
        None$ none$;
        JsonAST.JValue jValue2 = package$.MODULE$.jvalue2monadic(p).$bslash$bslash("exp");
        if (jValue2 instanceof JsonAST.JInt) {
            JsonAST.JInt jInt = (JsonAST.JInt)jValue2;
            BigInt e = jInt.num();
            none$ = new Some((Object)BoxesRunTime.boxToLong((long)(e.longValue() * 1000L)));
        } else {
            none$ = None$.MODULE$;
        }
        None$ exp = none$;
        JsonAST.JValue rawData = package$.MODULE$.jvalue2monadic(p).$bslash$bslash("data");
        if (config.sessionEncryptData()) {
            JsonAST.JValue jValue3;
            JsonAST.JValue jValue4 = rawData;
            if (jValue4 instanceof JsonAST.JString) {
                JsonAST.JString jString = (JsonAST.JString)jValue4;
                String s = jString.s();
                jValue3 = package$.MODULE$.jvalue2monadic(JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(Crypto$.MODULE$.decrypt_AES(s, config.serverSecret())), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).$bslash$bslash("v");
            } else {
                jValue3 = rawData;
            }
            jValue = jValue3;
        } else {
            jValue = rawData;
        }
        JsonAST.JValue data = jValue;
        Try t = this.serializer.deserialize((Object)data);
        return t.map(arg_0 -> JwtSessionEncoder.$anonfun$extractPayload$1((Option)exp, arg_0));
    }

    public String encode(JsonAST.JValue jv) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(jv, this.formats)).getBytes("utf-8"));
    }

    public Try<JsonAST.JValue> decode(String s) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(new String(Base64.getUrlDecoder().decode(s), "utf-8")), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()));
    }

    public Try<JsonAST.JValue> decodeV0_5_2(String s) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(new String(SessionUtil$.MODULE$.parseBase64_v0_5_2(s), "utf-8")), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()));
    }

    public static final /* synthetic */ boolean $anonfun$decode$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private static final Option numericDateClaimFromTimeout$1(String key, Option numericDate, long nowMillis$1) {
        return numericDate.map((Function1 & Serializable & scala.Serializable)timeout -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)package$.MODULE$.JInt().apply(BigInt$.MODULE$.long2bigInt(nowMillis$1 / 1000L + BoxesRunTime.unboxToLong((Object)timeout)))));
    }

    private static final Option stringClaim$1(String key, Option value) {
        return value.map((Function1 & Serializable & scala.Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)package$.MODULE$.JString().apply(x$4)));
    }

    public static final /* synthetic */ Tuple2 $anonfun$extractPayload$1(Option exp$1, Object x$7) {
        return new Tuple2(x$7, (Object)exp$1);
    }

    public JwtSessionEncoder(SessionSerializer<T, JsonAST.JValue> serializer, Formats formats) {
        this.serializer = serializer;
        this.formats = formats;
    }
}

