/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.solcache;

import com.solacesystems.jcsmp.CacheLiveDataAction;
import com.solacesystems.jcsmp.CacheRequestListener;
import com.solacesystems.jcsmp.CacheRequestResult;
import com.solacesystems.jcsmp.CacheSession;
import com.solacesystems.jcsmp.CacheSessionProperties;
import com.solacesystems.jcsmp.ClosedFacilityException;
import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageConsumer;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageProducer;
import com.solacesystems.jcsmp.impl.solcache.CacheClusterRequest;
import com.solacesystems.jcsmp.impl.solcache.CacheRequest;
import com.solacesystems.jcsmp.impl.solcache.CacheRequestProperties;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheSessionImpl
implements CacheSession {
    private JCSMPBasicSession mSession = null;
    private CacheSessionProperties mProperties;
    private volatile boolean mClosed;
    private HashMap<Long, CacheRequest> mOutstandingRequests;
    private Object mRequestLock;

    public CacheSessionImpl(CacheSessionProperties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("CacheProperties cannot be null");
        }
        this.mProperties = (CacheSessionProperties)properties.clone();
        this.mClosed = false;
        this.mOutstandingRequests = new HashMap();
        this.mRequestLock = new Object();
    }

    @Override
    public JCSMPSession getJCSMPSession() {
        return this.mSession;
    }

    public void setJCSMPSession(JCSMPBasicSession session) {
        this.mSession = session;
    }

    @Override
    public CacheSessionProperties getProperties() {
        return this.mProperties;
    }

    public Object getOutstandingRequestsLock() {
        return this.mRequestLock;
    }

    public HashMap<Long, CacheRequest> getOutstandingRequests() {
        return this.mOutstandingRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheRequestResult sendCacheRequest(Long requestId, Topic topic, boolean subscribe, CacheLiveDataAction liveDataAction) throws JCSMPException {
        CacheRequest cacheRequest;
        if (this.mClosed) {
            throw new ClosedFacilityException("Cannot perform operation on a closed cache session");
        }
        if (this.mSession.isClosed()) {
            throw new ClosedFacilityException("Cannot perform operation on closed session");
        }
        JCSMPXMLMessageProducer producer = this.mSession.getProducer();
        if (producer == null) {
            throw new InvalidOperationException("No producer to perform operation");
        }
        JCSMPXMLMessageConsumer consumer = this.mSession.getConsumer();
        if (consumer == null) {
            throw new InvalidOperationException("No consumer to perform operation");
        }
        try {
            CacheClusterRequest clusterRequest;
            if (consumer.getFlowHandle() != null && !consumer.getFlowHandle().isOpened()) {
                consumer.getFlowHandle().throwClosedException("Cannot perform operation on closed consumer");
            }
            Object object = this.mRequestLock;
            synchronized (object) {
                CacheRequestProperties requestProps = new CacheRequestProperties(this, producer, consumer, requestId, topic, subscribe, liveDataAction, this.mSession.getContext().getCacheService());
                cacheRequest = new CacheRequest(requestProps);
                this.addCacheRequest(cacheRequest);
                clusterRequest = cacheRequest.prepareSend();
            }
            if (subscribe) {
                try {
                    this.mSession.addSubscription(topic);
                }
                catch (JCSMPException e) {
                    cacheRequest.cleanupRequest();
                    throw e;
                }
            }
            this.mSession.getProducer().mPubLock.lock();
            cacheRequest.send(clusterRequest);
        }
        finally {
            if (this.mSession.getProducer().mPubLock.isHeldByCurrentThread()) {
                this.mSession.getProducer().mPubLock.unlock();
            }
        }
        CacheRequestResult result = cacheRequest.waitForResponse();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendCacheRequest(Long requestId, Topic topic, boolean subscribe, CacheLiveDataAction liveDataAction, CacheRequestListener listener) throws JCSMPException {
        if (this.mClosed) {
            throw new ClosedFacilityException("Cannot perform operation on a closed cache session");
        }
        if (this.mSession.isClosed()) {
            throw new ClosedFacilityException("Cannot perform operation on closed session");
        }
        JCSMPXMLMessageProducer producer = this.mSession.getProducer();
        if (producer == null) {
            throw new InvalidOperationException("No producer to perform operation");
        }
        JCSMPXMLMessageConsumer consumer = this.mSession.getConsumer();
        if (consumer == null) {
            throw new InvalidOperationException("No consumer to perform operation");
        }
        try {
            CacheClusterRequest clusterRequest;
            CacheRequest cacheRequest;
            if (consumer.getFlowHandle() != null && !consumer.getFlowHandle().isOpened()) {
                consumer.getFlowHandle().throwClosedException("Cannot perform operation on closed consumer");
            }
            Object object = this.mRequestLock;
            synchronized (object) {
                CacheRequestProperties requestProps = new CacheRequestProperties(this, producer, consumer, requestId, topic, subscribe, liveDataAction, this.mSession.getContext().getCacheService(), listener);
                cacheRequest = new CacheRequest(requestProps);
                this.addCacheRequest(cacheRequest);
                clusterRequest = cacheRequest.prepareSend();
            }
            if (subscribe) {
                try {
                    this.mSession.addSubscription(topic);
                }
                catch (JCSMPException e) {
                    cacheRequest.cleanupRequest();
                    throw e;
                }
            }
            this.mSession.getProducer().mPubLock.lock();
            cacheRequest.send(clusterRequest);
        }
        finally {
            if (this.mSession.getProducer().mPubLock.isHeldByCurrentThread()) {
                this.mSession.getProducer().mPubLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheRequestResult sendCacheRequest(Long requestId, Topic topic, long min, long max, boolean subscribe, CacheLiveDataAction liveDataAction) throws JCSMPException {
        CacheRequest cacheRequest;
        if (this.mClosed) {
            throw new ClosedFacilityException("Cannot perform operation on a closed cache session");
        }
        if (this.mSession.isClosed()) {
            throw new ClosedFacilityException("Cannot perform operation on closed session");
        }
        JCSMPXMLMessageProducer producer = this.mSession.getProducer();
        if (producer == null) {
            throw new InvalidOperationException("No producer to perform operation");
        }
        JCSMPXMLMessageConsumer consumer = this.mSession.getConsumer();
        if (consumer == null) {
            throw new InvalidOperationException("No consumer to perform operation");
        }
        try {
            CacheClusterRequest clusterRequest;
            if (consumer.getFlowHandle() != null && !consumer.getFlowHandle().isOpened()) {
                consumer.getFlowHandle().throwClosedException("Cannot perform operation on closed consumer");
            }
            if (subscribe) {
                throw new IllegalArgumentException("only a subscribe value of false is allowed");
            }
            if (liveDataAction != CacheLiveDataAction.FLOW_THRU) {
                throw new IllegalArgumentException("only a live data action of FLOW_THRU is allowed");
            }
            Object object = this.mRequestLock;
            synchronized (object) {
                CacheRequestProperties requestProps = new CacheRequestProperties(this, producer, consumer, requestId, topic, subscribe, liveDataAction, this.mSession.getContext().getCacheService(), min, max);
                cacheRequest = new CacheRequest(requestProps);
                this.addCacheRequest(cacheRequest);
                clusterRequest = cacheRequest.prepareSend();
            }
            this.mSession.getProducer().mPubLock.lock();
            cacheRequest.send(clusterRequest);
        }
        finally {
            if (this.mSession.getProducer().mPubLock.isHeldByCurrentThread()) {
                this.mSession.getProducer().mPubLock.unlock();
            }
        }
        CacheRequestResult result = cacheRequest.waitForResponse();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendCacheRequest(Long requestId, Topic topic, long min, long max, boolean subscribe, CacheLiveDataAction liveDataAction, CacheRequestListener listener) throws JCSMPException {
        if (this.mClosed) {
            throw new ClosedFacilityException("Cannot perform operation on a closed cache session");
        }
        if (this.mSession.isClosed()) {
            throw new ClosedFacilityException("Cannot perform operation on closed session");
        }
        JCSMPXMLMessageProducer producer = this.mSession.getProducer();
        if (producer == null) {
            throw new InvalidOperationException("No producer to perform operation");
        }
        JCSMPXMLMessageConsumer consumer = this.mSession.getConsumer();
        if (consumer == null) {
            throw new InvalidOperationException("No consumer to perform operation");
        }
        try {
            CacheClusterRequest clusterRequest;
            CacheRequest cacheRequest;
            if (consumer.getFlowHandle() != null && !consumer.getFlowHandle().isOpened()) {
                consumer.getFlowHandle().throwClosedException("Cannot perform operation on closed consumer");
            }
            if (subscribe) {
                throw new IllegalArgumentException("only a subscribe value of false is allowed");
            }
            if (liveDataAction != CacheLiveDataAction.FLOW_THRU) {
                throw new IllegalArgumentException("only a live data action of FLOW_THRU is allowed");
            }
            Object object = this.mRequestLock;
            synchronized (object) {
                CacheRequestProperties requestProps = new CacheRequestProperties(this, producer, consumer, requestId, topic, subscribe, liveDataAction, this.mSession.getContext().getCacheService(), listener, min, max);
                cacheRequest = new CacheRequest(requestProps);
                this.addCacheRequest(cacheRequest);
                clusterRequest = cacheRequest.prepareSend();
            }
            this.mSession.getProducer().mPubLock.lock();
            cacheRequest.send(clusterRequest);
        }
        finally {
            if (this.mSession.getProducer().mPubLock.isHeldByCurrentThread()) {
                this.mSession.getProducer().mPubLock.unlock();
            }
        }
    }

    public void addCacheRequest(CacheRequest cacheRequest) {
        this.mOutstandingRequests.put(cacheRequest.getId(), cacheRequest);
    }

    public void removeCacheRequest(CacheRequest cacheRequest) {
        this.mOutstandingRequests.remove(cacheRequest.getId());
    }

    public String toString() {
        return this.mProperties.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mRequestLock;
        synchronized (object) {
            if (!this.mClosed) {
                this.cancelCacheRequests();
                this.mClosed = true;
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelCacheRequests() {
        Object object = this.mRequestLock;
        synchronized (object) {
            if (!this.mClosed) {
                ArrayList<CacheRequest> requests = new ArrayList<CacheRequest>(this.mOutstandingRequests.values());
                for (int i = 0; i < requests.size(); ++i) {
                    requests.get(i).cancel();
                }
            }
        }
    }
}

