/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.impl;

import com.solacesystems.jms.impl.ConnectionConsumerTransactionStrategy;
import com.solacesystems.jms.impl.JMSState;
import com.solacesystems.jms.message.SolMessage;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionConsumerFakeTransactionStrategy
extends ConnectionConsumerTransactionStrategy {
    private static final Log log = LogFactory.getLog(ConnectionConsumerFakeTransactionStrategy.class);
    private int mUnacked = 0;
    private final Lock mAcklock = new ReentrantLock();
    private final Condition mHasUnacked = this.mAcklock.newCondition();

    public ConnectionConsumerFakeTransactionStrategy(ConnectionConsumerTransactionStrategy.InitProperties iprop) {
        super(iprop);
        this.mTxState = ConnectionConsumerTransactionStrategy.TransactionState.ACTIVE;
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConnectionConsumerFakeTransactionStrategy created.");
        }
    }

    @Override
    public void reset() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering reset().");
        }
        this.mAcklock.lock();
        this.mUnacked = 0;
        this.mHasUnacked.signal();
        this.mAcklock.unlock();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving reset().");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Collection<Message> msgs) {
        this.mAcklock.lock();
        try {
            this.mUnacked += msgs.size();
            Object var3_2 = null;
            this.mAcklock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mAcklock.unlock();
            throw throwable;
        }
    }

    @Override
    public void onCommit(Collection<Message> msgs) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering onCommit()");
        }
        int sz = msgs.size();
        for (Message m : msgs) {
            ((SolMessage)m).getMessage().ackMessage();
        }
        this.mAcklock.lock();
        this.mUnacked -= sz;
        this.mHasUnacked.signal();
        this.mAcklock.unlock();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving onCommit()");
        }
    }

    @Override
    public void onRollback(Collection<Message> msgs) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering onRollback()");
        }
        int sz = msgs.size();
        this.mAcklock.lock();
        this.mTxState = ConnectionConsumerTransactionStrategy.TransactionState.ROLLINGBACK;
        this.mUnacked -= sz;
        this.mHasUnacked.signal();
        this.mAcklock.unlock();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving onRollback()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryWaitForUnacked(int millis) throws InterruptedException {
        boolean bl;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entering tryWaitForUnacked(), timeout (ms) : " + millis));
        }
        this.mAcklock.lock();
        assert (this.mTxState == ConnectionConsumerTransactionStrategy.TransactionState.ROLLINGBACK);
        try {
            while (this.mUnacked != 0) {
                this.mHasUnacked.await(millis, TimeUnit.MILLISECONDS);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Leaving tryWaitForUnacked()");
            }
            bl = this.mUnacked == 0;
            Object var4_3 = null;
            this.mAcklock.unlock();
        }
        catch (Throwable throwable) {
            block7: {
                Object var4_4 = null;
                this.mAcklock.unlock();
                if (!log.isDebugEnabled()) break block7;
                log.debug((Object)"Leaving tryWaitForUnacked()");
            }
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving tryWaitForUnacked()");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void afterPollLoop() throws JMSException {
        super.afterPollLoop();
        switch (1.$SwitchMap$com$solacesystems$jms$impl$ConnectionConsumerTransactionStrategy$TransactionState[this.mTxState.ordinal()]) {
            case 1: {
                if (ConnectionConsumerFakeTransactionStrategy.log.isDebugEnabled()) {
                    ConnectionConsumerFakeTransactionStrategy.log.debug((Object)"Processing rollback in afterPollLoop()");
                }
                try {
                    this.tryWaitForUnacked(5000);
                }
                catch (InterruptedException e) {
                    if (!ConnectionConsumerFakeTransactionStrategy.log.isInfoEnabled()) ** GOTO lbl13
                    ConnectionConsumerFakeTransactionStrategy.log.info((Object)"tryWaitForUnacked() timed out in afterPollLoop().");
                }
lbl13:
                // 3 sources

                if (ConnectionConsumerFakeTransactionStrategy.log.isDebugEnabled()) {
                    ConnectionConsumerFakeTransactionStrategy.log.debug((Object)"Starting to recreate the consumer in afterPollLoop().");
                }
                this.closeConsumer();
                this.createConsumer();
                this.reset();
                if (this.mConnection.getJMSState() == JMSState.Started) {
                    this.start();
                }
                if (ConnectionConsumerFakeTransactionStrategy.log.isDebugEnabled()) {
                    ConnectionConsumerFakeTransactionStrategy.log.debug((Object)"Consumer recreated in afterPollLoop().");
                }
                try {
                    this.mAcklock.lock();
                    this.checkClosed();
                    this.mTxState = ConnectionConsumerTransactionStrategy.TransactionState.ACTIVE;
                    var3_2 = null;
                    this.mAcklock.unlock();
                }
                catch (Throwable var2_4) {
                    var3_3 = null;
                    this.mAcklock.unlock();
                    throw var2_4;
                }
                if (!ConnectionConsumerFakeTransactionStrategy.log.isDebugEnabled()) break;
                ConnectionConsumerFakeTransactionStrategy.log.debug((Object)"Rollback in afterPollLoop() has been processed");
                break;
            }
        }
    }
}

