/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.impl;

import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jms.encoding.JMSDecoder;
import com.solacesystems.jms.impl.AckHandler;
import com.solacesystems.jms.impl.Validator;
import com.solacesystems.jms.message.SolMessage;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JCSMPMessageListener
implements XMLMessageListener {
    private static final Log log = LogFactory.getLog(JCSMPMessageListener.class);
    private MessageListener mListener = null;
    private AckHandler mAckHandler;
    private ExceptionListener mExceptionListener;

    public JCSMPMessageListener(AckHandler ackHandler, ExceptionListener exceptionListener) {
        this.mAckHandler = ackHandler;
        this.mExceptionListener = exceptionListener;
    }

    public void setMessageListener(MessageListener listener) {
        this.mListener = listener;
    }

    public MessageListener getMessageListener() {
        return this.mListener;
    }

    public ExceptionListener getExceptionListener() {
        return this.mExceptionListener;
    }

    public void onException(JCSMPException exception) {
        if (log.isInfoEnabled()) {
            log.info((Object)"Exception on async receiving", (Throwable)((Object)exception));
        }
        if (!(exception instanceof JCSMPTransportException)) {
            this.mExceptionListener.onException(Validator.createJMSException("soljms.operation.recv", (Throwable)((Object)exception)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceive(BytesXMLMessage message) {
        SolMessage jmsMessage = null;
        boolean messageProcessed = false;
        try {
            if (this.mListener != null && message != null) {
                jmsMessage = JMSDecoder.createJMSMessage(message);
                jmsMessage.setAckHandler(this.mAckHandler);
                this.mAckHandler.onMessageCreate(jmsMessage);
                this.mListener.onMessage((Message)jmsMessage);
                messageProcessed = true;
            }
        }
        catch (Throwable t) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error on async receiving of BytesXMLMessage", t);
            }
        }
        finally {
            if (jmsMessage != null && messageProcessed) {
                try {
                    this.mAckHandler.onMessageSent(jmsMessage);
                }
                catch (JMSException e) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Exception on async receiving", (Throwable)e);
                    }
                    this.mExceptionListener.onException(e);
                }
            }
        }
    }
}

