/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.common.SolReserved;
import com.solacesystems.common.util.Arrays;
import com.solacesystems.common.util.SolByteBuffer;
import com.solacesystems.jcsmp.Consumer;
import com.solacesystems.jcsmp.DeliveryMode;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPFactory;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.MessageType;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.User_Cos;
import com.solacesystems.jcsmp.XMLMessage;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.AbstractDestination;
import com.solacesystems.jcsmp.impl.BufferCloningPool;
import com.solacesystems.jcsmp.impl.BufferCloningUser;
import com.solacesystems.jcsmp.impl.ConsumerIdReadOnlyParserList;
import com.solacesystems.jcsmp.impl.ContentBuffer;
import com.solacesystems.jcsmp.impl.HeaderStore;
import com.solacesystems.jcsmp.impl.HeaderStoreImplRO;
import com.solacesystems.jcsmp.impl.HeaderStoreImplRW;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.JCSMPUtils;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessagePool;
import com.solacesystems.jcsmp.impl.PubSubMode;
import com.solacesystems.jcsmp.impl.QueueImpl;
import com.solacesystems.jcsmp.impl.TargetRouterMode;
import com.solacesystems.jcsmp.impl.TopicImpl;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import com.solacesystems.jcsmp.impl.sdt.TLVBuffer;
import com.solacesystems.jcsmp.protocol.CSMPSubscriberChannel;
import com.solacesystems.jcsmp.protocol.nio.impl.ConsumerLargeMessageNotification;
import com.solacesystems.jcsmp.protocol.smf.SMFPubMsgHeaderBean;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JCSMPXMLMessage
implements XMLMessage,
BufferCloningUser {
    public static final int PRORITY_UNDEFINED = -1;
    public static final int PRORITY_DEFAULT = 4;
    public static final int PRORITY_MAX = 255;
    private static final Log Trace = LogFactory.getLog(JCSMPXMLMessage.class);
    private AtomicInteger atomReleaseExpect = new AtomicInteger(0);
    private long messageId;
    private long ackMessageId;
    private boolean discardIndication = false;
    private boolean tqDiscardIndication = false;
    private boolean elidingEligible = false;
    private boolean isAcked = false;
    private byte[] userData;
    private DeliveryMode messageDM = DeliveryMode.DIRECT;
    private int priority = -1;
    private User_Cos userCos = User_Cos.USER_COS_1;
    private long timeToLive = 0L;
    private long expiration = 0L;
    private boolean dmqEligible = false;
    private boolean redelivered = false;
    private boolean forceRedeliveredFlag = false;
    private int seqNum = -1;
    private long producerId = -1L;
    private String p2pTopicDescriptionBase = null;
    private String p2pTopicSuffix = null;
    private transient CSMPSubscriberChannel channel = null;
    private Consumer consumer = null;
    private JCSMPSession session = null;
    private boolean flagReturnedToPool = false;
    private JCSMPXMLMessagePool msgPool = null;
    private Destination destinationReceived = null;
    private Destination destinationSent = null;
    private byte[] destinationReceivedBytes = null;
    private Object correlationKey = null;
    private long flowId = -1L;
    private boolean ackImmediately = false;
    private int adSessionUid = 0;
    protected BufferCloningPool _lastSimBufferPool = null;
    private HeaderStore hdrStore = null;
    private boolean deliverToOne = false;
    private boolean sequenceNumberSetByUser = false;
    private boolean sendTimestampSetByUser = false;
    private boolean senderIDSetByUser = false;
    private boolean cacheMessage = false;
    private boolean suspect = false;
    private Long requestId = null;
    private volatile boolean safeToRetransmit = false;
    private volatile long safeToRetransmitTstamp = 0L;
    private volatile boolean safeToRelease = false;
    private volatile boolean retransmitting = false;
    private volatile boolean sendAttemptedOnce = false;
    private int compatFlags = 0;
    protected boolean readOnly = false;
    protected boolean newMsgIdRequired = true;
    protected int sendCount = 0;
    protected long prevMessageId = 0L;
    private long rxTimestamp = 0L;
    protected ContentBuffer metadataCB;
    protected ContentBuffer attachmentCB;
    protected ContentBuffer binaryMetadataCB;
    protected ContentBuffer contentCB;
    protected boolean mHasAttachment = false;
    protected int binaryMetadataType = -1;
    protected byte[] cidlist = null;
    protected int topicNameOffset = -1;
    protected int topicNameLen = -1;
    protected int queueNameOffset = -1;
    protected int queueNameLen = -1;
    protected Long topicSequenceNumber = null;
    protected byte[] readBuffer;
    private SMFPubMsgHeaderBean _encodingSmfPubMsgHeader;
    protected static final String ERR_ONLY_ONE_ATTACHMENT_SUPPORTED = JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.invalidAttachmentMaxOne");
    public static final long NULL_MSGID = -1L;
    public static final long NULL_FLOWID = -1L;
    public static final int FLAG_COMPAT_SETPERSISTENT = 1;
    public static final int FLAG_COMPAT_PERSISTENT_UNSET = 2;
    protected boolean useDirectBuffer = false;
    private static final long MAX_TTL = 315360000000L;
    private ConsumerLargeMessageNotification largeMsgInfo;

    protected JCSMPXMLMessage(boolean useDirect, boolean isPub) {
        this.useDirectBuffer = useDirect;
        if (isPub) {
            this._encodingSmfPubMsgHeader = new SMFPubMsgHeaderBean(this.useDirectBuffer);
        }
    }

    protected JCSMPXMLMessage(JCSMPXMLMessage toclone, BufferCloningPool contentBufPool) {
        this.useDirectBuffer = toclone.useDirectBuffer;
        this.messageId = toclone.messageId;
        this.discardIndication = toclone.discardIndication;
        this.tqDiscardIndication = toclone.tqDiscardIndication;
        this.elidingEligible = toclone.elidingEligible;
        this.isAcked = toclone.isAcked;
        this.userData = toclone.userData == null ? null : Arrays.copyOf(toclone.userData);
        this.messageDM = toclone.messageDM;
        this.priority = toclone.priority;
        this.userCos = toclone.userCos;
        this.timeToLive = toclone.timeToLive;
        this.expiration = toclone.expiration;
        this.dmqEligible = toclone.dmqEligible;
        this.redelivered = toclone.redelivered;
        this.forceRedeliveredFlag = toclone.forceRedeliveredFlag;
        this.seqNum = toclone.seqNum;
        this.producerId = toclone.producerId;
        this.p2pTopicDescriptionBase = toclone.p2pTopicDescriptionBase;
        this.p2pTopicSuffix = toclone.p2pTopicSuffix;
        this.channel = toclone.channel;
        this.consumer = toclone.consumer;
        this.session = toclone.session;
        this.flagReturnedToPool = toclone.flagReturnedToPool;
        this.msgPool = toclone.msgPool;
        this.destinationReceived = toclone.destinationReceived;
        this.destinationSent = toclone.destinationSent;
        this.destinationReceivedBytes = toclone.destinationReceivedBytes == null ? null : Arrays.copyOf(toclone.destinationReceivedBytes);
        this.correlationKey = toclone.correlationKey;
        this.flowId = toclone.flowId;
        this.ackImmediately = toclone.ackImmediately;
        this.adSessionUid = toclone.adSessionUid;
        this.hdrStore = null;
        this.deliverToOne = toclone.deliverToOne;
        this.cacheMessage = toclone.cacheMessage;
        this.suspect = toclone.suspect;
        this.requestId = toclone.requestId;
        this.safeToRetransmit = toclone.safeToRetransmit;
        this.safeToRetransmitTstamp = toclone.safeToRetransmitTstamp;
        this.safeToRelease = toclone.safeToRelease;
        this.retransmitting = toclone.retransmitting;
        this.compatFlags = toclone.compatFlags;
        this.readOnly = toclone.readOnly;
        this.newMsgIdRequired = toclone.newMsgIdRequired;
        this.sendCount = toclone.sendCount;
        this.sendAttemptedOnce = toclone.sendAttemptedOnce;
        this.prevMessageId = toclone.prevMessageId;
        this.rxTimestamp = toclone.rxTimestamp;
        this.contentCB = toclone.contentCB == null ? null : contentBufPool.acquireCopy(toclone.contentCB);
        this.metadataCB = toclone.metadataCB == null ? null : contentBufPool.acquireCopy(toclone.metadataCB);
        this.attachmentCB = toclone.attachmentCB == null ? null : contentBufPool.acquireCopy(toclone.attachmentCB);
        this.mHasAttachment = toclone.mHasAttachment;
        this.binaryMetadataCB = toclone.binaryMetadataCB == null ? null : contentBufPool.acquireCopy(toclone.binaryMetadataCB);
        this._lastSimBufferPool = contentBufPool;
        this.binaryMetadataType = toclone.binaryMetadataType;
        this.cidlist = toclone.cidlist == null ? null : Arrays.copyOf(toclone.cidlist);
        this.topicNameOffset = toclone.topicNameOffset;
        this.topicNameLen = toclone.topicNameLen;
        this.queueNameOffset = toclone.queueNameOffset;
        this.queueNameLen = toclone.queueNameLen;
        this.topicSequenceNumber = toclone.topicSequenceNumber;
        this.readBuffer = toclone.readBuffer == null ? null : Arrays.copyOf(toclone.readBuffer);
        this._encodingSmfPubMsgHeader = toclone._encodingSmfPubMsgHeader == null ? null : new SMFPubMsgHeaderBean(toclone._encodingSmfPubMsgHeader, contentBufPool);
    }

    @Override
    public String getMessageId() {
        return this.messageId == -1L ? null : String.valueOf(this.messageId);
    }

    @Override
    public final long getMessageIdLong() {
        return this.messageId;
    }

    public final void setMessageIdLong(long msgId) {
        this.messageId = msgId;
    }

    @Override
    public final long getAckMessageId() {
        return this.ackMessageId;
    }

    public final void setAckMessageId(long ackMsgId) {
        this.ackMessageId = ackMsgId;
    }

    @Override
    public boolean hasUserData() {
        return this.userData != null;
    }

    @Override
    public byte[] getUserData() {
        return this.userData;
    }

    @Override
    public void setUserData(byte[] userData) {
        this.checkReadOnlyBeforeModify();
        if (userData != null && userData.length > 36) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.invalidUserdata"));
        }
        this.userData = userData;
    }

    @Override
    public MessageType getMessageType() {
        return this.messageDM.getEquivMessageType();
    }

    @Override
    public void setMessageType(MessageType msgType) {
        this.compatFlags &= 0xFFFFFFFD;
        this.messageDM = msgType.getEquivDeliveryMode();
    }

    @Override
    public DeliveryMode getDeliveryMode() {
        return this.messageDM;
    }

    @Override
    public void setDeliveryMode(DeliveryMode mode) {
        this.checkReadOnlyBeforeModify();
        this.messageDM = mode;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.checkReadOnlyBeforeModify();
        if (priority < -1 || priority > 255) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.invalidPriority"));
        }
        this.priority = priority;
    }

    @Override
    public User_Cos getCos() {
        return this.userCos;
    }

    @Override
    public void setCos(User_Cos cosValue) {
        this.checkReadOnlyBeforeModify();
        this.userCos = cosValue;
    }

    @Override
    public boolean getRedelivered() {
        return this.redelivered;
    }

    public void setRedelivered(boolean redelivered) {
        this.checkReadOnlyBeforeModify();
        this.redelivered = redelivered;
    }

    public void setForceRedeliveredFlag(boolean forceRedeliveredFlag) {
        this.checkReadOnlyBeforeModify();
        this.forceRedeliveredFlag = forceRedeliveredFlag;
    }

    public boolean isForceRedeliveredFlag() {
        return this.forceRedeliveredFlag;
    }

    @Override
    public long getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public void setTimeToLive(long ttl) {
        this.checkReadOnlyBeforeModify();
        if (ttl < 0L || ttl > 315360000000L) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.invalidTTL"));
        }
        this.timeToLive = ttl;
        if (ttl == 0L) {
            this.expiration = 0L;
        }
    }

    @Override
    public boolean isDMQEligible() {
        return this.dmqEligible;
    }

    @Override
    public void setDMQEligible(boolean dmqEligible) {
        this.checkReadOnlyBeforeModify();
        this.dmqEligible = dmqEligible;
    }

    public void setAdSessionUid(int uid) {
        this.adSessionUid = uid;
    }

    public int getAdSessionUid() {
        return this.adSessionUid;
    }

    @Override
    public void ackMessage() {
        if (this.isAcked || !JCSMPUtils.isAdMessage(this) || this.isCacheMessage()) {
            return;
        }
        if (this.consumer == null) {
            if (Trace.isWarnEnabled()) {
                Trace.warn((Object)"ackMessage is ignored because the message acknowledgement mode is auto-ack");
            }
            return;
        }
        try {
            JCSMPBasicSession session = ((FlowHandleImpl)this.consumer).getSession();
            if (session != null) {
                session.waitUntilSessionReconnectDone("ackMessage");
            }
        }
        catch (JCSMPException e) {
            Trace.warn((Object)("ackMessage caught exception: " + e.getMessage()));
        }
        ((FlowHandleImpl)this.consumer).ackMessage(this);
        this.isAcked = true;
    }

    @Override
    @Deprecated
    public void rejectMessage() {
        this.ackMessage();
    }

    @Override
    public boolean getDiscardIndication() {
        return this.discardIndication;
    }

    public void setDiscardIndication(boolean di) {
        this.discardIndication = di;
    }

    @Override
    public boolean getTQDiscardIndication() {
        return this.tqDiscardIndication;
    }

    public void setTQDiscardIndication(boolean tqd) {
        this.tqDiscardIndication = tqd;
    }

    @Override
    public void setElidingEligible(boolean eliding) {
        this.elidingEligible = eliding;
    }

    @Override
    public boolean isElidingEligible() {
        return this.elidingEligible;
    }

    @Override
    public int getContentLength() {
        return this.contentCB != null ? this.contentCB.getLimit() : 0;
    }

    @Override
    public void clearContent() {
        this.checkReadOnlyBeforeModify();
        this.newMsgIdRequired = true;
        if (this.contentCB != null) {
            this.contentCB.reset();
        }
    }

    @Override
    public void setReadOnly() {
        this.readOnly = true;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void clearAttachment() {
        this.checkReadOnlyBeforeModify();
        if (this.attachmentCB != null) {
            this.attachmentCB.reset();
        }
        this.mHasAttachment = false;
    }

    @Override
    public boolean hasAttachment() {
        return this.mHasAttachment;
    }

    @Override
    public int getAttachmentContentLength() {
        return this.attachmentCB != null ? this.attachmentCB.getLimit() : 0;
    }

    @Override
    public synchronized int readAttachmentBytes(int srcPos, byte[] byteOutputBuffer, int destPos, int length) {
        return this.attachmentCB != null ? this.attachmentCB.read(srcPos, byteOutputBuffer, destPos, length) : -1;
    }

    @Override
    public int readAttachmentBytes(byte[] byteOutputBuffer) {
        return this.readAttachmentBytes(0, byteOutputBuffer, 0, byteOutputBuffer.length);
    }

    @Override
    public int readAttachmentBytes(byte[] byteOutputBuffer, int length) {
        return this.readAttachmentBytes(0, byteOutputBuffer, 0, length);
    }

    @Override
    public void rewindAttachment() {
    }

    @Override
    public int writeNewAttachment(byte[] byteInputBuffer) {
        return this.writeAttachment(byteInputBuffer);
    }

    @Override
    public int writeAttachment(byte[] byteInputBuffer) {
        if (byteInputBuffer != null) {
            return this.writeAttachment(byteInputBuffer, 0, byteInputBuffer.length);
        }
        return 0;
    }

    @Override
    public int writeNewAttachment(byte[] byteInputBuffer, int offset, int length) throws BufferUnderflowException {
        return this.writeAttachment(byteInputBuffer, offset, length);
    }

    @Override
    public int writeAttachment(byte[] byteInputBuffer, int offset, int length) throws BufferUnderflowException {
        this.checkReadOnlyBeforeModify();
        this.newMsgIdRequired = true;
        this.mHasAttachment = true;
        if (this.attachmentCB == null) {
            this.attachmentCB = new ContentBuffer(length, this.useDirectBuffer);
        }
        return this.attachmentCB.writeFromBytes(byteInputBuffer, offset, length);
    }

    @Override
    public int writeNewAttachment(InputStream stream, int offset, int length) throws IOException {
        this.checkReadOnlyBeforeModify();
        this.newMsgIdRequired = true;
        this.mHasAttachment = true;
        if (this.attachmentCB == null) {
            this.attachmentCB = new ContentBuffer(length, this.useDirectBuffer);
        }
        return this.attachmentCB.writeFromStream(stream, offset, length);
    }

    @Override
    public int writeAttachment(InputStream stream) throws IOException {
        this.checkReadOnlyBeforeModify();
        this.newMsgIdRequired = true;
        this.mHasAttachment = true;
        if (this.attachmentCB == null) {
            this.attachmentCB = new ContentBuffer();
        }
        return this.attachmentCB.writeFromStream(stream, 0, -1);
    }

    @Override
    public int writeNewAttachment(InputStream stream) throws IOException {
        return this.writeAttachment(stream);
    }

    public void clearMetadata() {
        this.checkReadOnlyBeforeModify();
        if (this.metadataCB != null) {
            this.metadataCB.reset();
        }
    }

    public int getMetadataContentLength() {
        return this.metadataCB != null ? this.metadataCB.getLimit() : 0;
    }

    public boolean hasMetadata() {
        return this.getMetadataContentLength() > 0;
    }

    @Override
    public boolean hasContent() {
        return this.getContentLength() > 0;
    }

    public synchronized int readMetadataBytes(int srcPos, byte[] byteOutputBuffer, int destPos, int length) {
        return this.metadataCB != null ? this.metadataCB.read(srcPos, byteOutputBuffer, destPos, length) : -1;
    }

    public int readMetadataBytes(byte[] byteOutputBuffer, int length) {
        return this.readMetadataBytes(0, byteOutputBuffer, 0, length);
    }

    public int readMetadataBytes(byte[] byteOutputBuffer) {
        return this.readMetadataBytes(0, byteOutputBuffer, 0, byteOutputBuffer.length);
    }

    public void rewindMetadata() {
    }

    public int writeMetadata(byte[] byteInputBuffer, int offset, int length) throws BufferUnderflowException {
        this.checkReadOnlyBeforeModify();
        this.newMsgIdRequired = true;
        if (this.metadataCB == null) {
            this.metadataCB = new ContentBuffer(length, this.useDirectBuffer);
        }
        return this.metadataCB.writeFromBytes(byteInputBuffer, offset, length);
    }

    public int writeMetadata(byte[] byteInputBuffer) {
        return this.writeMetadata(byteInputBuffer, 0, byteInputBuffer.length);
    }

    public int writeMetadata(InputStream stream) throws IOException {
        this.checkReadOnlyBeforeModify();
        this.newMsgIdRequired = true;
        if (this.metadataCB == null) {
            this.metadataCB = new ContentBuffer();
        }
        return this.metadataCB.writeFromStream(stream, 0, -1);
    }

    @Override
    @SolReserved
    public final void clearBinaryMetadataBytes(int type) {
        ContentBuffer cb;
        this.validateBinaryMetaType(type);
        ContentBuffer contentBuffer = cb = type == this.binaryMetadataType ? this.binaryMetadataCB : null;
        if (cb != null) {
            cb.reset();
            this.binaryMetadataType = -1;
        }
    }

    @Override
    @SolReserved
    public final int getBinaryMetadataContentLength(int type) {
        ContentBuffer cb = type == this.binaryMetadataType ? this.binaryMetadataCB : null;
        return cb == null ? 0 : cb.getLimit();
    }

    @Override
    @SolReserved
    public final Collection<Integer> getBinaryMetadataTypes() {
        this.checkHdrStoreInBinMeta();
        ArrayList<Integer> ret_list = new ArrayList<Integer>();
        if (this.binaryMetadataType != -1) {
            ret_list.add(this.binaryMetadataType);
        }
        return Collections.unmodifiableCollection(ret_list);
    }

    @Override
    @SolReserved
    public final boolean hasBinaryMetadata(int type) {
        return this.getBinaryMetadataContentLength(type) > 0;
    }

    @Override
    @SolReserved
    public final synchronized int readBinaryMetadataBytes(int type, byte[] byteOutputBuffer) {
        ContentBuffer cb;
        ContentBuffer contentBuffer = cb = type == this.binaryMetadataType ? this.binaryMetadataCB : null;
        if (cb != null) {
            return cb.read(0, byteOutputBuffer, 0, byteOutputBuffer.length);
        }
        return -1;
    }

    @Override
    @SolReserved
    public final int writeBinaryMetadataBytes(int type, byte[] byteInputBuffer) {
        return this.writeBinaryMetadataBytes(type, byteInputBuffer, 0, byteInputBuffer.length);
    }

    @Override
    @SolReserved
    public final int writeBinaryMetadataBytes(int type, byte[] byteInputBuffer, int offset, int length) throws BufferUnderflowException {
        this.validateBinaryMetaType(type);
        ContentBuffer cb = this.binaryMetadataCB;
        if (cb == null) {
            this.binaryMetadataCB = cb = new ContentBuffer(length, this.useDirectBuffer);
        }
        this.binaryMetadataType = type;
        return cb.writeFromBytes(byteInputBuffer, offset, length);
    }

    private final void validateBinaryMetaType(int type) {
        if (type != 0) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.invalidBinMetaType"));
        }
    }

    @SolReserved
    public final boolean hasBinaryMetadataAny() {
        return this.binaryMetadataType != -1;
    }

    @SolReserved
    public final ContentBuffer getBinaryMetadataCB() {
        this.checkHdrStoreInBinMeta();
        return this.binaryMetadataCB;
    }

    @SolReserved
    public final int getBinaryMetadataType() {
        return this.binaryMetadataType;
    }

    @SolReserved
    public final void setBinaryMetadataCB(ContentBuffer cb, int type) {
        this.binaryMetadataCB = cb;
        this.binaryMetadataType = type;
        if (type == 0) {
            TLVBuffer headerBuf = new TLVBuffer(cb.getBufferRefInternal());
            this.hdrStore = new HeaderStoreImplRO(headerBuf);
        }
    }

    public int writeCidListData(byte[] input, int offset, int length) {
        this.cidlist = new byte[length];
        System.arraycopy(input, offset, this.cidlist, 0, length);
        return length;
    }

    @Override
    public List<Long> getConsumerIdList() {
        return new ConsumerIdReadOnlyParserList(this.cidlist);
    }

    @Override
    public void setTopicNameLocation(int offset, int length) {
        if (this.queueNameOffset >= 0) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.topicQueueMutuallyExclusive"));
        }
        if (offset < 0 || offset > 255) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.invalidTopicNameOffset"));
        }
        if (length < 0 || length > 255) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.invalidTopicNameLen"));
        }
        this.topicNameOffset = offset;
        this.topicNameLen = length;
    }

    @Override
    public int getTopicNameOffset() {
        return this.topicNameOffset;
    }

    @Override
    public int getTopicNameLength() {
        return this.topicNameLen;
    }

    @Override
    public void clearTopicNameLocation() {
        this.topicNameOffset = -1;
        this.topicNameLen = -1;
    }

    @Override
    public void setQueueNameLocation(int offset, int length) {
        if (this.topicNameOffset >= 0) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.topicQueueMutuallyExclusive"));
        }
        if (offset < 0 || offset > 255) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.invalidQueueNameOffset"));
        }
        if (length < 0 || length > 255) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.invalidQueueNameLen"));
        }
        this.queueNameOffset = offset;
        this.queueNameLen = length;
    }

    @Override
    public int getQueueNameOffset() {
        return this.queueNameOffset;
    }

    @Override
    public int getQueueNameLength() {
        return this.queueNameLen;
    }

    @Override
    public void clearQueueNameLocation() {
        this.queueNameOffset = -1;
        this.queueNameLen = -1;
    }

    @Override
    public boolean isAckImmediately() {
        return this.ackImmediately;
    }

    @Override
    public void setAckImmediately(boolean ackImmediately) {
        this.checkReadOnlyBeforeModify();
        this.ackImmediately = ackImmediately;
    }

    @Override
    public void reset() {
        this.reset(false);
    }

    public void reset(boolean resetMsgType) {
        this.messageId = -1L;
        this.producerId = -1L;
        this.p2pTopicDescriptionBase = null;
        this.p2pTopicSuffix = null;
        this.userData = null;
        this.compatFlags = 0;
        this.compatFlags |= 2;
        this.messageDM = DeliveryMode.DIRECT;
        this.priority = -1;
        this.userCos = User_Cos.USER_COS_1;
        this.timeToLive = 0L;
        this.expiration = 0L;
        this.dmqEligible = false;
        this.redelivered = false;
        this.forceRedeliveredFlag = false;
        this.seqNum = -1;
        this.prevMessageId = 0L;
        this.newMsgIdRequired = true;
        this.sendCount = 0;
        this.isAcked = false;
        this.flagReturnedToPool = false;
        this.discardIndication = false;
        this.tqDiscardIndication = false;
        this.elidingEligible = false;
        this.cidlist = null;
        this.destinationReceived = null;
        this.destinationReceivedBytes = null;
        this.destinationSent = null;
        this.correlationKey = null;
        this.channel = null;
        this.consumer = null;
        this.session = null;
        this.flowId = -1L;
        this.ackImmediately = false;
        this.adSessionUid = -1;
        this.rxTimestamp = 0L;
        this.deliverToOne = false;
        this.safeToRetransmit = false;
        this.safeToRetransmitTstamp = 0L;
        this.safeToRelease = false;
        this.retransmitting = false;
        this.atomReleaseExpect.set(0);
        this.sendAttemptedOnce = false;
        if (this.attachmentCB != null) {
            this.attachmentCB.reset();
        }
        this.mHasAttachment = false;
        if (this.contentCB != null) {
            this.contentCB.reset();
        }
        if (this.metadataCB != null) {
            this.metadataCB.reset();
        }
        if (this.binaryMetadataCB != null) {
            this.binaryMetadataCB.reset();
        }
        this._lastSimBufferPool = null;
        this.binaryMetadataType = -1;
        this.readOnly = false;
        if (this.hdrStore != null) {
            this.hdrStore.reset(resetMsgType);
        }
        this.clearTopicNameLocation();
        this.clearQueueNameLocation();
    }

    public void callout_ad_release_opportunity() {
        int newRelValue = this.atomReleaseExpect.decrementAndGet();
        if (newRelValue <= 0) {
            this.returnMessageToPool();
        }
    }

    public void set_ad_release_expect(int count) {
        this.atomReleaseExpect.set(count);
    }

    public long getInternalProducerId() {
        return this.producerId;
    }

    public void setInternalProducerId(long value) {
        this.producerId = value;
    }

    public void setInternalP2pTopicDescriptionBase(String t) {
        this.p2pTopicDescriptionBase = t;
        if (this.p2pTopicSuffix != null) {
            this.setReplyTo(JCSMPXMLMessage.buildReplyToFromSuffix(this.p2pTopicDescriptionBase, this.p2pTopicSuffix));
        }
    }

    protected static Topic buildReplyToFromSuffix(String base, String suffix) {
        int levelDelim = 47;
        suffix = suffix.charAt(0) != '/' ? '/' + suffix : suffix;
        Topic replyTo = JCSMPFactory.onlyInstance().createTopic(base + suffix);
        return replyTo;
    }

    public int getCompatFlags() {
        return this.compatFlags;
    }

    public void setPrevMessageId(long id) {
        this.prevMessageId = id;
    }

    public long getPrevMessageId() {
        return this.prevMessageId;
    }

    public CSMPSubscriberChannel getChannel() {
        return this.channel;
    }

    public void setChannel(CSMPSubscriberChannel channel) {
        this.channel = channel;
    }

    public Consumer getMessageConsumer() {
        return this.consumer;
    }

    public void setMessageConsumer(Consumer consumer) {
        this.consumer = consumer;
    }

    public JCSMPSession getSession() {
        return this.session;
    }

    public void setSession(JCSMPSession session) {
        this.session = session;
    }

    public byte[] getMetadataContent() {
        return this.metadataCB != null ? this.metadataCB.getBufferRefInternal() : null;
    }

    public ContentBuffer getMetadataContentBuffer() {
        return this.metadataCB;
    }

    public byte[] getContent() {
        if (this.getContentLength() > 0) {
            return this.contentCB.getBufferRefInternal();
        }
        return null;
    }

    public ContentBuffer getContentBuffer() {
        return this.contentCB;
    }

    public byte[] getAttachmentContent() {
        return this.attachmentCB != null ? this.attachmentCB.getBufferRefInternal() : null;
    }

    public ContentBuffer getAttachmentContentBuffer() {
        return this.attachmentCB;
    }

    @Override
    public ByteBuffer getAttachmentByteBuffer() {
        if (this.attachmentCB == null) {
            return null;
        }
        ByteBuffer bbuf = this.attachmentCB.getByteBufferRefInternal().duplicate();
        bbuf.position(0);
        bbuf.limit(this.getAttachmentContentLength());
        return bbuf;
    }

    public int getSeqNum() {
        return this.seqNum;
    }

    public void setSeqNum(int seqNum) {
        this.seqNum = seqNum;
    }

    public boolean isNewMsgIdRequired() {
        return this.newMsgIdRequired;
    }

    public void setNewMsgIdRequired(boolean generateMsgId) {
        this.newMsgIdRequired = generateMsgId;
    }

    public int getSendCount() {
        return this.sendCount;
    }

    public void incrementSendCount() {
        ++this.sendCount;
    }

    public void resetSendCount() {
        this.sendCount = 0;
    }

    public boolean isSendAttemptedOnce() {
        return this.sendAttemptedOnce;
    }

    public void setSendAttemptedOnce(boolean sendAttemptedOnce) {
        this.sendAttemptedOnce = sendAttemptedOnce;
    }

    private void checkReadOnlyBeforeModify() {
        if (this.readOnly) {
            throw new IllegalAccessError(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.mayNotWriteToReadOnlyMsg"));
        }
    }

    private void checkHdrStoreBeforeModify() {
        if (this.hdrStore == null) {
            this.hdrStore = new HeaderStoreImplRW();
        }
    }

    public boolean isFlagReturnedToPool() {
        return this.flagReturnedToPool;
    }

    public void setFlagReturnedToPool(boolean flagReturnedToPool) {
        this.flagReturnedToPool = flagReturnedToPool;
    }

    public JCSMPXMLMessagePool getMsgPool() {
        return this.msgPool;
    }

    public void setMsgPool(JCSMPXMLMessagePool msgPool) {
        this.msgPool = msgPool;
    }

    public void returnMessageToPool() {
        if (!this.isFlagReturnedToPool() && this.msgPool != null) {
            this.setSafeToRetransmit(false);
            this.setSafeToRetransmitTstamp(0L);
            if (this.msgPool != null) {
                this.msgPool.returnMessageToPool(this);
            }
        }
        if (this._lastSimBufferPool != null) {
            this.releaseContentBuffer(this._lastSimBufferPool);
            this._lastSimBufferPool = null;
        }
    }

    @Override
    public void releaseContentBuffer(BufferCloningPool bufCloningPool) {
        if (this._lastSimBufferPool == null) {
            return;
        }
        this._lastSimBufferPool.release(this.contentCB);
        this._lastSimBufferPool.release(this.attachmentCB);
        this._lastSimBufferPool.release(this.metadataCB);
        this._lastSimBufferPool.release(this.binaryMetadataCB);
        if (this._encodingSmfPubMsgHeader != null) {
            this._encodingSmfPubMsgHeader.releaseContentBuffer(this._lastSimBufferPool);
        }
    }

    public boolean isSafeToRetransmit() {
        return this.safeToRetransmit;
    }

    public void setSafeToRetransmit(boolean safeToRetransmit) {
        this.safeToRetransmit = safeToRetransmit;
    }

    public long getSafeToRetransmitTstamp() {
        return this.safeToRetransmitTstamp;
    }

    public void setSafeToRetransmitTstamp(long safeToRetransmitTstamp) {
        this.safeToRetransmitTstamp = safeToRetransmitTstamp;
    }

    public boolean isSafeToRelease() {
        return this.safeToRelease;
    }

    public void setSafeToRelease(boolean safeToRelease) {
        this.safeToRelease = safeToRelease;
    }

    public boolean isRetransmitting() {
        return this.retransmitting;
    }

    public void setRetransmitting(boolean retransmitting) {
        this.retransmitting = retransmitting;
    }

    public void clearReadOnly() {
        this.readOnly = false;
    }

    @Override
    public Destination getDestination() {
        if (this.destinationReceived != null) {
            return this.destinationReceived;
        }
        if (this.destinationReceivedBytes != null) {
            String tr_topicName = new String(this.destinationReceivedBytes, Charset.forName("UTF-8"));
            this.destinationReceived = tr_topicName.startsWith("#P2P/Q") ? QueueImpl.createFromIncomingTrMsg(tr_topicName, this.getQueueNameOffset(), this.getQueueNameLength()) : TopicImpl.createFastNoValidation(tr_topicName);
            return this.destinationReceived;
        }
        return this.destinationReceived;
    }

    public void setDestinationReceived(Destination destrx) {
        this.destinationReceived = destrx;
    }

    public void setDestinationReceivedBytes(byte[] destrxBytes) {
        this.destinationReceivedBytes = destrxBytes;
    }

    public byte[] getDestinationReceivedBytes() {
        return this.destinationReceivedBytes;
    }

    public void setDestinationSent(Destination desttx) {
        this.destinationSent = desttx;
    }

    public Destination getDestinationSent() {
        return this.destinationSent;
    }

    @Override
    public Object getCorrelationKey() {
        return this.correlationKey;
    }

    @Override
    public void setCorrelationKey(Object key) {
        this.correlationKey = key;
    }

    public long getFlowId() {
        return this.flowId;
    }

    public void setFlowId(long flowId) {
        this.flowId = flowId;
    }

    @Override
    public String getAppMessageID() {
        return this.getApplicationMessageId();
    }

    @Override
    public String getApplicationMessageId() {
        if (this.hdrStore != null) {
            return this.hdrStore.getAppMessageID();
        }
        return null;
    }

    @Override
    public String getAppMessageType() {
        return this.getApplicationMessageType();
    }

    @Override
    public String getApplicationMessageType() {
        if (this.hdrStore != null) {
            return this.hdrStore.getAppMessageType();
        }
        return null;
    }

    @Override
    public String getCorrelationId() {
        if (this.hdrStore != null) {
            return this.hdrStore.getCorrelationID();
        }
        return null;
    }

    @Override
    public boolean getDeliverToOne() {
        return this.deliverToOne;
    }

    @Override
    public SDTMap getProperties() {
        if (this.hdrStore != null) {
            return this.hdrStore.getPropertyMap();
        }
        return null;
    }

    @Override
    public Destination getReplyTo() {
        if (this.hdrStore != null) {
            return this.hdrStore.getReplyTo();
        }
        return null;
    }

    @Override
    public long getReceiveTimestamp() {
        return this.rxTimestamp;
    }

    public void setReceiveTimestamp(long t) {
        this.rxTimestamp = t;
    }

    @Override
    public String getSenderID() {
        return this.getSenderId();
    }

    @Override
    public String getSenderId() {
        if (this.hdrStore != null) {
            return this.hdrStore.getSenderID();
        }
        return null;
    }

    @Override
    public Long getSequenceNumber() {
        if (this.hdrStore != null) {
            return this.hdrStore.getSequenceNumber();
        }
        return null;
    }

    @Override
    public long getExpiration() {
        return this.expiration;
    }

    public Long getExpirationBinaryMeta() {
        if (this.hdrStore != null) {
            return this.hdrStore.getExpiration();
        }
        return null;
    }

    @Override
    public Long getSendTimestamp() {
        return this.getSenderTimestamp();
    }

    @Override
    public Long getSenderTimestamp() {
        if (this.hdrStore != null) {
            return this.hdrStore.getSendTimestamp();
        }
        return null;
    }

    @Override
    public byte getStructuredMsgType() {
        Byte msgType;
        if (this.hdrStore != null && (msgType = this.hdrStore.getStructuredMsgType()) != null) {
            return msgType;
        }
        if (this.getContentLength() > 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isStructuredMsg() {
        Boolean isStruct;
        if (this.hdrStore != null && (isStruct = this.hdrStore.isStructured()) != null) {
            return isStruct;
        }
        return false;
    }

    @Override
    public void setAppMessageID(String msgId) {
        this.setApplicationMessageId(msgId);
    }

    @Override
    public void setApplicationMessageId(String msgId) {
        this.checkReadOnlyBeforeModify();
        this.checkHdrStoreBeforeModify();
        this.hdrStore.setAppMessageID(msgId);
    }

    @Override
    public void setAppMessageType(String appMsgType) {
        this.setApplicationMessageType(appMsgType);
    }

    @Override
    public void setApplicationMessageType(String appMsgType) {
        this.checkReadOnlyBeforeModify();
        this.checkHdrStoreBeforeModify();
        this.hdrStore.setAppMessageType(appMsgType);
    }

    @Override
    public void setCorrelationId(String id) {
        this.checkReadOnlyBeforeModify();
        this.checkHdrStoreBeforeModify();
        this.hdrStore.setCorrelationId(id);
    }

    @Override
    public void setDeliverToOne(boolean deliverToOne) {
        this.deliverToOne = deliverToOne;
    }

    @Override
    public void setProperties(SDTMap props) {
        this.checkReadOnlyBeforeModify();
        this.checkHdrStoreBeforeModify();
        this.hdrStore.setPropertyMap(props);
    }

    @Override
    public boolean isReplyMessage() {
        Boolean isResponse;
        if (this.hdrStore != null && (isResponse = this.hdrStore.isResponse()) != null) {
            return isResponse;
        }
        return false;
    }

    @Override
    public void setAsReplyMessage(boolean isResponse) {
        this.checkHdrStoreBeforeModify();
        this.hdrStore.setIsResponse(isResponse);
    }

    @Override
    public void setReplyTo(Destination destination) {
        this.checkReadOnlyBeforeModify();
        this.checkHdrStoreBeforeModify();
        if (destination != null) {
            ((AbstractDestination)destination).validate(TargetRouterMode.TRB, PubSubMode.SUB);
            ((AbstractDestination)destination).validate(TargetRouterMode.TRB, PubSubMode.PUB);
        }
        this.hdrStore.setReplyTo(destination);
    }

    @Override
    public void setReplyToSuffix(String suffix) {
        if (suffix == null) {
            this.setReplyTo(null);
            this.p2pTopicSuffix = null;
        } else if (this.p2pTopicDescriptionBase != null) {
            this.setReplyTo(JCSMPXMLMessage.buildReplyToFromSuffix(this.p2pTopicDescriptionBase, suffix));
        } else {
            this.p2pTopicSuffix = suffix;
        }
    }

    @Override
    public String getReplyToSuffix() {
        if (this.getReplyTo() != null) {
            return this.stripSessionP2pPrefix(this.getReplyTo());
        }
        return this.p2pTopicSuffix;
    }

    @Override
    public String getDestinationTopicSuffix() {
        Destination incomingDest = this.getDestination();
        return this.stripSessionP2pPrefix(incomingDest);
    }

    private String stripSessionP2pPrefix(Destination d) {
        if (d instanceof Topic) {
            String localDestTopicPrefix;
            int levelDelim = 47;
            String incomingDestTopic = d.getName();
            if (this.p2pTopicDescriptionBase == null && this.session != null) {
                this.p2pTopicDescriptionBase = (String)this.session.getProperty("P2PTOPICDESCRIPTION");
            }
            if (incomingDestTopic.startsWith(localDestTopicPrefix = this.p2pTopicDescriptionBase + '/')) {
                return incomingDestTopic.substring(localDestTopicPrefix.length());
            }
        }
        return null;
    }

    @Override
    public void setSenderID(String senderID) {
        this.setSenderId(senderID);
    }

    @Override
    public void setSenderId(String senderId) {
        this.setSenderId(senderId, true);
    }

    public void setSenderId_internal(String senderId) {
        this.setSenderId(senderId, false);
    }

    private void setSenderId(String senderId, boolean byUser) {
        this.checkReadOnlyBeforeModify();
        this.checkHdrStoreBeforeModify();
        this.hdrStore.setSenderID(senderId);
        this.senderIDSetByUser = byUser;
    }

    @Override
    public void setSendTimestamp(long ts) {
        this.setSenderTimestamp(ts);
    }

    private void setSendTimestamp(long ts, boolean byUser) {
        this.checkReadOnlyBeforeModify();
        this.checkHdrStoreBeforeModify();
        this.hdrStore.setSendTimestamp(ts);
        this.sendTimestampSetByUser = byUser;
    }

    @Override
    public void setSenderTimestamp(long ts) {
        this.setSendTimestamp(ts, true);
    }

    public void setSendTimestamp_internal(long ts) {
        this.setSendTimestamp(ts, false);
    }

    @Override
    public void setSequenceNumber(long seqNum) {
        this.checkReadOnlyBeforeModify();
        this.checkHdrStoreBeforeModify();
        this.hdrStore.setSequenceNumber(seqNum);
        this.sequenceNumberSetByUser = true;
    }

    public void setSequenceNumber_internal(long seqNum) {
        this.checkReadOnlyBeforeModify();
        this.checkHdrStoreBeforeModify();
        this.hdrStore.setSequenceNumber(seqNum);
        this.sequenceNumberSetByUser = false;
    }

    public boolean isSequenceNumberSetByUser() {
        return this.sequenceNumberSetByUser;
    }

    public boolean isSendTimestampSetByUser() {
        return this.sendTimestampSetByUser;
    }

    public boolean isSenderIDSetByUser() {
        return this.senderIDSetByUser;
    }

    @Override
    public void setExpiration(long expiration) {
        this.checkReadOnlyBeforeModify();
        if (expiration < 0L) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.invalidExpiration"));
        }
        this.expiration = expiration;
    }

    public void setExpirationBinaryMeta(long expiration) {
        this.checkReadOnlyBeforeModify();
        this.checkHdrStoreBeforeModify();
        this.hdrStore.setExpiration(expiration);
    }

    public void resetExpirationBinaryMeta() {
        this.checkReadOnlyBeforeModify();
        if (this.hdrStore != null) {
            this.hdrStore.setExpiration(null);
        }
    }

    @Override
    public void setStructuredMsgType(byte value) {
        if (!this.readOnly) {
            this.checkHdrStoreBeforeModify();
            this.hdrStore.setStructuredMsgType(value);
        }
    }

    @Override
    public void setStructuredMsg(boolean value) {
        if (!this.readOnly) {
            this.checkHdrStoreBeforeModify();
            this.hdrStore.setIsStructured(value);
        }
    }

    @Override
    public Long getCacheRequestId() {
        return this.requestId;
    }

    public void setCacheRequestId(Long id) {
        this.requestId = id;
    }

    @Override
    public boolean isCacheMessage() {
        return this.cacheMessage;
    }

    public void setCacheMessage() {
        this.cacheMessage = true;
    }

    @Override
    public boolean isSuspect() {
        return this.suspect;
    }

    public void setSuspect() {
        this.suspect = true;
    }

    public void checkHdrStoreInBinMeta() {
        if (this.hdrStore != null && ((HeaderStoreImplRW)this.hdrStore).isChanged()) {
            SolByteBuffer buf = ((HeaderStoreImplRW)this.hdrStore).asByteBuffer();
            if (buf == null) {
                this.clearBinaryMetadataBytes(0);
            } else {
                this.writeBinaryMetadataBytes(0, buf.getBackingArray(), 0, buf.getLength());
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof JCSMPXMLMessage)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        JCSMPXMLMessage another = (JCSMPXMLMessage)obj;
        return this.messageId == another.getMessageIdLong() && this.redelivered == another.getRedelivered() && this.seqNum == another.getSeqNum();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append("[").append("messageId=").append(this.messageId).append(",");
        sb.append("ackMessageId=").append(this.ackMessageId).append(",");
        sb.append("prevId=").append(this.prevMessageId).append(",");
        sb.append("CID_count=").append(this.cidlist == null ? 0 : this.cidlist.length / 4).append(",");
        sb.append("userData=").append(this.userData == null ? "" : this.userData.length + "B").append(",");
        sb.append("type=").append(this.getDeliveryMode().toString()).append(",");
        if (this.priority != -1) {
            sb.append("priority=").append(this.priority).append(",");
        }
        sb.append("redelivered=").append(this.redelivered).append(",");
        sb.append("timeToLive=").append(this.timeToLive).append(",");
        sb.append("expiration=").append(this.expiration).append(",");
        sb.append("dmqEligible=").append(this.dmqEligible).append(",");
        sb.append("topicSeqNum=").append(this.topicSequenceNumber).append(",");
        sb.append("metadataLen=").append(this.getMetadataContentLength()).append(",");
        sb.append("contentLen=").append(this.getContentLength()).append(",");
        sb.append("attLen=").append(this.getAttachmentContentLength()).append(",");
        sb.append("deliverToOne=").append(this.getDeliverToOne()).append(",");
        sb.append("ackImmediately=").append(this.ackImmediately).append(",");
        sb.append("sendCount=").append(this.sendCount);
        if (this.destinationReceived != null) {
            sb.append(",").append("rxdest=").append(this.destinationReceived);
        }
        sb.append("]");
        return sb.toString();
    }

    public SMFPubMsgHeaderBean getEncPubMsgHeader() {
        return this._encodingSmfPubMsgHeader;
    }

    @Override
    public Long getTopicSequenceNumber() {
        return this.topicSequenceNumber;
    }

    public void setTopicSequenceNumber(Long sequenceNumber) {
        this.topicSequenceNumber = sequenceNumber;
    }

    public ConsumerLargeMessageNotification getLargeMsgInfo() {
        return this.largeMsgInfo;
    }

    public void setLargeMsgInfo(ConsumerLargeMessageNotification largeMsgInfo) {
        this.largeMsgInfo = largeMsgInfo;
    }

    @Override
    public String getHTTPContentType() {
        if (this.hdrStore != null) {
            return this.hdrStore.getHTTPContentType();
        }
        return null;
    }

    @Override
    public void setHTTPContentType(String contentType) {
        this.checkReadOnlyBeforeModify();
        this.checkHdrStoreBeforeModify();
        this.hdrStore.setHTTPContentType(contentType);
    }

    @Override
    public String getHTTPContentEncoding() {
        if (this.hdrStore != null) {
            return this.hdrStore.getHTTPContentEncoding();
        }
        return null;
    }

    @Override
    public void setHTTPContentEncoding(String contentEncoding) {
        this.checkReadOnlyBeforeModify();
        this.checkHdrStoreBeforeModify();
        this.hdrStore.setHTTPContentEncoding(contentEncoding);
    }
}

