/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.impl;

import com.solacesystems.jms.impl.SolJMSErrorMessages;
import java.lang.reflect.Constructor;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSExceptionValue {
    private final Class<?>[] ctorArgs1 = new Class[]{String.class};
    private final Class<?>[] ctorArgs2 = new Class[]{String.class, String.class};
    private static final Log Trace = LogFactory.getLog(JMSExceptionValue.class);
    private Class<JMSException> mJMSExceptionClass;
    private String mErrorCode;
    private String mErrorText;

    public JMSExceptionValue(Class<JMSException> jmsExceptionClass, String errorCode, String errorText) {
        this.mJMSExceptionClass = jmsExceptionClass;
        this.mErrorCode = errorCode;
        this.mErrorText = errorText;
    }

    public JMSException newInstance(String operation, Throwable t) {
        JMSException returnEx;
        block5: {
            returnEx = null;
            String message = this.mErrorText == null ? SolJMSErrorMessages.getMessage(operation, this.mErrorCode, t.getMessage()) : SolJMSErrorMessages.getMessage(operation, this.mErrorCode, this.mErrorText);
            try {
                Constructor<JMSException> ctor = this.mJMSExceptionClass.getConstructor(this.ctorArgs2);
                Object[] initargs = new Object[]{message, this.mErrorCode};
                returnEx = ctor.newInstance(initargs);
            }
            catch (Exception e) {
                try {
                    Constructor<JMSException> ctor = this.mJMSExceptionClass.getConstructor(this.ctorArgs1);
                    Object[] initargs = new Object[]{message};
                    returnEx = ctor.newInstance(initargs);
                }
                catch (Exception e1) {
                    if (!Trace.isDebugEnabled()) break block5;
                    Trace.debug((Object)("got exception: " + e1.getMessage()));
                }
            }
        }
        if (returnEx != null && t instanceof Exception) {
            returnEx.setLinkedException((Exception)t);
        }
        return returnEx;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("jmsException=");
        if (this.mJMSExceptionClass == null) {
            bldr.append(this.mJMSExceptionClass);
        } else {
            bldr.append(this.mJMSExceptionClass.getName());
        }
        bldr.append(", errorCode=");
        bldr.append(this.mErrorCode);
        bldr.append(", errorText=");
        bldr.append(this.mErrorText);
        return bldr.toString();
    }
}

