/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.rest;

import com.speedment.common.rest.Header;
import com.speedment.common.rest.Option;
import com.speedment.common.rest.Param;
import com.speedment.common.rest.Response;
import com.speedment.common.rest.Rest;
import com.speedment.common.rest.RestException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class RestImpl
implements Rest {
    private static final StreamConsumer IGNORE = o -> {};
    private final Rest.Protocol protocol;
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private static final int BUFFER_SIZE = 1024;
    private static final Iterator<String> NO_ITERATOR = new Iterator<String>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public String next() {
            throw new NoSuchElementException("This method should never be called.");
        }
    };

    RestImpl(Rest.Protocol protocol, String host, int port, String username, String password) {
        this.protocol = Objects.requireNonNull(protocol);
        this.host = Objects.requireNonNull(host);
        this.port = port;
        this.username = username;
        this.password = password;
    }

    @Override
    public CompletableFuture<Response> get(String path, Option ... option) {
        return this.send(Rest.Method.GET, path, option);
    }

    @Override
    public CompletableFuture<Response> post(String path, Option ... option) {
        return this.send(Rest.Method.POST, path, option);
    }

    @Override
    public CompletableFuture<Response> delete(String path, Option ... option) {
        return this.send(Rest.Method.DELETE, path, option);
    }

    @Override
    public CompletableFuture<Response> put(String path, Option ... option) {
        return this.send(Rest.Method.PUT, path, option);
    }

    @Override
    public CompletableFuture<Response> options(String path, Option ... option) {
        return this.send(Rest.Method.OPTIONS, path, option);
    }

    @Override
    public CompletableFuture<Response> head(String path, Option ... option) {
        return this.send(Rest.Method.HEAD, path, option);
    }

    @Override
    public CompletableFuture<Response> get(String path, Iterator<String> uploader, Option ... option) {
        return this.send(Rest.Method.GET, path, option, uploader);
    }

    @Override
    public CompletableFuture<Response> post(String path, Iterator<String> uploader, Option ... option) {
        return this.send(Rest.Method.POST, path, option, uploader);
    }

    @Override
    public CompletableFuture<Response> delete(String path, Iterator<String> uploader, Option ... option) {
        return this.send(Rest.Method.DELETE, path, option, uploader);
    }

    @Override
    public CompletableFuture<Response> put(String path, Iterator<String> uploader, Option ... option) {
        return this.send(Rest.Method.PUT, path, option, uploader);
    }

    @Override
    public CompletableFuture<Response> options(String path, Iterator<String> uploader, Option ... option) {
        return this.send(Rest.Method.OPTIONS, path, option, uploader);
    }

    @Override
    public CompletableFuture<Response> head(String path, Iterator<String> uploader, Option ... option) {
        return this.send(Rest.Method.HEAD, path, option, uploader);
    }

    @Override
    public CompletableFuture<Response> get(String path, InputStream body, Option ... option) {
        return this.send(Rest.Method.GET, path, option, this.stream(body));
    }

    @Override
    public CompletableFuture<Response> post(String path, InputStream body, Option ... option) {
        return this.send(Rest.Method.POST, path, option, this.stream(body));
    }

    @Override
    public CompletableFuture<Response> delete(String path, InputStream body, Option ... option) {
        return this.send(Rest.Method.DELETE, path, option, this.stream(body));
    }

    @Override
    public CompletableFuture<Response> put(String path, InputStream body, Option ... option) {
        return this.send(Rest.Method.PUT, path, option, this.stream(body));
    }

    @Override
    public CompletableFuture<Response> options(String path, InputStream body, Option ... option) {
        return this.send(Rest.Method.OPTIONS, path, option, this.stream(body));
    }

    @Override
    public CompletableFuture<Response> head(String path, InputStream body, Option ... option) {
        return this.send(Rest.Method.HEAD, path, option, this.stream(body));
    }

    @Override
    public CompletableFuture<Response> get(String path, String data, Option ... option) {
        return this.send(Rest.Method.GET, path, option, new SingletonIterator<String>(data));
    }

    @Override
    public CompletableFuture<Response> post(String path, String data, Option ... option) {
        return this.send(Rest.Method.POST, path, option, new SingletonIterator<String>(data));
    }

    @Override
    public CompletableFuture<Response> delete(String path, String data, Option ... option) {
        return this.send(Rest.Method.DELETE, path, option, new SingletonIterator<String>(data));
    }

    @Override
    public CompletableFuture<Response> put(String path, String data, Option ... option) {
        return this.send(Rest.Method.PUT, path, option, new SingletonIterator<String>(data));
    }

    @Override
    public CompletableFuture<Response> options(String path, String data, Option ... option) {
        return this.send(Rest.Method.OPTIONS, path, option, new SingletonIterator<String>(data));
    }

    @Override
    public CompletableFuture<Response> head(String path, String data, Option ... option) {
        return this.send(Rest.Method.HEAD, path, option, new SingletonIterator<String>(data));
    }

    protected String getProtocol() {
        switch (this.protocol) {
            case HTTP: {
                return "http";
            }
            case HTTPS: {
                return "https";
            }
        }
        throw new UnsupportedOperationException(String.format("Unknown enum constant '%s'.", new Object[]{this.protocol}));
    }

    protected String getHost() {
        return this.host;
    }

    protected int getPort() {
        return this.port;
    }

    protected final URL getUrl(String path, Param ... param) {
        StringBuilder url = new StringBuilder().append(this.getProtocol()).append("://").append(this.host);
        if (this.port > 0) {
            url.append(":").append(this.port);
        }
        url.append("/").append(path);
        if (param.length > 0) {
            url.append(Stream.of(param).map(p -> Rest.encode(p.getKey()) + "=" + Rest.encode(p.getValue())).collect(Collectors.joining("&", "?", "")));
        }
        String urlStr = url.toString();
        try {
            return new URL(urlStr);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(String.format("Error building URL: '%s'.", urlStr), ex);
        }
    }

    private StreamConsumer stream(InputStream in) {
        return out -> {
            int len;
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        };
    }

    private CompletableFuture<Response> send(Rest.Method method, String path, Option[] options) {
        return this.send(method, path, options, NO_ITERATOR);
    }

    private CompletableFuture<Response> send(Rest.Method method, String path, Option[] options, Iterator<String> iterator) {
        if (iterator == NO_ITERATOR) {
            return this.send(method, path, options, IGNORE);
        }
        return this.send(method, path, options, (OutputStream out) -> {
            int i = 0;
            while (iterator.hasNext()) {
                String it = (String)iterator.next();
                if (it == null) {
                    throw new NullPointerException(String.format("Null element at position %d in iterator over strings.", i));
                }
                out.write(it.getBytes(StandardCharsets.UTF_8));
                ++i;
            }
        });
    }

    private CompletableFuture<Response> send(Rest.Method method, String path, Option[] options, StreamConsumer outStreamConsumer) {
        return CompletableFuture.supplyAsync(() -> {
            HttpURLConnection conn = null;
            try {
                Param[] params = (Param[])Stream.of(options).filter(o -> o.getType() == Option.Type.PARAM).map(Param.class::cast).toArray(Param[]::new);
                Header[] headers = (Header[])Stream.of(options).filter(o -> o.getType() == Option.Type.HEADER).map(Header.class::cast).toArray(Header[]::new);
                URL url = this.getUrl(path, params);
                conn = (HttpURLConnection)url.openConnection();
                switch (method) {
                    case POST: {
                        conn.setRequestMethod("POST");
                        break;
                    }
                    case GET: {
                        conn.setRequestMethod("GET");
                        break;
                    }
                    case DELETE: {
                        conn.setRequestMethod("DELETE");
                        break;
                    }
                    case OPTIONS: {
                        conn.setRequestMethod("OPTIONS");
                        break;
                    }
                    case PUT: {
                        conn.setRequestMethod("PUT");
                        break;
                    }
                    case HEAD: {
                        conn.setRequestMethod("HEAD");
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("Unknown enum constant '%s'.", new Object[]{method}));
                    }
                }
                if (this.username != null && this.password != null) {
                    byte[] byArray = (this.username + ":" + this.password).getBytes();
                    String encoding = Base64.getEncoder().encodeToString(byArray);
                    conn.setRequestProperty("Authorization", "Basic " + encoding);
                }
                for (Header header : headers) {
                    conn.setRequestProperty(header.getKey(), header.getValue());
                }
                conn.setUseCaches(false);
                conn.setAllowUserInteraction(false);
                boolean bl = outStreamConsumer != IGNORE;
                conn.setDoOutput(bl);
                conn.connect();
                if (bl) {
                    try (OutputStream out = conn.getOutputStream();){
                        outStreamConsumer.writeTo(out);
                        out.flush();
                    }
                }
                int status = RestImpl.getResponseCodeFrom(conn);
                String text = RestImpl.tryGetResponseTextFrom(conn, status);
                Response response = new Response(status, text, conn.getHeaderFields());
                return response;
            }
            catch (Exception ex) {
                throw new RestException(ex, this.protocol, method, this.username, this.host, this.port, path, options);
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        });
    }

    private static String tryGetResponseTextFrom(HttpURLConnection conn, int status) throws IOException {
        String text;
        try (BufferedReader rd = new BufferedReader(new InputStreamReader(status >= 400 ? conn.getErrorStream() : conn.getInputStream()));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                sb.append(line);
            }
            text = sb.toString();
        }
        return text;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (this.username != null) {
            str.append(this.username).append('@');
        }
        str.append(this.protocol.name().toLowerCase()).append("://");
        str.append(this.host);
        if (this.port > 0) {
            str.append(':').append(this.port);
        }
        return str.toString();
    }

    private static int getResponseCodeFrom(HttpURLConnection conn) throws IOException {
        try {
            return conn.getResponseCode();
        }
        catch (FileNotFoundException ex) {
            return 404;
        }
    }

    @FunctionalInterface
    private static interface StreamConsumer {
        public void writeTo(OutputStream var1) throws IOException;
    }

    private static final class SingletonIterator<E>
    implements Iterator<E> {
        private final E e;
        private boolean hasNext = true;

        private SingletonIterator(E e) {
            this.e = e;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public E next() {
            if (this.hasNext) {
                this.hasNext = false;
                return this.e;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            if (this.hasNext) {
                action.accept(this.e);
                this.hasNext = false;
            }
        }
    }
}

