/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.generator.standard.entity;

import com.speedment.common.codegen.constant.DefaultAnnotationUsage;
import com.speedment.common.codegen.constant.DefaultType;
import com.speedment.common.codegen.constant.SimpleParameterizedType;
import com.speedment.common.codegen.model.AnnotationUsage;
import com.speedment.common.codegen.model.Class;
import com.speedment.common.codegen.model.Constructor;
import com.speedment.common.codegen.model.Field;
import com.speedment.common.codegen.model.File;
import com.speedment.common.codegen.model.Import;
import com.speedment.common.codegen.model.Method;
import com.speedment.common.codegen.util.Formatting;
import com.speedment.common.injector.Injector;
import com.speedment.generator.standard.entity.GeneratedEntityTranslator;
import com.speedment.generator.standard.util.ColumnUtil;
import com.speedment.generator.standard.util.FkHolder;
import com.speedment.generator.standard.util.ForeignKeyUtil;
import com.speedment.generator.translator.AbstractEntityAndManagerTranslator;
import com.speedment.generator.translator.Translator;
import com.speedment.generator.translator.TranslatorSupport;
import com.speedment.runtime.config.Column;
import com.speedment.runtime.config.ForeignKey;
import com.speedment.runtime.config.Table;
import com.speedment.runtime.config.trait.HasAlias;
import com.speedment.runtime.config.trait.HasTypeMapper;
import com.speedment.runtime.core.manager.Manager;
import com.speedment.runtime.core.util.OptionalUtil;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public final class GeneratedEntityImplTranslator
extends AbstractEntityAndManagerTranslator<Class> {
    public GeneratedEntityImplTranslator(Injector injector, Table table) {
        super(injector, table, Class::of);
    }

    protected Class makeCodeGenModel(File file) {
        Objects.requireNonNull(file);
        return (Class)this.newBuilder(file, this.getSupport().generatedEntityImplName()).forEveryTable((clazz, table) -> ((Class)((Class)((Class)clazz.public_()).abstract_()).add(this.getSupport().entityType())).add((Constructor)Constructor.of().protected_())).forEveryColumn((clazz, col) -> this.addGetterTo(file, (Class)clazz, (Column)col)).forEveryColumn(this::addSetterTo).forEveryColumn((clazz, col) -> this.addFindersTo(file, (Class)clazz, (Column)col)).forEveryTable(Translator.Phase.POST_MAKE, (clazz, table) -> ((Class)((Class)clazz.add(this.toStringMethod(file))).add(this.equalsMethod())).add(this.hashCodeMethod(file))).build();
    }

    private void addFindersTo(File file, Class clazz, Column col) {
        ForeignKeyUtil.getForeignKey(this.getSupport().tableOrThrow(), col).ifPresent(fkc -> {
            FkHolder fu = new FkHolder(this.injector(), (ForeignKey)fkc.getParentOrThrow());
            TranslatorSupport fuSupport = fu.getForeignEmt().getSupport();
            file.add(Import.of((Type)fuSupport.entityType()));
            String isPresentName = ColumnUtil.usesOptional(col) ? ".isPresent()" : " != null";
            String getterName = ColumnUtil.optionalGetterName(this.typeMappers(), col).orElse("");
            clazz.add((Method)((Method)((Method)((Method)Method.of((String)("find" + this.getSupport().typeName((HasAlias)col)), (Type)(col.isNullable() ? DefaultType.optional((Type)fuSupport.entityType()) : fuSupport.entityType())).public_()).add((AnnotationUsage)DefaultAnnotationUsage.OVERRIDE)).add(Field.of((String)"foreignManager", (Type)SimpleParameterizedType.create(Manager.class, (Type[])new Type[]{fuSupport.entityType()})))).add(col.isNullable() ? "if (get" + this.getSupport().namer().javaTypeName(col.getJavaName()) + "()" + isPresentName + ") " + Formatting.block((String)("return foreignManager.stream().filter(" + fuSupport.entityName() + "." + fuSupport.namer().javaStaticFieldName(fu.getForeignColumn().getJavaName()) + ".equal(" + "get" + this.getSupport().namer().javaTypeName(col.getJavaName()) + "()" + getterName + ")).findAny();")) + " else " + Formatting.block((String)"return Optional.empty();") : "return foreignManager.stream().filter(" + fuSupport.entityName() + "." + fuSupport.namer().javaStaticFieldName(fu.getForeignColumn().getJavaName()) + ".equal(" + "get" + this.getSupport().namer().javaTypeName(col.getJavaName()) + "()" + getterName + ")).findAny().orElse(null);"));
        });
    }

    private Class addSetterTo(Class clazz, Column col) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(col);
        return (Class)clazz.add((Method)((Method)((Method)((Method)((Method)Method.of((String)("set" + this.getSupport().typeName((HasAlias)col)), (Type)this.getSupport().entityType()).public_()).add((AnnotationUsage)DefaultAnnotationUsage.OVERRIDE)).add(this.fieldFor(col))).add("this." + this.getSupport().variableName((HasAlias)col) + " = " + this.getSupport().variableName((HasAlias)col) + ";")).add("return this;"));
    }

    private void addGetterTo(File file, Class clazz, Column col) {
        String getter;
        Objects.requireNonNull(file);
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(col);
        Type retType = GeneratedEntityTranslator.getterReturnType(this.typeMappers(), col);
        if (ColumnUtil.usesOptional(col)) {
            String varName = this.getSupport().variableName((HasAlias)col);
            if (retType.getTypeName().equals(Optional.class.getName())) {
                getter = "Optional.ofNullable(" + varName + ")";
            } else {
                file.add(Import.of(OptionalUtil.class));
                getter = "OptionalUtil.ofNullable(" + varName + ")";
            }
        } else {
            getter = this.getSupport().variableName((HasAlias)col);
        }
        ((Class)clazz.add((Field)this.fieldFor(col).private_())).add((Method)((Method)((Method)Method.of((String)("get" + this.getSupport().typeName((HasAlias)col)), (Type)retType).public_()).add((AnnotationUsage)DefaultAnnotationUsage.OVERRIDE)).add("return " + getter + ";"));
    }

    private Method toStringMethod(File file) {
        file.add(Import.of(StringJoiner.class));
        file.add(Import.of(Objects.class));
        Method m = (Method)((Method)((Method)Method.of((String)"toString", String.class).public_()).add((AnnotationUsage)DefaultAnnotationUsage.OVERRIDE)).add("final StringJoiner sj = new StringJoiner(\", \", \"{ \", \" }\");");
        this.columns().forEachOrdered(col -> {
            String getter;
            if (ColumnUtil.usesOptional(col)) {
                file.add(Import.of(OptionalUtil.class));
                getter = "OptionalUtil.unwrap(get" + this.getSupport().typeName((HasAlias)col) + "())";
            } else {
                getter = "get" + this.getSupport().typeName((HasAlias)col) + "()";
            }
            m.add("sj.add(\"" + this.getSupport().variableName((HasAlias)col) + " = \" \t+ Objects.toString(" + getter + "));");
        });
        m.add("return \"" + this.getSupport().entityImplName() + " \" + sj.toString();");
        return m;
    }

    private Method equalsMethod() {
        String thatName = "that";
        String thatCastedName = "that" + this.getSupport().entityName();
        Method method = (Method)((Method)((Method)((Method)((Method)((Method)Method.of((String)"equals", Boolean.TYPE).public_()).add((AnnotationUsage)DefaultAnnotationUsage.OVERRIDE)).add(Field.of((String)"that", Object.class))).add("if (this == that) { return true; }")).add("if (!(that instanceof " + this.getSupport().entityName() + ")) { return false; }")).add("final " + this.getSupport().entityName() + " " + thatCastedName + " = (" + this.getSupport().entityName() + ")" + "that" + ";");
        this.columns().forEachOrdered(c -> {
            String getter = "get" + this.getSupport().typeName((HasAlias)c);
            Type type = this.typeMappers().get((HasTypeMapper)c).getJavaType(c);
            if (ColumnUtil.usesOptional(c) || !DefaultType.isPrimitive((Type)type)) {
                method.add("if (!Objects.equals(this." + getter + "(), " + thatCastedName + "." + getter + "())) { return false; }");
            } else {
                method.add("if (this." + getter + "() != " + thatCastedName + "." + getter + "()) { return false; }");
            }
        });
        method.add("return true;");
        return method;
    }

    private Method hashCodeMethod(File file) {
        Method method = (Method)((Method)((Method)Method.of((String)"hashCode", Integer.TYPE).public_()).add((AnnotationUsage)DefaultAnnotationUsage.OVERRIDE)).add("int hash = 7;");
        this.columns().forEachOrdered(c -> {
            StringBuilder str = new StringBuilder();
            str.append("hash = 31 * hash + ");
            Type type = this.typeMappers().get((HasTypeMapper)c).getJavaType(c);
            if (!ColumnUtil.usesOptional(c) && DefaultType.isPrimitive((Type)type)) {
                str.append(DefaultType.wrapperFor((Type)type).getSimpleName());
            } else {
                str.append("Objects");
            }
            str.append(".hashCode(");
            if (ColumnUtil.usesOptional(c)) {
                file.add(Import.of(OptionalUtil.class));
                str.append("OptionalUtil.unwrap(");
            }
            str.append("get").append(this.getSupport().typeName((HasAlias)c)).append("()");
            if (ColumnUtil.usesOptional(c)) {
                str.append(')');
            }
            str.append(");");
            method.add(str.toString());
        });
        method.add("return hash;");
        return method;
    }

    protected String getJavadocRepresentText() {
        return "The generated base implementation of the {@link " + this.getSupport().entityType().getTypeName() + "}-interface.";
    }

    protected String getClassOrInterfaceName() {
        return this.getSupport().generatedEntityImplName();
    }

    public boolean isInGeneratedPackage() {
        return true;
    }
}

