/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.generator.standard.entity;

import com.speedment.common.codegen.constant.DefaultAnnotationUsage;
import com.speedment.common.codegen.constant.DefaultJavadocTag;
import com.speedment.common.codegen.constant.DefaultType;
import com.speedment.common.codegen.constant.SimpleParameterizedType;
import com.speedment.common.codegen.constant.SimpleType;
import com.speedment.common.codegen.model.AnnotationUsage;
import com.speedment.common.codegen.model.ClassOrInterface;
import com.speedment.common.codegen.model.Constructor;
import com.speedment.common.codegen.model.Enum;
import com.speedment.common.codegen.model.EnumConstant;
import com.speedment.common.codegen.model.Field;
import com.speedment.common.codegen.model.File;
import com.speedment.common.codegen.model.Import;
import com.speedment.common.codegen.model.Interface;
import com.speedment.common.codegen.model.Javadoc;
import com.speedment.common.codegen.model.Method;
import com.speedment.common.codegen.model.Value;
import com.speedment.common.codegen.util.Formatting;
import com.speedment.common.function.OptionalBoolean;
import com.speedment.common.injector.Injector;
import com.speedment.generator.standard.util.ColumnUtil;
import com.speedment.generator.standard.util.FkHolder;
import com.speedment.generator.standard.util.ForeignKeyUtil;
import com.speedment.generator.translator.AbstractEntityAndManagerTranslator;
import com.speedment.generator.translator.TranslatorSupport;
import com.speedment.runtime.config.Column;
import com.speedment.runtime.config.Dbms;
import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.ForeignKey;
import com.speedment.runtime.config.Table;
import com.speedment.runtime.config.identifier.ColumnIdentifier;
import com.speedment.runtime.config.identifier.TableIdentifier;
import com.speedment.runtime.config.trait.HasAlias;
import com.speedment.runtime.config.trait.HasTypeMapper;
import com.speedment.runtime.config.util.DocumentDbUtil;
import com.speedment.runtime.config.util.DocumentUtil;
import com.speedment.runtime.core.manager.Manager;
import com.speedment.runtime.core.util.OptionalUtil;
import com.speedment.runtime.typemapper.TypeMapper;
import com.speedment.runtime.typemapper.TypeMapperComponent;
import com.speedment.runtime.typemapper.primitive.PrimitiveTypeMapper;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class GeneratedEntityTranslator
extends AbstractEntityAndManagerTranslator<Interface> {
    private static final String IDENTIFIER_NAME = "Identifier";
    private static final String OF_THIS = " of this ";
    private static final Map<Type, Type> OPTIONAL_MAPPING = Stream.of(new AbstractMap.SimpleImmutableEntry<Class<Integer>, Class<OptionalInt>>(Integer.TYPE, OptionalInt.class), new AbstractMap.SimpleImmutableEntry<Class<Long>, Class<OptionalLong>>(Long.TYPE, OptionalLong.class), new AbstractMap.SimpleImmutableEntry<Class<Double>, Class<OptionalDouble>>(Double.TYPE, OptionalDouble.class), new AbstractMap.SimpleImmutableEntry<Class<Boolean>, Class<OptionalBoolean>>(Boolean.TYPE, OptionalBoolean.class), new AbstractMap.SimpleImmutableEntry<Class<Integer>, Class<OptionalInt>>(Integer.class, OptionalInt.class), new AbstractMap.SimpleImmutableEntry<Class<Long>, Class<OptionalLong>>(Long.class, OptionalLong.class), new AbstractMap.SimpleImmutableEntry<Class<Double>, Class<OptionalDouble>>(Double.class, OptionalDouble.class), new AbstractMap.SimpleImmutableEntry<Class<Boolean>, Class<OptionalBoolean>>(Boolean.class, OptionalBoolean.class)).collect(Collectors.collectingAndThen(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue), Collections::unmodifiableMap));

    public GeneratedEntityTranslator(Injector injector, Table table) {
        super(injector, table, Interface::of);
    }

    protected Interface makeCodeGenModel(File file) {
        SimpleParameterizedType tableIdentifierType = SimpleParameterizedType.create(TableIdentifier.class, (Type[])new Type[]{this.getSupport().entityType()});
        Enum identifierEnum = (Enum)((Enum)((Enum)((Enum)((Enum)((Enum)((Enum)((Enum)((Enum)Enum.of((String)IDENTIFIER_NAME).add((Field)((Field)Field.of((String)"columnId", String.class).private_()).final_())).add((Field)((Field)Field.of((String)"tableIdentifier", (Type)tableIdentifierType).private_()).final_())).add((Type)SimpleParameterizedType.create(ColumnIdentifier.class, (Type[])new Type[]{this.getSupport().entityType()}))).add((Constructor)((Constructor)((Constructor)Constructor.of().add(Field.of((String)"columnId", String.class))).add("this.columnId\t = columnId;")).add("this.tableIdentifier\t = TableIdentifier.of(" + Formatting.indent((String[])new String[]{"getDbmsId(), ", "getSchemaId(), ", "getTableId()"}) + ");"))).add((Method)((Method)((Method)Method.of((String)"getDbmsId", String.class).public_()).add((AnnotationUsage)DefaultAnnotationUsage.OVERRIDE)).add(this.returnString(this.getSupport().dbmsOrThrow().getId())))).add((Method)((Method)((Method)Method.of((String)"getSchemaId", String.class).public_()).add((AnnotationUsage)DefaultAnnotationUsage.OVERRIDE)).add(this.returnString(this.getSupport().schemaOrThrow().getId())))).add((Method)((Method)((Method)Method.of((String)"getTableId", String.class).public_()).add((AnnotationUsage)DefaultAnnotationUsage.OVERRIDE)).add(this.returnString(this.getSupport().tableOrThrow().getId())))).add((Method)((Method)((Method)Method.of((String)"getColumnId", String.class).public_()).add((AnnotationUsage)DefaultAnnotationUsage.OVERRIDE)).add("return this.columnId;"))).add((Method)((Method)((Method)Method.of((String)"asTableIdentifier", (Type)tableIdentifierType).public_()).add((AnnotationUsage)DefaultAnnotationUsage.OVERRIDE)).add("return this.tableIdentifier;"));
        return (Interface)this.newBuilder(file, this.getSupport().generatedEntityName()).forEveryTable((intrf, col) -> ((Interface)intrf.public_()).add((ClassOrInterface)identifierEnum)).forEveryColumn(this::addGetterMethod).forEveryColumn(this::addSetterMethod).forEveryColumn((inter, col) -> this.addIfForeignKey(file, (Interface)inter, (Column)col)).forEveryColumn((inter, col) -> this.addField(file, identifierEnum, (Interface)inter, (Column)col)).build();
    }

    private void addField(File file, Enum identifierEnum, Interface intrf, Column col) {
        ForeignKeyUtil.ReferenceFieldType ref = ForeignKeyUtil.getReferenceFieldType(file, this.getSupport().tableOrThrow(), col, this.getSupport().entityType(), this.injector());
        Type entityType = this.getSupport().entityType();
        String shortEntityName = this.getSupport().entityName();
        file.add(Import.of((Type)entityType));
        String constant = this.getSupport().namer().javaStaticFieldName(col.getJavaName());
        identifierEnum.add(EnumConstant.of((String)constant).add((Value)Value.ofText((String)col.getId())));
        ArrayList<Object> fieldParams = new ArrayList<Object>();
        fieldParams.add(Value.ofReference((String)("Identifier." + constant)));
        if (ColumnUtil.usesOptional(col)) {
            fieldParams.add(Value.ofReference((String)("o -> OptionalUtil.unwrap(o.get" + this.getSupport().typeName((HasAlias)col) + "())")));
            file.add(Import.of(OptionalUtil.class));
        } else {
            fieldParams.add(Value.ofReference((String)(shortEntityName + "::get" + this.getSupport().typeName((HasAlias)col))));
        }
        fieldParams.add(Value.ofReference((String)(shortEntityName + "::" + "set" + this.getSupport().typeName((HasAlias)col))));
        ForeignKeyUtil.getForeignKey(this.getSupport().tableOrThrow(), col).ifPresent(fkc -> {
            FkHolder fu = new FkHolder(this.injector(), (ForeignKey)fkc.getParentOrThrow());
            TranslatorSupport fuSupport = fu.getForeignEmt().getSupport();
            fieldParams.add(Value.ofReference((String)(fuSupport.entityName() + "." + fuSupport.namer().javaStaticFieldName(fu.getForeignColumn().getJavaName()))));
        });
        Optional oTypemapper = col.getTypeMapper();
        if (oTypemapper.isPresent()) {
            String typeMapper = (String)oTypemapper.get();
            if (PrimitiveTypeMapper.class.getName().equals(typeMapper)) {
                file.add(Import.of(TypeMapper.class));
                fieldParams.add(Value.ofReference((String)"TypeMapper.primitive()"));
            } else {
                file.add(Import.of((Type)SimpleType.create((String)typeMapper)));
                fieldParams.add(Value.ofReference((String)("new " + Formatting.shortName((String)typeMapper) + "()")));
            }
        } else {
            fieldParams.add(Value.ofReference((String)"TypeMapper.identity()"));
            file.add(Import.of(TypeMapper.class));
        }
        fieldParams.add(Value.ofBoolean((Boolean)DocumentDbUtil.isUnique((Column)col)));
        intrf.add((Field)((Field)((Field)Field.of((String)this.getSupport().namer().javaStaticFieldName(col.getJavaName()), (Type)ref.getType()).final_()).set((Value)Value.ofInvocation((Type)ref.getType(), (String)"create", (Value[])fieldParams.toArray(new Value[0])))).set(Javadoc.of((String)("This Field corresponds to the {@link " + shortEntityName + "} field that can be obtained using the {@link " + shortEntityName + "#get" + this.getSupport().typeName((HasAlias)col) + "()} method."))));
    }

    private void addIfForeignKey(File file, Interface intrf, Column col) {
        ForeignKeyUtil.getForeignKey(this.getSupport().tableOrThrow(), col).ifPresent(fkc -> {
            FkHolder fu = new FkHolder(this.injector(), (ForeignKey)fkc.getParentOrThrow());
            TranslatorSupport fuSupport = fu.getForeignEmt().getSupport();
            file.add(Import.of((Type)fuSupport.entityType()));
            intrf.add((Method)((Method)Method.of((String)("find" + this.getSupport().typeName((HasAlias)col)), (Type)(col.isNullable() ? DefaultType.optional((Type)fuSupport.entityType()) : fuSupport.entityType())).set((Javadoc)((Javadoc)Javadoc.of((String)("Queries the specified manager for the referenced " + fuSupport.entityName() + ". If no such " + fuSupport.entityName() + " exists, an {@code NullPointerException} will be thrown.")).add(DefaultJavadocTag.PARAM.setValue("foreignManager").setText("the manager to query for the entity"))).add(DefaultJavadocTag.RETURN.setText("the foreign entity referenced")))).add(Field.of((String)"foreignManager", (Type)SimpleParameterizedType.create(Manager.class, (Type[])new Type[]{fuSupport.entityType()}))));
        });
    }

    private Interface addSetterMethod(Interface intrf, Column col) {
        return (Interface)intrf.add((Method)((Method)Method.of((String)("set" + this.getSupport().typeName((HasAlias)col)), (Type)this.getSupport().entityType()).add(Field.of((String)this.getSupport().variableName((HasAlias)col), (Type)this.typeMappers().get((HasTypeMapper)col).getJavaType(col)))).set((Javadoc)((Javadoc)Javadoc.of((String)("Sets the " + this.getSupport().variableName((HasAlias)col) + OF_THIS + this.getSupport().entityName() + ". The " + this.getSupport().variableName((HasAlias)col) + " field corresponds to the database column " + DocumentUtil.relativeName((Document)col, Dbms.class, (DocumentUtil.Name)DocumentUtil.Name.DATABASE_NAME) + ".")).add(DefaultJavadocTag.PARAM.setValue(this.getSupport().variableName((HasAlias)col)).setText("to set of this " + this.getSupport().entityName()))).add(DefaultJavadocTag.RETURN.setText("this " + this.getSupport().entityName() + " instance"))));
    }

    private void addGetterMethod(Interface intrf, Column col) {
        Type retType = GeneratedEntityTranslator.getterReturnType(this.typeMappers(), col);
        intrf.add((Method)Method.of((String)("get" + this.getSupport().typeName((HasAlias)col)), (Type)retType).set((Javadoc)Javadoc.of((String)("Returns the " + this.getSupport().variableName((HasAlias)col) + OF_THIS + this.getSupport().entityName() + ". The " + this.getSupport().variableName((HasAlias)col) + " field corresponds to the database column " + DocumentUtil.relativeName((Document)col, Dbms.class, (DocumentUtil.Name)DocumentUtil.Name.DATABASE_NAME) + ".")).add(DefaultJavadocTag.RETURN.setText("the " + this.getSupport().variableName((HasAlias)col) + OF_THIS + this.getSupport().entityName()))));
    }

    protected String getJavadocRepresentText() {
        return "The generated base for the {@link " + this.getSupport().entityType().getTypeName() + "}-interface representing entities of the {@code " + ((Table)this.getDocument()).getId() + "}-table in the database.";
    }

    protected String getClassOrInterfaceName() {
        return this.getSupport().generatedEntityName();
    }

    public boolean isInGeneratedPackage() {
        return true;
    }

    static Type getterReturnType(TypeMapperComponent typeMappers, Column col) {
        Type type = typeMappers.get((HasTypeMapper)col).getJavaType(col);
        if (ColumnUtil.usesOptional(col)) {
            if (DefaultType.isPrimitive((Type)type)) {
                return OPTIONAL_MAPPING.getOrDefault(type, DefaultType.optional((Type)DefaultType.wrapperFor((Type)type)));
            }
            return OPTIONAL_MAPPING.getOrDefault(type, DefaultType.optional((Type)type));
        }
        return type;
    }

    private String returnString(String s) {
        Objects.requireNonNull(s);
        return "return \"" + s + "\";";
    }
}

