/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.generator.standard.internal.util;

import com.speedment.common.codegen.constant.SimpleParameterizedType;
import com.speedment.common.codegen.constant.SimpleType;
import com.speedment.common.codegen.model.File;
import com.speedment.common.codegen.model.Import;
import com.speedment.common.injector.Injector;
import com.speedment.generator.standard.util.ForeignKeyUtil;
import com.speedment.generator.translator.TranslatorSupport;
import com.speedment.runtime.config.Column;
import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.ForeignKey;
import com.speedment.runtime.config.ForeignKeyColumn;
import com.speedment.runtime.config.Table;
import com.speedment.runtime.config.trait.HasEnabled;
import com.speedment.runtime.config.trait.HasTypeMapper;
import com.speedment.runtime.config.util.DocumentDbUtil;
import com.speedment.runtime.core.exception.SpeedmentException;
import com.speedment.runtime.field.BooleanField;
import com.speedment.runtime.field.ByteField;
import com.speedment.runtime.field.ByteForeignKeyField;
import com.speedment.runtime.field.CharField;
import com.speedment.runtime.field.CharForeignKeyField;
import com.speedment.runtime.field.ComparableField;
import com.speedment.runtime.field.ComparableForeignKeyField;
import com.speedment.runtime.field.DoubleField;
import com.speedment.runtime.field.DoubleForeignKeyField;
import com.speedment.runtime.field.EnumField;
import com.speedment.runtime.field.EnumForeignKeyField;
import com.speedment.runtime.field.FloatField;
import com.speedment.runtime.field.FloatForeignKeyField;
import com.speedment.runtime.field.IntField;
import com.speedment.runtime.field.IntForeignKeyField;
import com.speedment.runtime.field.LongField;
import com.speedment.runtime.field.LongForeignKeyField;
import com.speedment.runtime.field.ReferenceField;
import com.speedment.runtime.field.ShortField;
import com.speedment.runtime.field.ShortForeignKeyField;
import com.speedment.runtime.field.StringField;
import com.speedment.runtime.field.StringForeignKeyField;
import com.speedment.runtime.typemapper.TypeMapper;
import com.speedment.runtime.typemapper.TypeMapperComponent;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;

public final class InternalForeignKeyUtil {
    private InternalForeignKeyUtil() {
    }

    public static ForeignKeyUtil.ReferenceFieldType getReferenceFieldType(File file, Table table, Column column, Type entityType, Injector injector) {
        Objects.requireNonNull(file);
        Objects.requireNonNull(table);
        Objects.requireNonNull(column);
        Objects.requireNonNull(entityType);
        Objects.requireNonNull(injector);
        TypeMapper tm = ((TypeMapperComponent)injector.getOrThrow(TypeMapperComponent.class)).get((HasTypeMapper)column);
        Type javaType = tm.getJavaType(column);
        SimpleType databaseType = SimpleType.create((String)column.getDatabaseType());
        TypeMapper.Category category = tm.getJavaTypeCategory(column);
        return ForeignKeyUtil.getForeignKey(table, column).map(arg_0 -> InternalForeignKeyUtil.lambda$getReferenceFieldType$1(injector, file, category, entityType, (Type)databaseType, javaType, arg_0)).orElseGet(() -> InternalForeignKeyUtil.lambda$getReferenceFieldType$2(category, entityType, (Type)databaseType, javaType));
    }

    public static Optional<? extends ForeignKeyColumn> getForeignKey(Table table, Column column) {
        Objects.requireNonNull(table);
        Objects.requireNonNull(column);
        return table.foreignKeys().filter(HasEnabled::test).filter(fk -> fk.foreignKeyColumns().count() == 1L).flatMap(ForeignKey::foreignKeyColumns).filter(fkc -> fkc.findForeignTable().map(HasEnabled::isEnabled).orElse(false)).filter(fkc -> fkc.findForeignColumn().map(HasEnabled::isEnabled).orElse(false)).filter(fkc -> DocumentDbUtil.isSame((Column)column, (Column)fkc.findColumn().orElse(null))).findFirst();
    }

    private static /* synthetic */ ForeignKeyUtil.ReferenceFieldType lambda$getReferenceFieldType$2(TypeMapper.Category category, Type entityType, Type databaseType, Type javaType) {
        SimpleParameterizedType type;
        switch (category) {
            case STRING: {
                type = SimpleParameterizedType.create(StringField.class, (Type[])new Type[]{entityType, databaseType});
                break;
            }
            case BYTE: {
                type = SimpleParameterizedType.create(ByteField.class, (Type[])new Type[]{entityType, databaseType});
                break;
            }
            case SHORT: {
                type = SimpleParameterizedType.create(ShortField.class, (Type[])new Type[]{entityType, databaseType});
                break;
            }
            case INT: {
                type = SimpleParameterizedType.create(IntField.class, (Type[])new Type[]{entityType, databaseType});
                break;
            }
            case LONG: {
                type = SimpleParameterizedType.create(LongField.class, (Type[])new Type[]{entityType, databaseType});
                break;
            }
            case FLOAT: {
                type = SimpleParameterizedType.create(FloatField.class, (Type[])new Type[]{entityType, databaseType});
                break;
            }
            case DOUBLE: {
                type = SimpleParameterizedType.create(DoubleField.class, (Type[])new Type[]{entityType, databaseType});
                break;
            }
            case CHAR: {
                type = SimpleParameterizedType.create(CharField.class, (Type[])new Type[]{entityType, databaseType});
                break;
            }
            case BOOLEAN: {
                type = SimpleParameterizedType.create(BooleanField.class, (Type[])new Type[]{entityType, databaseType});
                break;
            }
            case ENUM: {
                type = SimpleParameterizedType.create(EnumField.class, (Type[])new Type[]{entityType, databaseType, javaType});
                break;
            }
            case COMPARABLE: {
                type = SimpleParameterizedType.create(ComparableField.class, (Type[])new Type[]{entityType, databaseType, javaType});
                break;
            }
            case REFERENCE: {
                type = SimpleParameterizedType.create(ReferenceField.class, (Type[])new Type[]{entityType, databaseType, javaType});
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown enum constant '" + category + "'.");
            }
        }
        return new ForeignKeyUtil.ReferenceFieldType((Type)type);
    }

    private static /* synthetic */ ForeignKeyUtil.ReferenceFieldType lambda$getReferenceFieldType$1(Injector injector, File file, TypeMapper.Category category, Type entityType, Type databaseType, Type javaType, ForeignKeyColumn fkc) {
        SimpleParameterizedType type;
        Type fkType = new TranslatorSupport(injector, (Document)((Table)fkc.findForeignTable().orElseThrow(() -> new SpeedmentException("Could not find referenced foreign table '" + fkc.getForeignTableName() + "'.")))).entityType();
        file.add(Import.of((Type)fkType));
        switch (category) {
            case STRING: {
                type = SimpleParameterizedType.create(StringForeignKeyField.class, (Type[])new Type[]{entityType, databaseType, fkType});
                break;
            }
            case BYTE: {
                type = SimpleParameterizedType.create(ByteForeignKeyField.class, (Type[])new Type[]{entityType, databaseType, fkType});
                break;
            }
            case SHORT: {
                type = SimpleParameterizedType.create(ShortForeignKeyField.class, (Type[])new Type[]{entityType, databaseType, fkType});
                break;
            }
            case INT: {
                type = SimpleParameterizedType.create(IntForeignKeyField.class, (Type[])new Type[]{entityType, databaseType, fkType});
                break;
            }
            case LONG: {
                type = SimpleParameterizedType.create(LongForeignKeyField.class, (Type[])new Type[]{entityType, databaseType, fkType});
                break;
            }
            case FLOAT: {
                type = SimpleParameterizedType.create(FloatForeignKeyField.class, (Type[])new Type[]{entityType, databaseType, fkType});
                break;
            }
            case DOUBLE: {
                type = SimpleParameterizedType.create(DoubleForeignKeyField.class, (Type[])new Type[]{entityType, databaseType, fkType});
                break;
            }
            case CHAR: {
                type = SimpleParameterizedType.create(CharForeignKeyField.class, (Type[])new Type[]{entityType, databaseType, fkType});
                break;
            }
            case ENUM: {
                type = SimpleParameterizedType.create(EnumForeignKeyField.class, (Type[])new Type[]{entityType, databaseType, javaType, fkType});
                break;
            }
            case BOOLEAN: {
                throw new UnsupportedOperationException("Boolean foreign key fields are not supported.");
            }
            case COMPARABLE: {
                type = SimpleParameterizedType.create(ComparableForeignKeyField.class, (Type[])new Type[]{entityType, databaseType, javaType, fkType});
                break;
            }
            case REFERENCE: {
                throw new UnsupportedOperationException("Foreign key types that are not either primitive or comparable are not supported.");
            }
            default: {
                throw new UnsupportedOperationException("Unknown enum constant '" + category + "'.");
            }
        }
        return new ForeignKeyUtil.ReferenceFieldType((Type)type);
    }
}

