/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.generator.standard.lifecycle;

import com.speedment.common.codegen.constant.DefaultAnnotationUsage;
import com.speedment.common.codegen.constant.DefaultJavadocTag;
import com.speedment.common.codegen.constant.SimpleParameterizedType;
import com.speedment.common.codegen.constant.SimpleType;
import com.speedment.common.codegen.model.AnnotationUsage;
import com.speedment.common.codegen.model.Constructor;
import com.speedment.common.codegen.model.Field;
import com.speedment.common.codegen.model.File;
import com.speedment.common.codegen.model.Import;
import com.speedment.common.codegen.model.Javadoc;
import com.speedment.common.codegen.model.Method;
import com.speedment.common.codegen.util.Formatting;
import com.speedment.common.injector.InjectBundle;
import com.speedment.common.injector.Injector;
import com.speedment.common.mapstream.MapStream;
import com.speedment.generator.translator.AbstractJavaClassTranslator;
import com.speedment.generator.translator.TranslatorSupport;
import com.speedment.runtime.application.AbstractApplicationBuilder;
import com.speedment.runtime.config.Dbms;
import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.Project;
import com.speedment.runtime.config.Table;
import com.speedment.runtime.config.trait.HasEnabled;
import com.speedment.runtime.config.trait.HasId;
import com.speedment.runtime.config.util.DocumentDbUtil;
import com.speedment.runtime.connector.mariadb.MariaDbBundle;
import com.speedment.runtime.connector.mysql.MySqlBundle;
import com.speedment.runtime.connector.postgres.PostgresBundle;
import com.speedment.runtime.connector.sqlite.SqliteBundle;
import com.speedment.runtime.core.exception.SpeedmentException;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class GeneratedApplicationBuilderTranslator
extends AbstractJavaClassTranslator<Project, com.speedment.common.codegen.model.Class> {
    private static final String CLASS = "class";

    public GeneratedApplicationBuilderTranslator(Injector injector, Project doc) {
        super(injector, (Document)doc, com.speedment.common.codegen.model.Class::of);
    }

    public boolean isInGeneratedPackage() {
        return true;
    }

    protected com.speedment.common.codegen.model.Class makeCodeGenModel(File file) {
        Objects.requireNonNull(file);
        return (com.speedment.common.codegen.model.Class)this.newBuilder(file, this.getClassOrInterfaceName()).forEveryProject((clazz, project) -> {
            Map<String, List<Table>> nameMap = DocumentDbUtil.traverseOver((Project)project, Table.class).filter(HasEnabled::test).collect(Collectors.groupingBy(HasId::getId));
            Set ambiguousNames = MapStream.of(nameMap).filterValue(l -> l.size() > 1).keys().collect(Collectors.toSet());
            LinkedList managerImpls = new LinkedList();
            LinkedList sqlAdapters = new LinkedList();
            DocumentDbUtil.traverseOver((Project)project, Table.class).filter(HasEnabled::test).forEachOrdered(t -> {
                TranslatorSupport support = new TranslatorSupport(this.injector(), (Document)t);
                Type managerImplType = support.managerImplType();
                Type sqlAdapterType = support.sqlAdapterType();
                if (ambiguousNames.contains(t.getId())) {
                    managerImpls.add(managerImplType.getTypeName());
                    sqlAdapters.add(sqlAdapterType.getTypeName());
                } else {
                    file.add(Import.of((Type)managerImplType));
                    file.add(Import.of((Type)sqlAdapterType));
                    managerImpls.add(Formatting.shortName((String)managerImplType.getTypeName()));
                    sqlAdapters.add(Formatting.shortName((String)sqlAdapterType.getTypeName()));
                }
            });
            file.add(Import.of((Type)this.applicationType()));
            file.add(Import.of((Type)this.applicationImplType()));
            Method build = (Method)((Method)((Method)((Method)Method.of((String)"build", (Type)this.applicationType()).public_()).add((AnnotationUsage)DefaultAnnotationUsage.OVERRIDE)).add(Field.of((String)"injector", Injector.class))).add("return injector.getOrThrow(" + this.getSupport().typeName(this.getSupport().projectOrThrow()) + "Application." + CLASS + ");");
            Constructor constr = (Constructor)Constructor.of().protected_();
            StringBuilder constructorBody = new StringBuilder("super(");
            constructorBody.append(this.getSupport().typeName(this.getSupport().projectOrThrow())).append("ApplicationImpl.class, ");
            constructorBody.append("Generated").append(this.getSupport().typeName(this.getSupport().projectOrThrow())).append("Metadata").append(".class);").append(Formatting.nl());
            String separator = Formatting.nl();
            if (!managerImpls.isEmpty()) {
                constructorBody.append(managerImpls.stream().map(s -> "withManager(" + s + "." + CLASS + ");").collect(Collectors.joining(separator, "", separator)));
            }
            if (!sqlAdapters.isEmpty()) {
                constructorBody.append(sqlAdapters.stream().map(s -> "withComponent(" + s + "." + CLASS + ");").collect(Collectors.joining(separator)));
            }
            this.databaseBundleClassNames((Project)project).map(cn -> Formatting.nl() + "withBundle(" + Formatting.shortName((String)cn) + "." + CLASS + ");").forEach(constructorBody::append);
            this.databaseBundleClassNames((Project)project).map(cn -> Import.of((Type)SimpleType.create((String)cn))).forEach(arg_0 -> ((File)file).add(arg_0));
            Type injectorProxyType = this.injectorProxyType();
            constructorBody.append(Formatting.nl()).append("withInjectorProxy(new ").append(Formatting.shortName((String)injectorProxyType.getTypeName())).append("());");
            file.add(Import.of((Type)this.injectorProxyType()));
            constr.add(constructorBody.toString());
            ((com.speedment.common.codegen.model.Class)((com.speedment.common.codegen.model.Class)((com.speedment.common.codegen.model.Class)((com.speedment.common.codegen.model.Class)clazz.public_()).abstract_()).setSupertype((Type)SimpleParameterizedType.create(AbstractApplicationBuilder.class, (Type[])new Type[]{this.applicationType(), this.builderType()}))).add(constr)).add(build);
        }).build();
    }

    protected Javadoc getJavaDoc() {
        String owner = this.infoComponent().getTitle();
        return (Javadoc)Javadoc.of((String)(this.getJavadocRepresentText() + this.getGeneratedJavadocMessage())).add(DefaultJavadocTag.AUTHOR.setValue(owner));
    }

    protected String getJavadocRepresentText() {
        return "A generated base {@link " + AbstractApplicationBuilder.class.getName() + "} class for the {@link " + Project.class.getName() + "} named " + this.getSupport().projectOrThrow().getId() + ".";
    }

    protected String getClassOrInterfaceName() {
        return "Generated" + this.getSupport().typeName(this.getSupport().projectOrThrow()) + "ApplicationBuilder";
    }

    private Type builderType() {
        return SimpleType.create((String)(this.getSupport().basePackageName() + "." + this.getSupport().typeName(this.getSupport().projectOrThrow()) + "ApplicationBuilder"));
    }

    private Type applicationType() {
        return SimpleType.create((String)(this.getSupport().basePackageName() + "." + this.getSupport().typeName(this.getSupport().projectOrThrow()) + "Application"));
    }

    private Type applicationImplType() {
        return SimpleType.create((String)(this.getSupport().basePackageName() + "." + this.getSupport().typeName(this.getSupport().projectOrThrow()) + "ApplicationImpl"));
    }

    private Type injectorProxyType() {
        return SimpleType.create((String)(this.getSupport().basePackageName() + "." + this.getSupport().typeName(this.getSupport().projectOrThrow()) + "InjectorProxy"));
    }

    private Stream<String> databaseBundleClassNames(Project project) {
        return DocumentDbUtil.traverseOver((Project)project, Dbms.class).filter(HasEnabled::test).map(Dbms::getTypeName).map(this::toBundleClassName).filter(Optional::isPresent).map(Optional::get);
    }

    private Optional<String> toBundleClassName(String typeName) {
        Map bundles = Stream.of(MySqlBundle.class, MariaDbBundle.class, PostgresBundle.class, SqliteBundle.class).collect(Collectors.toMap(this::stripBundle, Function.identity()));
        return bundles.entrySet().stream().filter(e -> typeName.toLowerCase().contains(((String)e.getKey()).toLowerCase())).map(Map.Entry::getValue).map(Class::getName).findAny();
    }

    private String stripBundle(Class<? extends InjectBundle> clazz) {
        String simpleName = clazz.getSimpleName();
        int lastIndex = simpleName.lastIndexOf("Bundle");
        if (lastIndex == -1) {
            throw new SpeedmentException("The class " + clazz + " does not contain a substring 'Bundle'");
        }
        return simpleName.substring(0, lastIndex);
    }
}

