/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.generator.standard.lifecycle;

import com.speedment.common.codegen.constant.DefaultAnnotationUsage;
import com.speedment.common.codegen.constant.DefaultJavadocTag;
import com.speedment.common.codegen.constant.DefaultType;
import com.speedment.common.codegen.model.AnnotationUsage;
import com.speedment.common.codegen.model.Class;
import com.speedment.common.codegen.model.Field;
import com.speedment.common.codegen.model.File;
import com.speedment.common.codegen.model.Import;
import com.speedment.common.codegen.model.Javadoc;
import com.speedment.common.codegen.model.Method;
import com.speedment.common.codegen.model.Value;
import com.speedment.common.codegen.util.Formatting;
import com.speedment.common.injector.Injector;
import com.speedment.common.json.Json;
import com.speedment.generator.translator.AbstractJavaClassTranslator;
import com.speedment.runtime.application.AbstractApplicationMetadata;
import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.Project;
import com.speedment.runtime.config.mutator.ProjectMutator;
import com.speedment.runtime.config.util.DocumentTranscoder;
import com.speedment.runtime.core.ApplicationMetadata;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class GeneratedMetadataTranslator
extends AbstractJavaClassTranslator<Project, Class> {
    private static final int LINES_PER_METHOD = 100;
    private static final String INIT_PART_METHOD_NAME = "initPart";
    private static final String STRING_BUILDER_NAME = "sb";
    static final String METADATA = "Metadata";

    public GeneratedMetadataTranslator(Injector injector, Project doc) {
        super(injector, (Document)doc, Class::of);
    }

    public boolean isInGeneratedPackage() {
        return true;
    }

    protected Class makeCodeGenModel(File file) {
        Objects.requireNonNull(file);
        Method getMetadata = (Method)((Method)Method.of((String)"getMetadata", (Type)DefaultType.optional(String.class)).protected_()).add((AnnotationUsage)DefaultAnnotationUsage.OVERRIDE);
        Field metadataField = (Field)((Field)((Field)Field.of((String)"METADATA", String.class).private_()).final_()).static_();
        Method initializer = (Method)((Method)Method.of((String)"init", String.class).static_()).private_();
        ProjectMutator project = Project.deepCopy((Project)this.getSupport().projectOrThrow()).mutator();
        project.setSpeedmentVersion(this.infoComponent().getEditionAndVersionString());
        List lines = Stream.of(DocumentTranscoder.save((Project)((Project)project.document()), Json::toJson).split("\\R")).collect(Collectors.toList());
        ArrayList segments = new ArrayList();
        ArrayList<String> segment = new ArrayList<String>();
        segments.add(segment);
        for (String line : lines) {
            segment.add(line);
            if (segment.size() <= 100) continue;
            segment = new ArrayList();
            segments.add(segment);
        }
        ArrayList subInitializers = new ArrayList();
        segments.stream().map(seg -> {
            Method subMethod = this.addNewSubMethod(subInitializers);
            int lineCnt = 0;
            for (String line : seg) {
                subMethod.add(Formatting.indent((String)("\"" + line.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n") + "\"" + (++lineCnt == seg.size() ? "" : ","))));
            }
            return subMethod;
        }).forEach(subMethod -> subMethod.add(").forEachOrdered(sb::append);"));
        file.add(Import.of(StringBuilder.class));
        file.add(Import.of(Stream.class));
        initializer.add("final StringBuilder sb = new StringBuilder();");
        subInitializers.forEach(si -> initializer.add(si.getName() + "(" + STRING_BUILDER_NAME + ");"));
        initializer.add("return sb.toString();");
        metadataField.set((Value)Value.ofReference((String)"init()"));
        getMetadata.add("return Optional.of(METADATA);");
        return (Class)this.newBuilder(file, this.getClassOrInterfaceName()).forEveryProject((clazz, p) -> {
            ((Class)((Class)((Class)((Class)clazz.public_()).setSupertype(AbstractApplicationMetadata.class)).add(metadataField)).add(initializer)).add(getMetadata);
            subInitializers.forEach(arg_0 -> ((Class)clazz).add(arg_0));
        }).build();
    }

    private Method addNewSubMethod(List<Method> methods) {
        Method m = (Method)((Method)((Method)Method.of((String)(INIT_PART_METHOD_NAME + methods.size()), Void.TYPE).private_()).static_()).add(Field.of((String)STRING_BUILDER_NAME, StringBuilder.class));
        methods.add(m);
        m.add("Stream.of(");
        return m;
    }

    protected Javadoc getJavaDoc() {
        String owner = this.infoComponent().getTitle();
        return (Javadoc)Javadoc.of((String)(this.getJavadocRepresentText() + this.getGeneratedJavadocMessage())).add(DefaultJavadocTag.AUTHOR.setValue(owner));
    }

    protected String getJavadocRepresentText() {
        return "A {@link " + ApplicationMetadata.class.getName() + "} class for the {@link " + Project.class.getName() + "} named " + this.getSupport().projectOrThrow().getId() + ". This class contains the meta data present at code generation time.";
    }

    protected String getClassOrInterfaceName() {
        return "Generated" + this.getSupport().typeName(this.getSupport().projectOrThrow()) + METADATA;
    }
}

