/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.generator.standard.manager;

import com.speedment.common.codegen.constant.DefaultAnnotationUsage;
import com.speedment.common.codegen.constant.DefaultType;
import com.speedment.common.codegen.constant.SimpleParameterizedType;
import com.speedment.common.codegen.constant.SimpleType;
import com.speedment.common.codegen.model.AnnotationUsage;
import com.speedment.common.codegen.model.Constructor;
import com.speedment.common.codegen.model.Field;
import com.speedment.common.codegen.model.File;
import com.speedment.common.codegen.model.Import;
import com.speedment.common.codegen.model.Method;
import com.speedment.common.codegen.model.Value;
import com.speedment.common.codegen.model.trait.HasName;
import com.speedment.common.codegen.util.Formatting;
import com.speedment.common.injector.Injector;
import com.speedment.common.injector.State;
import com.speedment.common.injector.annotation.ExecuteBefore;
import com.speedment.generator.standard.internal.util.GenerateMethodBodyUtil;
import com.speedment.generator.translator.AbstractEntityAndManagerTranslator;
import com.speedment.generator.translator.TranslatorSupport;
import com.speedment.generator.translator.exception.SpeedmentTranslatorException;
import com.speedment.runtime.config.Column;
import com.speedment.runtime.config.Dbms;
import com.speedment.runtime.config.Project;
import com.speedment.runtime.config.Schema;
import com.speedment.runtime.config.Table;
import com.speedment.runtime.config.identifier.TableIdentifier;
import com.speedment.runtime.config.trait.HasEnabled;
import com.speedment.runtime.config.trait.HasTypeMapper;
import com.speedment.runtime.core.component.DbmsHandlerComponent;
import com.speedment.runtime.core.component.ProjectComponent;
import com.speedment.runtime.core.component.SqlAdapter;
import com.speedment.runtime.core.component.resultset.ResultSetMapperComponent;
import com.speedment.runtime.core.component.resultset.ResultSetMapping;
import com.speedment.runtime.core.component.sql.SqlTypeMapperHelper;
import com.speedment.runtime.core.db.SqlFunction;
import com.speedment.runtime.core.util.DatabaseUtil;
import com.speedment.runtime.core.util.ResultSetUtil;
import com.speedment.runtime.typemapper.TypeMapper;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class GeneratedSqlAdapterTranslator
extends AbstractEntityAndManagerTranslator<com.speedment.common.codegen.model.Class> {
    public static final String CREATE_HELPERS_METHOD_NAME = "createHelpers";
    public static final String INSTALL_METHOD_NAME = "installMethodName";
    public static final String OFFSET_PARAMETER_NAME = "offset";
    private final ResultSetMapperComponent resultSetMapperComponent;
    private final DbmsHandlerComponent dbmsHandlerComponent;
    private static final Set<Class<?>> NULL_AWARE_GETTERS = Stream.of(String.class, BigDecimal.class, Time.class, Date.class, Timestamp.class, Blob.class, Clob.class, Object.class).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));

    public GeneratedSqlAdapterTranslator(Injector injector, Table table) {
        super(injector, table, com.speedment.common.codegen.model.Class::of);
        this.resultSetMapperComponent = (ResultSetMapperComponent)injector.getOrThrow(ResultSetMapperComponent.class);
        this.dbmsHandlerComponent = (DbmsHandlerComponent)injector.getOrThrow(DbmsHandlerComponent.class);
    }

    protected com.speedment.common.codegen.model.Class makeCodeGenModel(File file) {
        SimpleParameterizedType tableIdentifierType = SimpleParameterizedType.create(TableIdentifier.class, (Type[])new Type[]{this.getSupport().entityType()});
        return (com.speedment.common.codegen.model.Class)this.newBuilder(file, this.getClassOrInterfaceName()).forEveryTable((arg_0, arg_1) -> this.lambda$makeCodeGenModel$8(file, (Type)tableIdentifierType, arg_0, arg_1)).build();
    }

    private Method generateCreateEntity(File file) {
        Type entityImplType = this.getSupport().entityImplType();
        file.add(Import.of((Type)entityImplType));
        return (Method)((Method)Method.of((String)"createEntity", (Type)entityImplType).protected_()).add("return new " + this.getSupport().entityImplName() + "();");
    }

    protected String getJavadocRepresentText() {
        return "The generated Sql Adapter for a {@link " + this.getSupport().entityType().getTypeName() + "} entity.";
    }

    protected String getClassOrInterfaceName() {
        return this.getSupport().generatedSqlAdapterName();
    }

    public boolean isInGeneratedPackage() {
        return true;
    }

    private Method generateApplyResultSet(TranslatorSupport<Table> support, File file, Supplier<Stream<? extends Column>> columnsSupplier) {
        return (Method)((Method)((Method)((Method)((Method)Method.of((String)"apply", (Type)support.entityType()).protected_()).add(SQLException.class)).add(Field.of((String)"resultSet", ResultSet.class))).add(Field.of((String)OFFSET_PARAMETER_NAME, Integer.TYPE))).add(GenerateMethodBodyUtil.generateApplyResultSetBody(this::readFromResultSet, support, file, columnsSupplier));
    }

    private String readFromResultSet(File file, Column c, AtomicInteger position) {
        Dbms dbms = (Dbms)((Schema)((Table)c.getParentOrThrow()).getParentOrThrow()).getParentOrThrow();
        ResultSetMapping mapping = this.resultSetMapperComponent.apply(DatabaseUtil.dbmsTypeOf((DbmsHandlerComponent)this.dbmsHandlerComponent, (Dbms)((Dbms)((Schema)((Table)c.getParentOrThrow()).getParentOrThrow()).getParentOrThrow())), c.findDatabaseType());
        Class<?> typeMapperClass = this.typeMappers().get((HasTypeMapper)c).getClass();
        boolean isCustomTypeMapper = c.getTypeMapper().isPresent() && !TypeMapper.identity().getClass().isAssignableFrom(typeMapperClass) && !TypeMapper.primitive().getClass().isAssignableFrom(typeMapperClass);
        StringBuilder sb = new StringBuilder();
        if (isCustomTypeMapper) {
            sb.append(this.helperName(c)).append(".apply(");
        }
        String getterName = "get" + mapping.getResultSetMethodName(dbms);
        if (!NULL_AWARE_GETTERS.contains(mapping.getJavaClass())) {
            file.add(((Import)Import.of(ResultSetUtil.class).static_()).setStaticMember("*"));
            if (this.isCastingRequired(c, getterName)) {
                file.add(Import.of((Type)SimpleType.create((String)c.getDatabaseType())));
                sb.append("(").append(Formatting.shortName((String)c.getDatabaseType())).append(") ");
            }
            sb.append(getterName).append("(resultSet, ").append(position.getAndIncrement()).append(" + ").append(OFFSET_PARAMETER_NAME).append(")");
        } else {
            if (this.isCastingRequired(c, getterName)) {
                file.add(Import.of((Type)SimpleType.create((String)c.getDatabaseType())));
                sb.append("(").append(Formatting.shortName((String)c.getDatabaseType())).append(") ");
            }
            sb.append("resultSet.").append(getterName).append("(").append(position.getAndIncrement()).append(" + ").append(OFFSET_PARAMETER_NAME).append(")");
        }
        if (isCustomTypeMapper) {
            sb.append(")");
        }
        return sb.toString();
    }

    private boolean isCastingRequired(Column column, String getterName) {
        return "getObject".equals(getterName) && !Object.class.getName().equals(column.getDatabaseType());
    }

    private AnnotationUsage withExecuteBefore(File file) {
        file.add(((Import)Import.of(State.class).static_()).setStaticMember("RESOLVED"));
        return (AnnotationUsage)AnnotationUsage.of(ExecuteBefore.class).set((Value)Value.ofReference((String)"RESOLVED"));
    }

    private String helperName(Column column) {
        return this.getSupport().namer().javaVariableName(column.getJavaName()) + "Helper";
    }

    private String availableTypeMappers() {
        return this.typeMappers().stream().map(Object::getClass).map(Class::getSimpleName).distinct().sorted().collect(Collectors.joining(", "));
    }

    private /* synthetic */ void lambda$makeCodeGenModel$8(File file, Type tableIdentifierType, com.speedment.common.codegen.model.Class clazz, Table table) {
        Method createHelpers = (Method)((Method)((Method)((Method)Method.of((String)CREATE_HELPERS_METHOD_NAME, Void.TYPE).public_()).add(this.withExecuteBefore(file))).add(Field.of((String)"projectComponent", ProjectComponent.class))).add("final Project project = projectComponent.getProject();");
        ((com.speedment.common.codegen.model.Class)((com.speedment.common.codegen.model.Class)((com.speedment.common.codegen.model.Class)((com.speedment.common.codegen.model.Class)((com.speedment.common.codegen.model.Class)((com.speedment.common.codegen.model.Class)((com.speedment.common.codegen.model.Class)((com.speedment.common.codegen.model.Class)((com.speedment.common.codegen.model.Class)((com.speedment.common.codegen.model.Class)clazz.public_()).abstract_()).add((Type)SimpleParameterizedType.create(SqlAdapter.class, (Type[])new Type[]{this.getSupport().entityType()}))).add((Constructor)((Constructor)Constructor.of().protected_()).add("this.tableIdentifier = " + TableIdentifier.class.getSimpleName() + ".of(" + Stream.of(this.getSupport().dbmsOrThrow().getId(), this.getSupport().schemaOrThrow().getId(), this.getSupport().tableOrThrow().getId()).map(s -> "\"" + s + "\"").collect(Collectors.joining(", ")) + ");"))).add((Field)((Field)Field.of((String)"tableIdentifier", (Type)tableIdentifierType).private_()).final_())).add(this.generateApplyResultSet((TranslatorSupport<Table>)this.getSupport(), file, () -> ((Table)table).columns()))).add(this.generateCreateEntity(file))).add((Method)((Method)((Method)Method.of((String)"identifier", (Type)tableIdentifierType).public_()).add((AnnotationUsage)DefaultAnnotationUsage.OVERRIDE)).add("return tableIdentifier;"))).add((Method)((Method)((Method)Method.of((String)"entityMapper", (Type)SimpleParameterizedType.create(SqlFunction.class, (Type[])new Type[]{ResultSet.class, this.getSupport().entityType()})).public_()).add((AnnotationUsage)DefaultAnnotationUsage.OVERRIDE)).add("return entityMapper(0);"))).add((Method)((Method)((Method)((Method)Method.of((String)"entityMapper", (Type)SimpleParameterizedType.create(SqlFunction.class, (Type[])new Type[]{ResultSet.class, this.getSupport().entityType()})).public_()).add((AnnotationUsage)DefaultAnnotationUsage.OVERRIDE)).add(Field.of((String)OFFSET_PARAMETER_NAME, Integer.TYPE))).add("return rs -> apply(rs, offset);"))).call(() -> table.columns().filter(HasEnabled::test).filter(c -> c.getTypeMapper().filter(tm -> !"".equals(tm)).filter(tm -> !tm.equals(TypeMapper.identity().getClass().getName())).filter(tm -> !tm.equals(TypeMapper.primitive().getClass().getName())).isPresent()).forEachOrdered(col -> {
            if (clazz.getMethods().stream().map(HasName::getName).noneMatch(CREATE_HELPERS_METHOD_NAME::equals)) {
                file.add(Import.of(Project.class));
                clazz.add(createHelpers);
            }
            TypeMapper tm = this.typeMappers().get((HasTypeMapper)col);
            Type javaType = tm.getJavaType(col);
            String tmsName = this.helperName((Column)col);
            SimpleParameterizedType tmsType = SimpleParameterizedType.create(SqlTypeMapperHelper.class, (Type[])new Type[]{(Type)this.typeMappers().findDatabaseTypeOf(tm).orElseThrow(() -> new SpeedmentTranslatorException("Could not find appropriate database type for column '" + col + "'. Available TypeMappers: " + this.availableTypeMappers())), DefaultType.isPrimitive((Type)javaType) ? DefaultType.wrapperFor((Type)javaType) : javaType});
            clazz.add((Field)Field.of((String)tmsName, (Type)tmsType).private_());
            createHelpers.add(tmsName + " = " + SqlTypeMapperHelper.class.getSimpleName() + ".create(project, " + this.getSupport().entityName() + "." + this.getSupport().namer().javaStaticFieldName(col.getJavaName()) + ", " + this.getSupport().entityName() + ".class);");
        }));
    }
}

