/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.generator.standard.util;

import com.speedment.common.codegen.model.Interface;
import com.speedment.common.injector.Injector;
import com.speedment.generator.standard.StandardTranslatorKey;
import com.speedment.generator.translator.JavaClassTranslator;
import com.speedment.generator.translator.component.CodeGenerationComponent;
import com.speedment.runtime.config.Column;
import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.ForeignKey;
import com.speedment.runtime.config.ForeignKeyColumn;
import com.speedment.runtime.config.Table;
import com.speedment.runtime.config.trait.HasName;
import com.speedment.runtime.config.util.DocumentUtil;
import com.speedment.runtime.core.exception.SpeedmentException;
import java.util.NoSuchElementException;
import java.util.Objects;

public final class FkHolder {
    private final CodeGenerationComponent codeGenerationComponent;
    private final ForeignKey fk;
    private final ForeignKeyColumn fkc;
    private final Column column;
    private final Table table;
    private final Column foreignColumn;
    private final Table foreignTable;

    public FkHolder(Injector injector, ForeignKey fk) {
        Objects.requireNonNull(injector);
        Objects.requireNonNull(fk);
        this.codeGenerationComponent = (CodeGenerationComponent)injector.getOrThrow(CodeGenerationComponent.class);
        this.fk = fk;
        this.fkc = (ForeignKeyColumn)fk.foreignKeyColumns().findFirst().orElseThrow(this::noEnabledForeignKeyException);
        this.column = this.fkc.findColumnOrThrow();
        this.table = (Table)DocumentUtil.ancestor((Document)this.column, Table.class).orElseThrow(NoSuchElementException::new);
        this.foreignColumn = (Column)this.fkc.findForeignColumn().orElseThrow(this::foreignKeyWasNullException);
        this.foreignTable = (Table)this.fkc.findForeignTable().orElseThrow(this::foreignKeyWasNullException);
    }

    public Column getColumn() {
        return this.column;
    }

    public Table getTable() {
        return this.table;
    }

    public Column getForeignColumn() {
        return this.foreignColumn;
    }

    public Table getForeignTable() {
        return this.foreignTable;
    }

    public JavaClassTranslator<Table, Interface> getEmt() {
        JavaClassTranslator translator = (JavaClassTranslator)this.codeGenerationComponent.findTranslator((HasName)this.getTable(), StandardTranslatorKey.MANAGER);
        return translator;
    }

    public JavaClassTranslator<Table, Interface> getForeignEmt() {
        JavaClassTranslator translator = (JavaClassTranslator)this.codeGenerationComponent.findTranslator((HasName)this.getForeignTable(), StandardTranslatorKey.MANAGER);
        return translator;
    }

    private IllegalStateException noEnabledForeignKeyException() {
        return new IllegalStateException("FK " + this.fk.getId() + " does not have an enabled ForeignKeyColumn");
    }

    private SpeedmentException foreignKeyWasNullException() {
        return new SpeedmentException("Could not find referenced foreign column '" + this.fkc.getForeignColumnName() + "' in table '" + this.fkc.getForeignTableName() + "'.");
    }
}

