/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.bulk.internal.builder;

import com.speedment.runtime.bulk.BulkOperation;
import com.speedment.runtime.bulk.Operation;
import com.speedment.runtime.bulk.internal.BulkOperationBuilder;
import com.speedment.runtime.bulk.internal.builder.PersistOperationBuilderImpl;
import com.speedment.runtime.bulk.internal.builder.RemoveOperationBuilderImpl;
import com.speedment.runtime.bulk.internal.builder.UpdateOperationBuilderImpl;
import com.speedment.runtime.core.manager.Manager;
import java.util.Objects;

public abstract class AbstractOperationBuilder<ENTITY>
implements BulkOperation.Builder {
    private final BulkOperationBuilder parent;
    private final Manager<ENTITY> manager;

    protected AbstractOperationBuilder(Manager<ENTITY> manager, BulkOperationBuilder parent) {
        this.manager = Objects.requireNonNull(manager);
        this.parent = Objects.requireNonNull(parent);
    }

    Manager<ENTITY> manager() {
        return this.manager;
    }

    BulkOperationBuilder parent() {
        return this.parent;
    }

    public <NEXT_ENTITY> BulkOperation.Builder.Persist<NEXT_ENTITY> persist(Manager<NEXT_ENTITY> manager) {
        Objects.requireNonNull(manager);
        this.parent().add(this.buildCurrent());
        return new PersistOperationBuilderImpl<NEXT_ENTITY>(manager, this.parent());
    }

    public <NEXT_ENTITY> BulkOperation.Builder.Update<NEXT_ENTITY> update(Manager<NEXT_ENTITY> manager) {
        Objects.requireNonNull(manager);
        this.parent().add(this.buildCurrent());
        return new UpdateOperationBuilderImpl<NEXT_ENTITY>(manager, this.parent());
    }

    public <NEXT_ENTITY> BulkOperation.Builder.Remove<NEXT_ENTITY> remove(Manager<NEXT_ENTITY> manager) {
        Objects.requireNonNull(manager);
        this.parent().add(this.buildCurrent());
        return new RemoveOperationBuilderImpl<NEXT_ENTITY>(manager, this.parent());
    }

    @Override
    public BulkOperation build() {
        this.parent().add(this.buildCurrent());
        return this.parent().build();
    }

    abstract Operation<ENTITY> buildCurrent();
}

