/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.actions.internal;

import com.speedment.common.invariant.NullUtil;
import com.speedment.common.mapstream.MapStream;
import com.speedment.runtime.config.trait.HasMainInterface;
import com.speedment.tool.actions.ProjectTreeComponent;
import com.speedment.tool.config.DocumentProperty;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TreeCell;

public final class ProjectTreeComponentImpl
implements ProjectTreeComponent {
    private final Map<Class<?>, List<ProjectTreeComponent.ContextMenuBuilder<?>>> contextMenuBuilders = new ConcurrentHashMap();

    @Override
    public <DOC extends DocumentProperty & HasMainInterface> void installContextMenu(Class<? extends DOC> nodeType, ProjectTreeComponent.ContextMenuBuilder<DOC> menuBuilder) {
        this.contextMenuBuilders.computeIfAbsent(nodeType, k -> new CopyOnWriteArrayList()).add(menuBuilder);
    }

    @Override
    public <DOC extends DocumentProperty & HasMainInterface> Optional<ContextMenu> createContextMenu(TreeCell<DocumentProperty> treeCell, DOC doc) {
        NullUtil.requireNonNulls(treeCell, doc);
        List builders = MapStream.of(this.contextMenuBuilders).filterKey(clazz -> clazz.isAssignableFrom(doc.getClass())).values().flatMap(Collection::stream).map(builder -> builder).collect(Collectors.toList());
        ContextMenu menu = new ContextMenu();
        for (int i = 0; i < builders.size(); ++i) {
            List<MenuItem> items = ((ProjectTreeComponent.ContextMenuBuilder)builders.get(i)).build(treeCell, doc).collect(Collectors.toList());
            if (i > 0 && !items.isEmpty()) {
                menu.getItems().add((Object)new SeparatorMenuItem());
            }
            items.forEach(arg_0 -> menu.getItems().add(arg_0));
        }
        if (menu.getItems().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(menu);
    }
}

