/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.actions.internal.menues;

import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.util.DocumentUtil;
import com.speedment.tool.actions.ProjectTreeComponent;
import com.speedment.tool.actions.internal.menues.AbstractToolAction;
import com.speedment.tool.actions.internal.resources.ProjectTreeIcon;
import com.speedment.tool.actions.menues.ToggleExpandedAction;
import com.speedment.tool.config.DbmsProperty;
import com.speedment.tool.config.DocumentProperty;
import com.speedment.tool.config.SchemaProperty;
import com.speedment.tool.config.TableProperty;
import com.speedment.tool.config.trait.HasExpandedProperty;
import java.util.stream.Stream;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TreeCell;

public final class ToggleExpandedActionImpl
implements AbstractToolAction,
ToggleExpandedAction {
    static final String EXPAND_ALL = "Expand All";
    static final String COLLAPSE_ALL = "Collapse All";

    @Override
    public void installMenuItems(ProjectTreeComponent projectTree) {
        projectTree.installContextMenu(DbmsProperty.class, this::installForDocumentType);
        projectTree.installContextMenu(SchemaProperty.class, this::installForDocumentType);
        projectTree.installContextMenu(TableProperty.class, this::installForDocumentType);
    }

    private <DOC extends DocumentProperty> Stream<MenuItem> installForDocumentType(TreeCell<DocumentProperty> treeCell, DOC node) {
        MenuItem expandAll = new MenuItem(EXPAND_ALL, (Node)ProjectTreeIcon.BOOK_OPEN.view());
        MenuItem collapseAll = new MenuItem(COLLAPSE_ALL, (Node)ProjectTreeIcon.BOOK.view());
        expandAll.setOnAction(ev -> DocumentUtil.traverseOver((Document)node).filter(HasExpandedProperty.class::isInstance).forEach(doc -> ((HasExpandedProperty)doc).expandedProperty().setValue(Boolean.valueOf(true))));
        collapseAll.setOnAction(ev -> DocumentUtil.traverseOver((Document)node).filter(HasExpandedProperty.class::isInstance).forEach(doc -> ((HasExpandedProperty)doc).expandedProperty().setValue(Boolean.valueOf(false))));
        return Stream.of(expandAll, collapseAll);
    }
}

