/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.tool.actions.internal.menues;

import com.speedment.runtime.config.Document;
import com.speedment.runtime.config.util.DocumentUtil;
import com.speedment.tool.actions.ProjectTreeComponent;
import com.speedment.tool.actions.internal.menues.AbstractToolAction;
import com.speedment.tool.actions.menues.ToggleTablesEnabledAction;
import com.speedment.tool.config.SchemaProperty;
import com.speedment.tool.config.TableProperty;
import java.util.stream.Stream;
import javafx.scene.control.MenuItem;

public final class ToggleTablesEnabledActionImpl
implements AbstractToolAction,
ToggleTablesEnabledAction {
    static final String ENABLE_ALL_TABLES = "Enable All Tables";
    static final String DISABLE_ALL_TABLES = "Disable All Tables";

    @Override
    public void installMenuItems(ProjectTreeComponent projectTree) {
        projectTree.installContextMenu(SchemaProperty.class, (treeCell, node) -> {
            MenuItem enableTables = new MenuItem(ENABLE_ALL_TABLES);
            MenuItem disableTables = new MenuItem(DISABLE_ALL_TABLES);
            enableTables.setOnAction(ev -> DocumentUtil.traverseOver((Document)node).filter(TableProperty.class::isInstance).forEach(doc -> ((TableProperty)doc).enabledProperty().setValue(Boolean.valueOf(true))));
            disableTables.setOnAction(ev -> DocumentUtil.traverseOver((Document)node).filter(TableProperty.class::isInstance).forEach(doc -> ((TableProperty)doc).enabledProperty().setValue(Boolean.valueOf(false))));
            return Stream.of(enableTables, disableTables);
        });
    }
}

