/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.deser.impl;

import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonParser;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonToken;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;

public final class InnerClassProperty
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final SettableBeanProperty _delegate;
    protected final Constructor<?> _creator;

    public InnerClassProperty(SettableBeanProperty settableBeanProperty, Constructor<?> constructor) {
        super(settableBeanProperty);
        this._delegate = settableBeanProperty;
        this._creator = constructor;
    }

    protected InnerClassProperty(InnerClassProperty innerClassProperty, JsonDeserializer<?> jsonDeserializer) {
        super((SettableBeanProperty)innerClassProperty, jsonDeserializer);
        this._delegate = innerClassProperty._delegate.withValueDeserializer(jsonDeserializer);
        this._creator = innerClassProperty._creator;
    }

    protected InnerClassProperty(InnerClassProperty innerClassProperty, String string) {
        super((SettableBeanProperty)innerClassProperty, string);
        this._delegate = innerClassProperty._delegate.withName(string);
        this._creator = innerClassProperty._creator;
    }

    @Override
    public InnerClassProperty withName(String string) {
        return new InnerClassProperty(this, string);
    }

    @Override
    public InnerClassProperty withValueDeserializer(JsonDeserializer<?> jsonDeserializer) {
        return new InnerClassProperty(this, jsonDeserializer);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return this._delegate.getAnnotation(clazz);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._delegate.getMember();
    }

    @Override
    public void deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException, JsonProcessingException {
        Object object2;
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NULL) {
            object2 = this._nullProvider == null ? null : this._nullProvider.nullValue(deserializationContext);
        } else if (this._valueTypeDeserializer != null) {
            object2 = this._valueDeserializer.deserializeWithType(jsonParser, deserializationContext, this._valueTypeDeserializer);
        } else {
            try {
                object2 = this._creator.newInstance(object);
            }
            catch (Exception exception) {
                ClassUtil.unwrapAndThrowAsIAE(exception, "Failed to instantiate class " + this._creator.getDeclaringClass().getName() + ", problem: " + exception.getMessage());
                object2 = null;
            }
            this._valueDeserializer.deserialize(jsonParser, deserializationContext, object2);
        }
        this.set(object, object2);
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException, JsonProcessingException {
        return this.setAndReturn(object, this.deserialize(jsonParser, deserializationContext));
    }

    @Override
    public final void set(Object object, Object object2) throws IOException {
        this._delegate.set(object, object2);
    }

    @Override
    public Object setAndReturn(Object object, Object object2) throws IOException {
        return this._delegate.setAndReturn(object, object2);
    }
}

