/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.com.fasterxml.jackson.datatype.guava.ser;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonGenerationException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonGenerator;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.BeanDescription;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.BeanProperty;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JavaType;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.SerializationConfig;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.type.MapLikeType;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;

public class MultimapSerializer
extends JsonSerializer<Multimap<?, ?>>
implements ContextualSerializer {
    private final MapLikeType type;
    private final BeanProperty property;
    private final JsonSerializer<Object> keySerializer;
    private final TypeSerializer valueTypeSerializer;
    private final JsonSerializer<Object> valueSerializer;

    public MultimapSerializer(SerializationConfig serializationConfig, MapLikeType mapLikeType, BeanDescription beanDescription, JsonSerializer<Object> jsonSerializer, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer2) {
        this.type = mapLikeType;
        this.property = null;
        this.keySerializer = jsonSerializer;
        this.valueTypeSerializer = typeSerializer;
        this.valueSerializer = jsonSerializer2;
    }

    protected MultimapSerializer(MultimapSerializer multimapSerializer, BeanProperty beanProperty, JsonSerializer<?> jsonSerializer, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer2) {
        this.type = multimapSerializer.type;
        this.property = beanProperty;
        this.keySerializer = jsonSerializer;
        this.valueTypeSerializer = typeSerializer;
        this.valueSerializer = jsonSerializer2;
    }

    protected MultimapSerializer withResolved(BeanProperty beanProperty, JsonSerializer<?> jsonSerializer, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer2) {
        return new MultimapSerializer(this, beanProperty, jsonSerializer, typeSerializer, jsonSerializer2);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        Object object;
        JsonSerializer<Object> jsonSerializer = this.valueSerializer;
        if (jsonSerializer == null) {
            object = this.type.getContentType();
            if (((JavaType)object).isFinal()) {
                jsonSerializer = serializerProvider.findValueSerializer((JavaType)object, beanProperty);
            }
        } else if (jsonSerializer instanceof ContextualSerializer) {
            jsonSerializer = ((ContextualSerializer)((Object)jsonSerializer)).createContextual(serializerProvider, beanProperty);
        }
        object = this.keySerializer;
        if (object == null) {
            object = serializerProvider.findKeySerializer(this.type.getKeyType(), beanProperty);
        } else if (object instanceof ContextualSerializer) {
            object = ((ContextualSerializer)object).createContextual(serializerProvider, beanProperty);
        }
        TypeSerializer typeSerializer = this.valueTypeSerializer;
        if (typeSerializer != null) {
            typeSerializer = typeSerializer.forProperty(beanProperty);
        }
        return this.withResolved(beanProperty, (JsonSerializer<?>)object, typeSerializer, jsonSerializer);
    }

    @Override
    public void serialize(Multimap<?, ?> multimap, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        jsonGenerator.writeStartObject();
        if (!multimap.isEmpty()) {
            this.serializeFields(multimap, jsonGenerator, serializerProvider);
        }
        jsonGenerator.writeEndObject();
    }

    @Override
    public void serializeWithType(Multimap<?, ?> multimap, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonGenerationException {
        typeSerializer.writeTypePrefixForObject(multimap, jsonGenerator);
        this.serializeFields(multimap, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffixForObject(multimap, jsonGenerator);
    }

    private final void serializeFields(Multimap<?, ?> multimap, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        for (Map.Entry entry : multimap.asMap().entrySet()) {
            if (this.keySerializer != null) {
                this.keySerializer.serialize(entry.getKey(), jsonGenerator, serializerProvider);
            } else {
                serializerProvider.findKeySerializer(serializerProvider.constructType((Type)((Object)String.class)), this.property).serialize(entry.getKey(), jsonGenerator, serializerProvider);
            }
            if (this.valueSerializer != null) {
                jsonGenerator.writeStartArray();
                for (Object e : (Collection)entry.getValue()) {
                    this.valueSerializer.serialize(e, jsonGenerator, serializerProvider);
                }
                jsonGenerator.writeEndArray();
                continue;
            }
            serializerProvider.defaultSerializeValue(Lists.newArrayList((Iterable)((Iterable)entry.getValue())), jsonGenerator);
        }
    }
}

