/*
 * Decompiled with CFR 0.152.
 */
package jersey.repackaged.com.google.common.base;

import com.spotify.docker.client.shaded.javax.annotation.Nullable;
import java.io.Serializable;
import jersey.repackaged.com.google.common.base.Absent;
import jersey.repackaged.com.google.common.base.Preconditions;
import jersey.repackaged.com.google.common.base.Present;

public abstract class Optional<T>
implements Serializable {
    public static <T> Optional<T> absent() {
        return Absent.INSTANCE;
    }

    public static <T> Optional<T> of(T reference) {
        return new Present<T>(Preconditions.checkNotNull(reference));
    }

    public static <T> Optional<T> fromNullable(@Nullable T nullableReference) {
        return nullableReference == null ? Optional.absent() : new Present<T>(nullableReference);
    }

    Optional() {
    }

    @Nullable
    public abstract T orNull();
}

