/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.google.common.io.ByteStreams;
import com.spotify.docker.client.LogMessage;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogReader
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(LogReader.class);
    private final InputStream stream;
    public static final int HEADER_SIZE = 8;
    public static final int FRAME_SIZE_OFFSET = 4;
    private volatile boolean closed;

    public LogReader(InputStream stream) {
        this.stream = stream;
    }

    public LogMessage nextMessage() throws IOException {
        byte[] frame;
        this.stream.mark(8);
        byte[] headerBytes = new byte[8];
        int n = ByteStreams.read((InputStream)this.stream, (byte[])headerBytes, (int)0, (int)8);
        if (n == 0) {
            return null;
        }
        if (n != 8) {
            throw new EOFException();
        }
        ByteBuffer header = ByteBuffer.wrap(headerBytes);
        int streamId = header.get();
        int idZ = header.getInt(0);
        if (idZ == 0 || idZ == 0x1000000 || idZ == 0x2000000) {
            header.position(4);
            int frameSize = header.getInt();
            frame = new byte[frameSize];
        } else {
            this.stream.reset();
            streamId = LogMessage.Stream.STDOUT.id();
            frame = new byte[this.stream.available()];
        }
        ByteStreams.readFully((InputStream)this.stream, (byte[])frame);
        return new LogMessage(streamId, ByteBuffer.wrap(frame));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            log.warn(this + " not closed properly");
            this.close();
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        ByteStreams.copy((InputStream)this.stream, (OutputStream)ByteStreams.nullOutputStream());
    }
}

