/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.google.common.base.MoreObjects;
import com.spotify.docker.client.jackson.UnixTimestampDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Date;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE)
public class Event {
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="from")
    private String from;
    @JsonProperty(value="time")
    @JsonDeserialize(using=UnixTimestampDeserializer.class)
    private Date time;

    public String status() {
        return this.status;
    }

    public String id() {
        return this.id;
    }

    public String from() {
        return this.from;
    }

    public Date time() {
        return this.time == null ? null : new Date(this.time.getTime());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event that = (Event)o;
        return Objects.equals(this.status, that.status) && Objects.equals(this.id, that.id) && Objects.equals(this.from, that.from) && Objects.equals(this.time, that.time);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.id, this.from, this.time);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("id", (Object)this.id).add("from", (Object)this.from).add("time", (Object)this.time).toString();
    }
}

